/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.items;

import com.infamous.dungeons_libraries.items.artifacts.ArtifactItem;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactUseContext;
import com.infamous.dungeons_libraries.network.BreakItemMessage;
import com.infamous.dungeons_mobs.entities.projectiles.WindcallerBlastProjectileEntity;
import com.infamous.dungeons_mobs.entities.summonables.WindcallerTornadoEntity;
import com.infamous.dungeons_mobs.interfaces.IHasInventorySprite;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.network.NetworkHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class WindcallerStaffItem
extends ArtifactItem
implements IHasInventorySprite {
    public WindcallerStaffItem(Item.Properties properties) {
        super(properties);
        this.procOnItemUse = true;
    }

    public InteractionResultHolder<ItemStack> procArtifact(ArtifactUseContext itemUseContext) {
        Level world = itemUseContext.getLevel();
        if (world.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)itemUseContext.getItemStack());
        }
        ItemStack itemUseContextItem = itemUseContext.getItemStack();
        Player player = itemUseContext.getPlayer();
        BlockPos itemUseContextPos = itemUseContext.getClickedPos();
        if (player != null) {
            this.shoot(player, itemUseContextPos.m_123341_(), (double)itemUseContextPos.m_123342_() + 0.5, itemUseContextPos.m_123343_());
            itemUseContextItem.m_41622_(1, (LivingEntity)player, entity -> NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new BreakItemMessage(entity.m_142049_(), itemUseContextItem)));
            ArtifactItem.putArtifactOnCooldown((Player)player, (Item)itemUseContextItem.m_41720_());
        }
        return InteractionResultHolder.m_19096_((Object)itemUseContextItem);
    }

    public int getCooldownInSeconds() {
        return 20;
    }

    public int getDurationInSeconds() {
        return 0;
    }

    private void shoot(Player mob, double targetX, double targetY, double targetZ) {
        double d1 = targetX - mob.m_20185_();
        double d2 = targetY - mob.m_20227_(0.5);
        double d3 = targetZ - mob.m_20189_();
        WindcallerBlastProjectileEntity smallfireballentity = new WindcallerBlastProjectileEntity(mob.f_19853_, (LivingEntity)mob, d1, 0.0, d3);
        smallfireballentity.m_6034_(mob.m_20185_(), mob.m_20227_(0.25), mob.m_20189_());
        mob.f_19853_.m_7967_((Entity)smallfireballentity);
        WindcallerTornadoEntity tornado = (WindcallerTornadoEntity)((EntityType)ModEntityTypes.TORNADO.get()).m_20615_(mob.f_19853_);
        tornado.m_20035_(mob.m_142538_(), 0.0f, 0.0f);
        tornado.m_5496_((SoundEvent)ModSoundEvents.WINDCALLER_BLAST_WIND.get(), 1.5f, 1.0f);
        tornado.setBlast(true);
        tornado.m_146922_(-mob.f_20885_ - 90.0f);
        ((ServerLevel)mob.f_19853_).m_47205_((Entity)tornado);
    }
}

