/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mixin;

import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.interfaces.BiomeSpecificRaider;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={Raid.class})
public class RaidMixin {
    private static final String RAID_WAVE_MEMBER_TYPE_FIELD = "f_37815_";
    @Shadow
    @Final
    private ServerLevel f_37675_;

    @ModifyVariable(at=@At(value="STORE", ordinal=0), method={"spawnGroup"})
    private Raider spawnNextWave(Raider abstractRaiderEntity, BlockPos blockPos) {
        if (!((Boolean)DungeonsMobsConfig.COMMON.ENABLE_BIOME_SPECIFIC_RAIDERS.get()).booleanValue()) {
            return abstractRaiderEntity;
        }
        Holder raidBiome = this.f_37675_.m_204166_(blockPos);
        ResourceLocation biomeRegistryName = ((Biome)raidBiome.m_203334_()).getRegistryName();
        if (biomeRegistryName != null) {
            ResourceKey biomeRegistryKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)biomeRegistryName);
            Set raidBiomeTypes = BiomeDictionary.getTypes((ResourceKey)biomeRegistryKey);
            for (BiomeSpecificRaider currentBiomeSpecificRaider : BiomeSpecificRaider.values()) {
                EntityType originalRaiderType = abstractRaiderEntity != null ? abstractRaiderEntity.m_6095_() : null;
                EntityType<? extends Raider> currentBiomeSpecificRaiderType = currentBiomeSpecificRaider.getType();
                EntityType<? extends Raider> equivalentType = currentBiomeSpecificRaider.getEquivalentType();
                Set<BiomeDictionary.Type> biomeTypeSet = currentBiomeSpecificRaider.getBiomeTypeSet();
                boolean biomeTypeMatch = false;
                block1: for (BiomeDictionary.Type allowedBiomeType : biomeTypeSet) {
                    for (BiomeDictionary.Type raidBiomeType : raidBiomeTypes) {
                        if (raidBiomeType != allowedBiomeType) continue;
                        biomeTypeMatch = true;
                        continue block1;
                    }
                }
                if (!biomeTypeMatch && currentBiomeSpecificRaiderType == originalRaiderType) {
                    abstractRaiderEntity = (Raider)equivalentType.m_20615_((Level)this.f_37675_);
                    return abstractRaiderEntity;
                }
                boolean raiderFoundInWaveMembers = false;
                for (Raid.RaiderType waveMember : Raid.RaiderType.values()) {
                    EntityType waveMemberType = waveMember.f_37814_;
                    if (waveMemberType == null || waveMemberType != currentBiomeSpecificRaiderType) continue;
                    raiderFoundInWaveMembers = true;
                    break;
                }
                if (!biomeTypeMatch || originalRaiderType == null || currentBiomeSpecificRaiderType == null || originalRaiderType != equivalentType || raiderFoundInWaveMembers) continue;
                abstractRaiderEntity = (Raider)currentBiomeSpecificRaiderType.m_20615_((Level)this.f_37675_);
                return abstractRaiderEntity;
            }
        }
        return abstractRaiderEntity;
    }
}

