/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mobenchants;

import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.infamous.dungeons_mobs.mobenchants.NewMobEnchantUtils;
import com.infamous.dungeons_mobs.mod.ModMobEnchants;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DeflectMobEnchant
extends MobEnchant {
    public DeflectMobEnchant(MobEnchant.Properties properties) {
        super(properties);
    }

    @SubscribeEvent
    public static void onDeflectImpact(ProjectileImpactEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            HitResult rayTraceResult = event.getRayTraceResult();
            if (!DeflectMobEnchant.projectileHitLivingEntity(rayTraceResult)) {
                return;
            }
            if (!DeflectMobEnchant.shooterIsLiving(projectile)) {
                return;
            }
            LivingEntity victim = (LivingEntity)((EntityHitResult)rayTraceResult).m_82443_();
            if (DeflectMobEnchant.victimIsOwner(projectile, victim)) {
                event.setCanceled(true);
                return;
            }
            NewMobEnchantUtils.executeIfPresentWithLevel(victim, (MobEnchant)ModMobEnchants.DEFLECT.get(), level -> {
                if (projectile.f_19853_.f_46443_) {
                    DeflectMobEnchant.deflectProjectile(projectile, victim);
                    projectile.m_5602_((Entity)victim);
                    event.setCanceled(true);
                } else {
                    DeflectMobEnchant.deflectProjectile(projectile, victim);
                    projectile.m_5602_((Entity)victim);
                    event.setCanceled(true);
                }
            });
        }
    }

    private static void deflectProjectile(Projectile projectile, LivingEntity victim) {
        if (projectile instanceof ShulkerBullet) {
            ((ShulkerBullet)projectile).f_37312_ = projectile.m_37282_();
        } else {
            Vec3 deltaMovement = projectile.m_20184_();
            double speed = Mth.m_14116_((float)((float)(deltaMovement.f_82479_ * deltaMovement.f_82479_ + deltaMovement.f_82480_ * deltaMovement.f_82480_ + deltaMovement.f_82481_ * deltaMovement.f_82481_)));
            speed = speed < 1.0E-4 ? 0.0 : speed;
            double d0 = projectile.m_37282_().m_20185_() - victim.m_20185_();
            double d1 = projectile.m_37282_().m_20227_(0.3333333333333333) - projectile.m_20186_();
            double d2 = projectile.m_37282_().m_20189_() - victim.m_20189_();
            double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
            projectile.m_6686_(d0, d1 + d3 * (double)0.2f, d2, (float)speed, (float)(14 - victim.f_19853_.m_46791_().m_19028_() * 4));
        }
    }

    private static boolean victimIsOwner(Projectile projectile, LivingEntity victim) {
        return victim.equals((Object)projectile.m_37282_());
    }

    public static boolean projectileHitLivingEntity(HitResult rayTraceResult) {
        if (rayTraceResult instanceof EntityHitResult) {
            EntityHitResult entityRayTraceResult = (EntityHitResult)rayTraceResult;
            return entityRayTraceResult.m_82443_() instanceof LivingEntity;
        }
        return false;
    }

    public static boolean shooterIsLiving(Projectile projectile) {
        return projectile.m_37282_() != null && projectile.m_37282_() instanceof LivingEntity;
    }
}

