/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mod;

import com.infamous.dungeons_libraries.items.gearconfig.ArmorGear;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_mobs.DungeonsMobs;
import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.items.BlueNethershroomItem;
import com.infamous.dungeons_mobs.items.ColoredTridentItem;
import com.infamous.dungeons_mobs.items.CustomArmorMaterial;
import com.infamous.dungeons_mobs.items.GeomancerStaffItem;
import com.infamous.dungeons_mobs.items.MountaineerAxeItem;
import com.infamous.dungeons_mobs.items.NecromancerStaffItem;
import com.infamous.dungeons_mobs.items.NecromancerTridentItem;
import com.infamous.dungeons_mobs.items.PiglinHelmetItem;
import com.infamous.dungeons_mobs.items.WindcallerStaffItem;
import com.infamous.dungeons_mobs.items.WoodenLadleItem;
import com.infamous.dungeons_mobs.items.armor.DrownedNecromancerArmorGear;
import com.infamous.dungeons_mobs.items.armor.IceologerArmorGear;
import com.infamous.dungeons_mobs.items.armor.IllusionerArmorGear;
import com.infamous.dungeons_mobs.items.armor.MageArmorGear;
import com.infamous.dungeons_mobs.items.armor.NecromancerArmorGear;
import com.infamous.dungeons_mobs.items.armor.WindcallerArmorGear;
import com.infamous.dungeons_mobs.items.shield.RoyalGuardShieldItem;
import com.infamous.dungeons_mobs.items.shield.VanguardShieldItem;
import com.infamous.dungeons_mobs.utils.GeneralHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModItems {
    private static final ResourceLocation DEFAULT_ANIMATION_RESOURCE = new ResourceLocation("dungeons_libraries", "animations/armor/armor_default.animation.json");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"dungeons_mobs");
    public static final Map<ResourceLocation, RegistryObject<Item>> ARTIFACTS = new HashMap<ResourceLocation, RegistryObject<Item>>();
    public static final Item.Properties ARMOR_PROPERTIES = (Boolean)DungeonsMobsConfig.Common.ENABLE_ITEM_TAB.get() != false ? new Item.Properties().m_41491_(DungeonsMobs.DUNGEONS_MOBS_ITEMS) : new Item.Properties();
    public static final Map<ResourceLocation, RegistryObject<Item>> ARMORS = new HashMap<ResourceLocation, RegistryObject<Item>>();
    public static final RegistryObject<Item> ROYAL_GUARD_SHIELD = ITEMS.register("royal_guard_shield", () -> new RoyalGuardShieldItem(new Item.Properties().m_41491_(DungeonsMobs.DUNGEONS_MOBS_ITEMS).m_41503_(336)));
    public static final RegistryObject<Item> VANGUARD_SHIELD = ITEMS.register("vanguard_shield", () -> new VanguardShieldItem(new Item.Properties().m_41491_(DungeonsMobs.DUNGEONS_MOBS_ITEMS).m_41503_(336)));
    public static final RegistryObject<Item> GOLD_PILLAGER_HELMET = ModItems.registerArmor("gold_pillager_helmet", () -> new ArmorGear(EquipmentSlot.HEAD, ARMOR_PROPERTIES, null, new ResourceLocation("dungeons_mobs", "geo/armor/pillager_helmet.geo.json"), new ResourceLocation("dungeons_mobs", "textures/models/armor/gold_pillager_helmet.png"), DEFAULT_ANIMATION_RESOURCE));
    public static final RegistryObject<Item> DIAMOND_PILLAGER_HELMET = ITEMS.register("diamond_pillager_helmet", () -> new ArmorGear(EquipmentSlot.HEAD, ARMOR_PROPERTIES, null, new ResourceLocation("dungeons_mobs", "geo/armor/pillager_helmet.geo.json"), new ResourceLocation("dungeons_mobs", "textures/models/armor/diamond_pillager_helmet.png"), DEFAULT_ANIMATION_RESOURCE));
    public static final RegistryObject<Item> GOLD_VINDICATOR_HELMET = ITEMS.register("gold_vindicator_helmet", () -> new ArmorGear(EquipmentSlot.HEAD, ARMOR_PROPERTIES, null, new ResourceLocation("dungeons_mobs", "geo/armor/vindicator_helmet.geo.json"), new ResourceLocation("dungeons_mobs", "textures/models/armor/gold_vindicator_helmet.png"), DEFAULT_ANIMATION_RESOURCE));
    public static final RegistryObject<Item> DIAMOND_VINDICATOR_HELMET = ITEMS.register("diamond_vindicator_helmet", () -> new ArmorGear(EquipmentSlot.HEAD, ARMOR_PROPERTIES, null, new ResourceLocation("dungeons_mobs", "geo/armor/vindicator_helmet.geo.json"), new ResourceLocation("dungeons_mobs", "textures/models/armor/diamond_vindicator_helmet.png"), DEFAULT_ANIMATION_RESOURCE));
    public static final RegistryObject<Item> NETHERITE_PIGLIN_HELMET = ITEMS.register("netherite_piglin_helmet", () -> new PiglinHelmetItem(CustomArmorMaterial.PURE_NETHERITE, EquipmentSlot.HEAD, new Item.Properties().m_41491_(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> CRACKED_NETHERITE_PIGLIN_HELMET = ITEMS.register("cracked_netherite_piglin_helmet", () -> new PiglinHelmetItem(CustomArmorMaterial.PURE_NETHERITE, EquipmentSlot.HEAD, new Item.Properties().m_41491_(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> GOLD_PIGLIN_HELMET = ITEMS.register("gold_piglin_helmet", () -> new PiglinHelmetItem((ArmorMaterial)ArmorMaterials.GOLD, EquipmentSlot.HEAD, new Item.Properties().m_41491_(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> CRACKED_GOLD_PIGLIN_HELMET = ITEMS.register("cracked_gold_piglin_helmet", () -> new PiglinHelmetItem((ArmorMaterial)ArmorMaterials.GOLD, EquipmentSlot.HEAD, new Item.Properties().m_41491_(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final ArmorSet CHEF_ARMOR = ModItems.registerArmorSet("chef_armor", "chef_helmet", "chef_chestplate", null, null);
    public static final ArmorSet DROWNED_NECROMANCER_ARMOR = ModItems.registerArmorSetDrownedNecromancer("drowned_necromancer_armor", "drowned_necromancer_helmet", "drowned_necromancer_chestplate", "drowned_necromancer_leggings", null);
    public static final ArmorSet GEOMANCER_ARMOR = ModItems.registerArmorSet("geomancer_armor", "geomancer_helmet", "geomancer_chestplate", null, null);
    public static final ArmorSet ICEOLOGER_ARMOR = ModItems.registerArmorSetIceologer("iceologer_armor", "iceologer_helmet", "iceologer_chestplate", "iceologer_leggings", "iceologer_boots");
    public static final ArmorSet ILLUSIONER_ARMOR = ModItems.registerArmorSetIllusioner("illusioner_armor", "illusioner_helmet", "illusioner_chestplate", "illusioner_leggings", "illusioner_boots");
    public static final ArmorSet NECROMANCER_ARMOR = ModItems.registerArmorSetNecromancerArmor("necromancer_armor", "necromancer_helmet", "necromancer_chestplate", "necromancer_leggings", null);
    public static final ArmorSet NETHERPLATE_ARMOR = ModItems.registerArmorSet("netherplate_armor", "netherplate_helmet", null, null, null);
    public static final ArmorSet ROYAL_GUARD_ARMOR = ModItems.registerArmorSet("royal_guard_armor", "royal_guard_helmet", "royal_guard_chestplate", "royal_guard_leggings", "royal_guard_boots");
    public static final ArmorSet VANGUARD_ARMOR = ModItems.registerArmorSet("vanguard_armor", "vanguard_helmet", "vanguard_chestplate", "vanguard_leggings", null);
    public static final ArmorSet WINDCALLER_ARMOR = ModItems.registerArmorSetWindcaller("windcaller_armor", "windcaller_helmet", "windcaller_chestplate", null, null);
    public static final ArmorSet FUNGUS_THROWER_ARMOR = ModItems.registerArmorSet("fungus_thrower_armor", "fungus_thrower_helmet", "fungus_thrower_chestplate", null, null);
    public static final ArmorSet MOUNTAINEER_ARMOR = ModItems.registerArmorSet("mountaineer_armor", "mountaineer_helmet", "mountaineer_chestplate", "mountaineer_leggings", "mountaineer_boots");
    public static final ArmorSet EXPEDITION_ARMOR = ModItems.registerArmorSet("expedition_armor", "expedition_helmet", "expedition_chestplate", "expedition_leggings", "expedition_boots");
    public static final ArmorSet ALPINE_ARMOR = ModItems.registerArmorSet("alpine_armor", "alpine_helmet", "alpine_chestplate", "alpine_leggings", "alpine_boots");
    public static final ArmorSet MAGE_ARMOR = ModItems.registerArmorSetMage("mage_armor", "mage_helmet", "mage_chestplate", "mage_leggings", "mage_boots");
    public static final RegistryObject<Item> WOODEN_LADLE = ITEMS.register("wooden_ladle", () -> new WoodenLadleItem((Tier)Tiers.WOOD, 0.5f, -2.0f, new Item.Properties().m_41491_(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> MOUNTAINEER_AXE = ITEMS.register("mountaineer_axe", () -> new MountaineerAxeItem((Tier)Tiers.IRON, 1, -2.8f, new Item.Properties().m_41491_(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> GOLD_MOUNTAINEER_AXE = ITEMS.register("gold_mountaineer_axe", () -> new MountaineerAxeItem((Tier)Tiers.IRON, 1, -2.8f, new Item.Properties().m_41491_(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> DIAMOND_MOUNTAINEER_AXE = ITEMS.register("diamond_mountaineer_axe", () -> new MountaineerAxeItem((Tier)Tiers.DIAMOND, 1, -2.8f, new Item.Properties().m_41491_(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> WINDCALLER_STAFF = ModItems.registerArtifact("windcaller_staff", () -> new WindcallerStaffItem(new Item.Properties().m_41491_(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> GEOMANCER_STAFF = ModItems.registerArtifact("geomancer_staff", () -> new GeomancerStaffItem(new Item.Properties().m_41491_(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> NECROMANCER_STAFF = ModItems.registerArtifact("necromancer_staff", () -> new NecromancerStaffItem(new Item.Properties().m_41491_(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> NECROMANCER_TRIDENT = ModItems.registerArtifact("necromancer_trident", () -> new NecromancerTridentItem(new Item.Properties().m_41491_(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> BLUE_NETHERSHROOM = ITEMS.register("blue_nethershroom", () -> new BlueNethershroomItem(new Item.Properties().m_41491_(DungeonsMobs.DUNGEONS_MOBS_ITEMS).m_41487_(16)));
    public static final RegistryObject<Item> YELLOW_TRIDENT = ITEMS.register("yellow_trident", () -> new ColoredTridentItem(new Item.Properties().m_41503_(250).m_41491_(DungeonsMobs.DUNGEONS_MOBS_ITEMS), DyeColor.YELLOW));
    public static final RegistryObject<Item> PURPLE_TRIDENT = ITEMS.register("purple_trident", () -> new ColoredTridentItem(new Item.Properties().m_41503_(250).m_41491_(DungeonsMobs.DUNGEONS_MOBS_ITEMS), DyeColor.PURPLE));

    private static ArmorSet registerArmorSet(String armorSetId, String helmetId, String chestId, String legsId, String bootsId, boolean animated) {
        ResourceLocation armorSet = new ResourceLocation("dungeons_mobs", armorSetId);
        ResourceLocation modelLocation = new ResourceLocation("dungeons_mobs", "geo/armor/" + armorSetId + ".geo.json");
        ResourceLocation textureLocation = new ResourceLocation("dungeons_mobs", "textures/models/armor/" + armorSetId + ".png");
        ResourceLocation animationFileLocation = animated ? new ResourceLocation("dungeons_mobs", "animations/armor/" + armorSetId + ".animation.json") : DEFAULT_ANIMATION_RESOURCE;
        return new ArmorSet(armorSet, ModItems.registerArmor(helmetId, () -> new ArmorGear(EquipmentSlot.HEAD, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(chestId, () -> new ArmorGear(EquipmentSlot.CHEST, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(legsId, () -> new ArmorGear(EquipmentSlot.LEGS, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(bootsId, () -> new ArmorGear(EquipmentSlot.FEET, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)));
    }

    private static ArmorSet registerArmorSet(String armorSetId, String helmetId, String chestId, String legsId, String bootsId, ResourceLocation animationFileLocation) {
        ResourceLocation armorSet = new ResourceLocation("dungeons_mobs", armorSetId);
        ResourceLocation modelLocation = new ResourceLocation("dungeons_mobs", "geo/armor/" + armorSetId + ".geo.json");
        ResourceLocation textureLocation = new ResourceLocation("dungeons_mobs", "textures/models/armor/" + armorSetId + ".png");
        return new ArmorSet(armorSet, ModItems.registerArmor(helmetId, () -> new ArmorGear(EquipmentSlot.HEAD, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(chestId, () -> new ArmorGear(EquipmentSlot.CHEST, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(legsId, () -> new ArmorGear(EquipmentSlot.LEGS, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(bootsId, () -> new ArmorGear(EquipmentSlot.FEET, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)));
    }

    private static ArmorSet registerArmorSet(String armorSetId, String helmetId, String chestId, String legsId, String bootsId) {
        return ModItems.registerArmorSet(armorSetId, helmetId, chestId, legsId, bootsId, false);
    }

    private static ArmorSet registerArmorSetMage(String armorSetId, String helmetId, String chestId, String legsId, String bootsId) {
        ResourceLocation armorSet = new ResourceLocation("dungeons_mobs", armorSetId);
        ResourceLocation modelLocation = new ResourceLocation("dungeons_mobs", "geo/armor/" + armorSetId + ".geo.json");
        ResourceLocation textureLocation = new ResourceLocation("dungeons_mobs", "textures/models/armor/" + armorSetId + ".png");
        ResourceLocation animationFileLocation = new ResourceLocation("dungeons_mobs", "animations/armor/cloaked_armor.animation.json");
        return new ArmorSet(armorSet, ModItems.registerArmor(helmetId, () -> new MageArmorGear(EquipmentSlot.HEAD, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(chestId, () -> new MageArmorGear(EquipmentSlot.CHEST, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(legsId, () -> new MageArmorGear(EquipmentSlot.LEGS, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(bootsId, () -> new MageArmorGear(EquipmentSlot.FEET, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)));
    }

    private static ArmorSet registerArmorSetWindcaller(String armorSetId, String helmetId, String chestId, String legsId, String bootsId) {
        ResourceLocation armorSet = new ResourceLocation("dungeons_mobs", armorSetId);
        ResourceLocation modelLocation = new ResourceLocation("dungeons_mobs", "geo/armor/" + armorSetId + ".geo.json");
        ResourceLocation textureLocation = new ResourceLocation("dungeons_mobs", "textures/models/armor/" + armorSetId + ".png");
        ResourceLocation animationFileLocation = new ResourceLocation("dungeons_mobs", "animations/armor/cloaked_armor.animation.json");
        return new ArmorSet(armorSet, ModItems.registerArmor(helmetId, () -> new WindcallerArmorGear(EquipmentSlot.HEAD, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(chestId, () -> new WindcallerArmorGear(EquipmentSlot.CHEST, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(legsId, () -> new WindcallerArmorGear(EquipmentSlot.LEGS, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(bootsId, () -> new WindcallerArmorGear(EquipmentSlot.FEET, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)));
    }

    private static ArmorSet registerArmorSetIceologer(String armorSetId, String helmetId, String chestId, String legsId, String bootsId) {
        ResourceLocation armorSet = new ResourceLocation("dungeons_mobs", armorSetId);
        ResourceLocation modelLocation = new ResourceLocation("dungeons_mobs", "geo/armor/" + armorSetId + ".geo.json");
        ResourceLocation textureLocation = new ResourceLocation("dungeons_mobs", "textures/models/armor/" + armorSetId + ".png");
        ResourceLocation animationFileLocation = new ResourceLocation("dungeons_mobs", "animations/armor/cloaked_armor.animation.json");
        return new ArmorSet(armorSet, ModItems.registerArmor(helmetId, () -> new IceologerArmorGear(EquipmentSlot.HEAD, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(chestId, () -> new IceologerArmorGear(EquipmentSlot.CHEST, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(legsId, () -> new IceologerArmorGear(EquipmentSlot.LEGS, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(bootsId, () -> new IceologerArmorGear(EquipmentSlot.FEET, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)));
    }

    private static ArmorSet registerArmorSetIllusioner(String armorSetId, String helmetId, String chestId, String legsId, String bootsId) {
        ResourceLocation armorSet = new ResourceLocation("dungeons_mobs", armorSetId);
        ResourceLocation modelLocation = new ResourceLocation("dungeons_mobs", "geo/armor/" + armorSetId + ".geo.json");
        ResourceLocation textureLocation = new ResourceLocation("dungeons_mobs", "textures/models/armor/" + armorSetId + ".png");
        ResourceLocation animationFileLocation = new ResourceLocation("dungeons_mobs", "animations/armor/cloaked_armor.animation.json");
        return new ArmorSet(armorSet, ModItems.registerArmor(helmetId, () -> new IllusionerArmorGear(EquipmentSlot.HEAD, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(chestId, () -> new IllusionerArmorGear(EquipmentSlot.CHEST, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(legsId, () -> new IllusionerArmorGear(EquipmentSlot.LEGS, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(bootsId, () -> new IllusionerArmorGear(EquipmentSlot.FEET, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)));
    }

    private static ArmorSet registerArmorSetDrownedNecromancer(String armorSetId, String helmetId, String chestId, String legsId, String bootsId) {
        ResourceLocation armorSet = new ResourceLocation("dungeons_mobs", armorSetId);
        ResourceLocation modelLocation = new ResourceLocation("dungeons_mobs", "geo/armor/" + armorSetId + ".geo.json");
        ResourceLocation textureLocation = new ResourceLocation("dungeons_mobs", "textures/models/armor/" + armorSetId + ".png");
        ResourceLocation animationFileLocation = new ResourceLocation("dungeons_mobs", "animations/armor/cloaked_armor.animation.json");
        return new ArmorSet(armorSet, ModItems.registerArmor(helmetId, () -> new DrownedNecromancerArmorGear(EquipmentSlot.HEAD, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(chestId, () -> new DrownedNecromancerArmorGear(EquipmentSlot.CHEST, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(legsId, () -> new DrownedNecromancerArmorGear(EquipmentSlot.LEGS, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), null);
    }

    private static ArmorSet registerArmorSetNecromancerArmor(String armorSetId, String helmetId, String chestId, String legsId, String bootsId) {
        ResourceLocation armorSet = new ResourceLocation("dungeons_mobs", armorSetId);
        ResourceLocation modelLocation = new ResourceLocation("dungeons_mobs", "geo/armor/" + armorSetId + ".geo.json");
        ResourceLocation textureLocation = new ResourceLocation("dungeons_mobs", "textures/models/armor/" + armorSetId + ".png");
        ResourceLocation animationFileLocation = new ResourceLocation("dungeons_mobs", "animations/armor/cloaked_armor.animation.json");
        return new ArmorSet(armorSet, ModItems.registerArmor(helmetId, () -> new NecromancerArmorGear(EquipmentSlot.HEAD, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(chestId, () -> new NecromancerArmorGear(EquipmentSlot.CHEST, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(legsId, () -> new NecromancerArmorGear(EquipmentSlot.LEGS, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), null);
    }

    private static RegistryObject<Item> registerArmor(String armorId, Supplier<Item> itemSupplier) {
        if (armorId == null) {
            return null;
        }
        RegistryObject register = ITEMS.register(armorId, itemSupplier);
        ARMORS.put(GeneralHelper.modLoc(armorId), (RegistryObject<Item>)register);
        return register;
    }

    private static RegistryObject<Item> registerArtifact(String meleeWeaponId, Supplier<Item> itemSupplier) {
        RegistryObject register = ITEMS.register(meleeWeaponId, itemSupplier);
        ARTIFACTS.put(GeneralHelper.modLoc(meleeWeaponId), (RegistryObject<Item>)register);
        return register;
    }
}

