/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.worldgen;

import com.infamous.dungeons_mobs.entities.creepers.IcyCreeperEntity;
import com.infamous.dungeons_mobs.entities.undead.FrozenZombieEntity;
import com.infamous.dungeons_mobs.entities.undead.JungleZombieEntity;
import com.infamous.dungeons_mobs.entities.undead.MossySkeletonEntity;
import com.infamous.dungeons_mobs.interfaces.IAquaticMob;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;

public class EntitySpawnPlacements {
    public static SpawnPlacements.Type IN_WATER_ON_GROUND;

    public static void createPlacementTypes() {
        IN_WATER_ON_GROUND = SpawnPlacements.Type.create((String)"in_water_on_ground", (iWorldReader, blockPos, entityType) -> {
            boolean inWater;
            BlockState blockstate = iWorldReader.m_8055_(blockPos);
            FluidState fluidstate = iWorldReader.m_6425_(blockPos);
            BlockPos above = blockPos.m_7494_();
            BlockPos below = blockPos.m_7495_();
            BlockState stateAtPos = iWorldReader.m_8055_(blockPos);
            boolean bl = inWater = fluidstate.m_205070_(FluidTags.f_13131_) && iWorldReader.m_6425_(below).m_205070_(FluidTags.f_13131_) && !iWorldReader.m_8055_(above).m_60796_((BlockGetter)iWorldReader, above);
            if (!stateAtPos.isValidSpawn(iWorldReader, below, SpawnPlacements.Type.ON_GROUND, entityType)) {
                return false;
            }
            boolean validEmptySpawn = EntitySpawnPlacements.isValidEmptySpawnBlockNoFluidCheck((BlockGetter)iWorldReader, blockPos, blockstate, entityType) && EntitySpawnPlacements.isValidEmptySpawnBlockNoFluidCheck((BlockGetter)iWorldReader, above, iWorldReader.m_8055_(above), entityType);
            return validEmptySpawn && inWater;
        });
    }

    public static boolean isValidEmptySpawnBlockNoFluidCheck(BlockGetter blockReader, BlockPos blockPos, BlockState blockState, EntityType<?> entityType) {
        if (blockState.m_60838_(blockReader, blockPos)) {
            return false;
        }
        if (blockState.m_60803_()) {
            return false;
        }
        if (blockState.m_204336_(BlockTags.f_13054_)) {
            return false;
        }
        return !entityType.m_20630_(blockState);
    }

    public static void initSpawnPlacements() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.WRAITH.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.FROZEN_ZOMBIE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FrozenZombieEntity::canFrozenZombieSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.ICY_CREEPER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, IcyCreeperEntity::canIcyCreeperSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.JUNGLE_ZOMBIE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, JungleZombieEntity::canJungleZombieSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.MOSSY_SKELETON.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, MossySkeletonEntity::canMossySkeletonSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.SKELETON_VANGUARD.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.NECROMANCER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.ROYAL_GUARD.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::canIllagerSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.MOUNTAINEER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::canIllagerSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.GEOMANCER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::canIllagerSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.ICEOLOGER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::canIllagerSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.ILLUSIONER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::canIllagerSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.ILLUSIONER_CLONE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::canIllagerSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.WINDCALLER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::canIllagerSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.SQUALL_GOLEM.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::canRaiderSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.REDSTONE_GOLEM.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.REDSTONE_CUBE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.CONJURED_SLIME.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_21400_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.WHISPERER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, EntitySpawnPlacements::canJungleMobSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.LEAPLEAF.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, EntitySpawnPlacements::canJungleMobSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.FUNGUS_THROWER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::checkPiglinSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.ZOMBIFIED_FUNGUS_THROWER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::checkZombifiedPiglinSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.WILDFIRE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33023_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.WAVEWHISPERER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::checkAquaticMobSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.DROWNED_NECROMANCER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::checkAquaticMobSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.SUNKEN_SKELETON.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::checkAquaticMobSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.BLASTLING.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.WATCHLING.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.SNARELING.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.ENDERSENT.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
    }

    public static boolean checkAquaticMobSpawnRules(EntityType<? extends Mob> type, ServerLevelAccessor serverWorld, MobSpawnType spawnReason, BlockPos blockPos, Random random) {
        boolean canSpawn;
        Holder biome = serverWorld.m_204166_(blockPos);
        boolean bl = canSpawn = serverWorld.m_46791_() != Difficulty.PEACEFUL && Monster.m_33008_((ServerLevelAccessor)serverWorld, (BlockPos)blockPos, (Random)random) && (spawnReason == MobSpawnType.SPAWNER || serverWorld.m_6425_(blockPos).m_205070_(FluidTags.f_13131_));
        if (!biome.m_203565_(Biomes.f_48208_) && !biome.m_203565_(Biomes.f_48212_)) {
            return random.nextInt(40) == 0 && IAquaticMob.isDeepEnoughToSpawn((LevelAccessor)serverWorld, blockPos) && canSpawn;
        }
        return random.nextInt(15) == 0 && canSpawn;
    }

    public static boolean checkZombifiedPiglinSpawnRules(EntityType<? extends ZombifiedPiglin> p_234351_0_, LevelAccessor p_234351_1_, MobSpawnType p_234351_2_, BlockPos p_234351_3_, Random p_234351_4_) {
        return p_234351_1_.m_46791_() != Difficulty.PEACEFUL && p_234351_1_.m_8055_(p_234351_3_.m_7495_()).m_60734_() != Blocks.f_50451_;
    }

    public static boolean checkPiglinSpawnRules(EntityType<? extends Piglin> p_234418_0_, LevelAccessor p_234418_1_, MobSpawnType p_234418_2_, BlockPos p_234418_3_, Random p_234418_4_) {
        return !p_234418_1_.m_8055_(p_234418_3_.m_7495_()).m_60713_(Blocks.f_50451_);
    }

    public static boolean canJungleMobSpawn(EntityType<? extends Monster> entityType, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos blockPos, Random rand) {
        return Monster.m_33017_(entityType, (ServerLevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)blockPos, (Random)rand) && (spawnReason == MobSpawnType.SPAWNER || EntitySpawnPlacements.canSeeSkyLight(world, blockPos));
    }

    public static boolean canIllagerSpawn(EntityType<? extends AbstractIllager> entityType, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos blockPos, Random rand) {
        return Monster.m_33017_(entityType, (ServerLevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)blockPos, (Random)rand) && (spawnReason == MobSpawnType.SPAWNER || EntitySpawnPlacements.canSeeSkyLight(world, blockPos));
    }

    public static boolean canRaiderSpawn(EntityType<? extends Raider> entityType, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos blockPos, Random rand) {
        return Monster.m_33017_(entityType, (ServerLevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)blockPos, (Random)rand) && (spawnReason == MobSpawnType.SPAWNER || EntitySpawnPlacements.canSeeSkyLight(world, blockPos));
    }

    private static boolean canSeeSkyLight(ServerLevelAccessor world, BlockPos blockPos) {
        return world.m_45517_(LightLayer.SKY, blockPos) > 4;
    }
}

