/*
 * Decompiled with CFR 0.152.
 */
package mod.id107.flexfov;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Window;
import java.nio.ByteBuffer;
import mod.id107.flexfov.Square;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class BufferManager {
    public static RenderTarget renderTarget;
    public static int[] textures;
    private static float minX;
    private static float maxX;
    private static float minY;
    private static float maxY;
    private static float fov;
    private static int oldDisplayWidth;
    private static int oldDisplayHeight;
    public static Square shaderSquare;
    public static Square passthroughSquare;

    public static void setupFrame() {
        Window window = Minecraft.m_91087_().m_91268_();
        if (window.m_85443_() != oldDisplayWidth || window.m_85444_() != oldDisplayHeight) {
            oldDisplayWidth = window.m_85443_();
            oldDisplayHeight = window.m_85444_();
            BufferManager.deleteRenderTarget();
            BufferManager.createRenderTarget();
        }
    }

    public static void createRenderTarget() {
        if (renderTarget != null) {
            return;
        }
        Window window = Minecraft.m_91087_().m_91268_();
        int screenWidth = window.m_85443_();
        int screenHeight = window.m_85444_();
        int size = Math.min(screenWidth, screenHeight);
        renderTarget = new TextureTarget(size, size, false, Minecraft.f_91002_);
        for (int i = 0; i < textures.length; ++i) {
            BufferManager.textures[i] = GL11.glGenTextures();
            GL11.glBindTexture((int)3553, (int)textures[i]);
            GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)size, (int)size, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        }
        GL11.glBindTexture((int)3553, (int)0);
        float aspectRatio = (float)screenWidth / (float)screenHeight;
        if (aspectRatio >= 1.0f) {
            minY = 0.0f;
            maxY = 1.0f;
            minX = 0.5f - 0.5f / aspectRatio;
            maxX = 0.5f + 0.5f / aspectRatio;
            fov = 90.0f;
        } else {
            minX = 0.0f;
            maxX = 1.0f;
            minY = 0.5f - 0.5f * aspectRatio;
            maxY = 0.5f + 0.5f * aspectRatio;
            fov = (float)Math.toDegrees(2.0 * Math.atan(Math.tan(Math.toRadians(45.0)) / (double)aspectRatio));
        }
        if (passthroughSquare == null) {
            passthroughSquare = new Square(new float[]{maxX, maxY, minX, maxY, minX, minY, minX, minY, maxX, minY, maxX, maxY});
        }
    }

    public static void deleteRenderTarget() {
        if (passthroughSquare != null) {
            passthroughSquare.close();
            passthroughSquare = null;
        }
        if (renderTarget == null) {
            return;
        }
        for (int i = 0; i < textures.length; ++i) {
            GL11.glDeleteTextures((int)textures[i]);
            BufferManager.textures[i] = -1;
        }
        renderTarget.m_83930_();
        renderTarget = null;
    }

    public static float getFov() {
        return fov;
    }

    static {
        textures = new int[6];
        oldDisplayWidth = -1;
        oldDisplayHeight = -1;
        shaderSquare = new Square();
    }
}

