/*
 * Decompiled with CFR 0.152.
 */
package mod.id107.flexfov;

import mod.id107.flexfov.gui.SettingsGui;
import mod.id107.flexfov.projection.Projection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.SliderButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventListener {
    private static boolean rendering = false;

    @SubscribeEvent
    public void onRenderTickStart(TickEvent.RenderTickEvent renderTickEvent) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ != null && minecraft.f_91072_ != null && renderTickEvent.phase == TickEvent.Phase.START) {
            Projection.getProjection().renderWorldStart(minecraft, renderTickEvent.renderTickTime);
        }
    }

    @SubscribeEvent
    public void onRenderLevelLast(RenderLevelLastEvent event) {
        if (!rendering) {
            rendering = true;
            Projection.getProjection().renderWorldPass(Minecraft.m_91087_(), event.getPartialTick(), event.getStartNanos(), event.getProjectionMatrix());
            rendering = false;
        }
    }

    @SubscribeEvent
    public void onFieldOfView(EntityViewRenderEvent.FieldOfView fieldOfViewEvent) {
        if (Projection.active) {
            fieldOfViewEvent.setFOV(Projection.getProjection().getPassFov(fieldOfViewEvent.getFOV()));
        }
    }

    @SubscribeEvent
    public void initScreen(ScreenEvent.InitScreenEvent.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof OptionsScreen) {
            int buttonX = screen.f_96543_ / 2 - 155;
            int buttonY = screen.f_96544_ / 6 - 12;
            int buttonWidth = 150;
            int buttonHeight = 20;
            SliderButton sliderButton = null;
            for (Widget widget : screen.f_169369_) {
                SliderButton button2;
                if (!(widget instanceof SliderButton) || !(button2 = (SliderButton)widget).m_6035_().toString().contains("'options.fov'")) continue;
                sliderButton = button2;
                break;
            }
            if (sliderButton != null) {
                event.removeListener(sliderButton);
                buttonX = sliderButton.f_93620_;
                buttonY = sliderButton.f_93621_;
                buttonWidth = sliderButton.m_5711_();
                buttonHeight = sliderButton.m_93694_();
                sliderButton.f_93620_ = screen.f_96543_ / 2 - 75;
                sliderButton.f_93621_ = screen.f_96544_ / 6 + 36;
                SettingsGui.fovSlider = sliderButton;
            }
            Button settingsGuiButton = new Button(buttonX, buttonY, buttonWidth, buttonHeight, (Component)new TranslatableComponent("options.fov"), button -> {
                Minecraft minecraft = screen.getMinecraft();
                minecraft.f_91066_.m_92169_();
                minecraft.m_91152_((Screen)SettingsGui.getScreen(screen));
            });
            event.addListener((GuiEventListener)settingsGuiButton);
        }
    }
}

