/*
 * Decompiled with CFR 0.152.
 */
package mod.id107.flexfov;

import org.lwjgl.opengl.GL20;

public class Shader {
    private int shaderProgram;
    private int vertexShader;
    private int fragmentShader;

    public void createShaderProgram(String vertexShaderIn, String fragmentShaderIn) {
        if (this.shaderProgram != 0) {
            return;
        }
        this.shaderProgram = GL20.glCreateProgram();
        this.vertexShader = Shader.createShader(vertexShaderIn, 35633);
        this.fragmentShader = Shader.createShader(fragmentShaderIn, 35632);
        GL20.glAttachShader((int)this.shaderProgram, (int)this.vertexShader);
        GL20.glAttachShader((int)this.shaderProgram, (int)this.fragmentShader);
        GL20.glBindAttribLocation((int)this.shaderProgram, (int)0, (CharSequence)"position");
        GL20.glBindAttribLocation((int)this.shaderProgram, (int)1, (CharSequence)"texPos");
        GL20.glLinkProgram((int)this.shaderProgram);
        int linked = GL20.glGetProgrami((int)this.shaderProgram, (int)35714);
        String programLog = GL20.glGetProgramInfoLog((int)this.shaderProgram);
        if (programLog.trim().length() > 0) {
            System.err.println(programLog);
        }
        if (linked == 0) {
            throw new AssertionError((Object)"Could not link program");
        }
    }

    private static int createShader(String source, int type) {
        int shader = GL20.glCreateShader((int)type);
        GL20.glShaderSource((int)shader, (CharSequence)source);
        GL20.glCompileShader((int)shader);
        int compiled = GL20.glGetShaderi((int)shader, (int)35713);
        String shaderLog = GL20.glGetShaderInfoLog((int)shader);
        if (shaderLog.trim().length() > 0) {
            System.err.println(shaderLog);
        }
        if (compiled == 0) {
            throw new AssertionError((Object)"Could not compile shader");
        }
        return shader;
    }

    public void deleteShaderProgram() {
        if (this.shaderProgram == 0) {
            return;
        }
        GL20.glDetachShader((int)this.shaderProgram, (int)this.vertexShader);
        GL20.glDetachShader((int)this.shaderProgram, (int)this.fragmentShader);
        GL20.glDeleteShader((int)this.vertexShader);
        this.vertexShader = 0;
        GL20.glDeleteShader((int)this.fragmentShader);
        this.fragmentShader = 0;
        GL20.glDeleteProgram((int)this.shaderProgram);
        this.shaderProgram = 0;
    }

    public int getShaderProgram() {
        return this.shaderProgram;
    }
}

