/*
 * Decompiled with CFR 0.152.
 */
package mod.id107.flexfov.projection;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import mod.id107.flexfov.BufferManager;
import mod.id107.flexfov.Reader;
import mod.id107.flexfov.Shader;
import mod.id107.flexfov.projection.Flex;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;

public abstract class Projection {
    public static boolean active = true;
    public static float fov = 180.0f;
    public static int antialiasing = 16;
    public static boolean skyBackground = true;
    private int[] textureId = new int[BufferManager.textures.length];
    private int renderPass = 4;
    private float yaw;
    private float pitch;
    private static Projection currentProjection = new Flex();
    private static Shader projectionShader = new Shader();
    private static Shader passthroughShader = new Shader();

    public static Projection getProjection() {
        return currentProjection;
    }

    public static void setProjection(Projection projection) {
        currentProjection = projection;
        projectionShader.deleteShaderProgram();
        projectionShader.createShaderProgram(projection.getVertexShader(), projection.getFragmentShader());
    }

    public String getVertexShader() {
        return Reader.read("flexfov:shaders/quad.vs");
    }

    public abstract String getFragmentShader();

    public void renderWorldStart(Minecraft minecraft, float partialTickTime) {
        BufferManager.setupFrame();
        Camera camera = minecraft.f_91063_.m_109153_();
        camera.m_90575_((BlockGetter)minecraft.f_91073_, (Entity)(minecraft.m_91288_() == null ? minecraft.f_91074_ : minecraft.m_91288_()), !minecraft.f_91066_.m_92176_().m_90612_(), minecraft.f_91066_.m_92176_().m_90613_(), partialTickTime);
        this.yaw = camera.m_90590_();
        this.pitch = camera.m_90589_();
    }

    public void renderWorldPass(Minecraft minecraft, float partialTickTime, long startTimeNano, Matrix4f projectionEffectMatrix) {
        this.saveRenderPass();
        Matrix4f projectionMatrix = minecraft.f_91063_.m_172716_(this.getPassFov(minecraft.f_91066_.f_92068_));
        Matrix4f invertedProjectionMatrix = projectionMatrix.m_27658_();
        invertedProjectionMatrix.m_27630_(1.0f / invertedProjectionMatrix.m_27652_());
        Matrix4f effectMatrix = projectionEffectMatrix.m_27658_();
        effectMatrix.multiplyBackward(invertedProjectionMatrix);
        this.renderPass = 0;
        this.renderLevel(minecraft, partialTickTime, startTimeNano, projectionMatrix.m_27658_(), effectMatrix);
        this.saveRenderPass();
        this.renderPass = 1;
        this.renderLevel(minecraft, partialTickTime, startTimeNano, projectionMatrix.m_27658_(), effectMatrix);
        this.saveRenderPass();
        this.renderPass = 2;
        this.renderLevel(minecraft, partialTickTime, startTimeNano, projectionMatrix.m_27658_(), effectMatrix);
        this.saveRenderPass();
        this.renderPass = 3;
        this.renderLevel(minecraft, partialTickTime, startTimeNano, projectionMatrix.m_27658_(), effectMatrix);
        this.saveRenderPass();
        this.renderPass = 5;
        this.renderLevel(minecraft, partialTickTime, startTimeNano, projectionMatrix.m_27658_(), effectMatrix);
        this.saveRenderPass();
        this.renderPass = 4;
        this.runShader();
    }

    protected void renderLevel(Minecraft minecraft, float partialTickTime, long startTimeNano, Matrix4f projectionMatrix, Matrix4f effectMatrix) {
        float Roll;
        float Pitch;
        float Yaw;
        switch (this.renderPass) {
            case 0: {
                Yaw = this.yaw - 90.0f;
                Pitch = 0.0f;
                Roll = this.pitch;
                projectionMatrix.m_27646_(Vector3f.f_122225_.m_122240_(-90.0f));
                projectionMatrix.m_27644_(effectMatrix);
                projectionMatrix.m_27646_(Vector3f.f_122225_.m_122240_(90.0f));
                break;
            }
            case 1: {
                Yaw = this.yaw + 90.0f;
                Pitch = 0.0f;
                Roll = -this.pitch;
                projectionMatrix.m_27646_(Vector3f.f_122225_.m_122240_(90.0f));
                projectionMatrix.m_27644_(effectMatrix);
                projectionMatrix.m_27646_(Vector3f.f_122225_.m_122240_(-90.0f));
                break;
            }
            case 2: {
                Yaw = this.yaw;
                Pitch = this.pitch + 90.0f;
                Roll = 0.0f;
                projectionMatrix.m_27646_(Vector3f.f_122223_.m_122240_(90.0f));
                projectionMatrix.m_27644_(effectMatrix);
                projectionMatrix.m_27646_(Vector3f.f_122223_.m_122240_(-90.0f));
                break;
            }
            case 3: {
                Yaw = this.yaw;
                Pitch = this.pitch - 90.0f;
                Roll = 0.0f;
                projectionMatrix.m_27646_(Vector3f.f_122223_.m_122240_(-90.0f));
                projectionMatrix.m_27644_(effectMatrix);
                projectionMatrix.m_27646_(Vector3f.f_122223_.m_122240_(90.0f));
                break;
            }
            default: {
                Yaw = this.yaw;
                Pitch = this.pitch;
                Roll = 0.0f;
                break;
            }
            case 5: {
                Yaw = this.yaw + 180.0f;
                Pitch = -this.pitch;
                Roll = 0.0f;
                projectionMatrix.m_27646_(Vector3f.f_122225_.m_122240_(180.0f));
                projectionMatrix.m_27644_(effectMatrix);
                projectionMatrix.m_27646_(Vector3f.f_122225_.m_122240_(180.0f));
            }
        }
        minecraft.f_91063_.m_109111_(projectionMatrix);
        Camera camera = minecraft.f_91063_.m_109153_();
        camera.setAnglesInternal(Yaw, Pitch);
        PoseStack cameraStack = new PoseStack();
        cameraStack.m_85845_(Vector3f.f_122227_.m_122240_(Roll));
        cameraStack.m_85845_(Vector3f.f_122223_.m_122240_(Pitch));
        cameraStack.m_85845_(Vector3f.f_122225_.m_122240_(Yaw + 180.0f));
        minecraft.f_91060_.m_172961_(cameraStack, camera.m_90583_(), projectionMatrix);
        minecraft.f_91060_.m_109599_(cameraStack, partialTickTime, startTimeNano, false, camera, minecraft.f_91063_, minecraft.f_91063_.m_109154_(), projectionMatrix);
    }

    protected void saveRenderPass() {
        int shader = passthroughShader.getShaderProgram();
        if (shader == 0) {
            passthroughShader.createShaderProgram(Reader.read("flexfov:shaders/texpass.vs"), Reader.read("flexfov:shaders/texpass.fs"));
            shader = passthroughShader.getShaderProgram();
        }
        GL20.glUseProgram((int)shader);
        RenderTarget mainRenderTarget = Minecraft.m_91087_().m_91385_();
        RenderTarget textureTarget = BufferManager.renderTarget;
        textureTarget.m_83947_(false);
        GL11.glViewport((int)0, (int)0, (int)textureTarget.f_83915_, (int)textureTarget.f_83916_);
        GlStateManager.m_84173_((int)36160, (int)36064, (int)3553, (int)BufferManager.textures[this.renderPass], (int)0);
        GL11.glBindTexture((int)3553, (int)mainRenderTarget.m_83975_());
        BufferManager.passthroughSquare.draw();
        GL11.glBindTexture((int)3553, (int)0);
        mainRenderTarget.m_83947_(true);
        GL20.glUseProgram((int)0);
    }

    protected void loadUniforms(int shader) {
        int width = Minecraft.m_91087_().m_91268_().m_85443_();
        int height = Minecraft.m_91087_().m_91268_().m_85444_();
        int aaUniform = GL20.glGetUniformLocation((int)shader, (CharSequence)"antialiasing");
        GL20.glUniform1i((int)aaUniform, (int)this.getAntialiasing());
        if (this.getAntialiasing() == 16) {
            float left = -0.75f / (float)width;
            float top = -0.75f / (float)height;
            float right = 0.5f / (float)width;
            float down = 0.5f / (float)height;
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 4; ++x) {
                    int pixelOffsetUniform = GL20.glGetUniformLocation((int)shader, (CharSequence)("pixelOffset[" + (y * 4 + x) + "]"));
                    GL20.glUniform2f((int)pixelOffsetUniform, (float)(left + right * (float)x), (float)(top + down * (float)y));
                }
            }
        } else if (this.getAntialiasing() == 4) {
            int pixelOffsetUniform = GL20.glGetUniformLocation((int)shader, (CharSequence)"pixelOffset[0]");
            GL20.glUniform2f((int)pixelOffsetUniform, (float)(-0.5f / (float)width), (float)(-0.5f / (float)height));
            pixelOffsetUniform = GL20.glGetUniformLocation((int)shader, (CharSequence)"pixelOffset[1]");
            GL20.glUniform2f((int)pixelOffsetUniform, (float)(0.5f / (float)width), (float)(-0.5f / (float)height));
            pixelOffsetUniform = GL20.glGetUniformLocation((int)shader, (CharSequence)"pixelOffset[2]");
            GL20.glUniform2f((int)pixelOffsetUniform, (float)(-0.5f / (float)width), (float)(0.5f / (float)height));
            pixelOffsetUniform = GL20.glGetUniformLocation((int)shader, (CharSequence)"pixelOffset[3]");
            GL20.glUniform2f((int)pixelOffsetUniform, (float)(0.5f / (float)width), (float)(0.5f / (float)height));
        } else {
            int pixelOffsetUniform = GL20.glGetUniformLocation((int)shader, (CharSequence)"pixelOffset[0]");
            GL20.glUniform2f((int)pixelOffsetUniform, (float)0.0f, (float)0.0f);
        }
        int texFrontUniform = GL20.glGetUniformLocation((int)shader, (CharSequence)"texFront");
        GL20.glUniform1i((int)texFrontUniform, (int)4);
        int texBackUniform = GL20.glGetUniformLocation((int)shader, (CharSequence)"texBack");
        GL20.glUniform1i((int)texBackUniform, (int)5);
        int texLeftUniform = GL20.glGetUniformLocation((int)shader, (CharSequence)"texLeft");
        GL20.glUniform1i((int)texLeftUniform, (int)0);
        int texRightUniform = GL20.glGetUniformLocation((int)shader, (CharSequence)"texRight");
        GL20.glUniform1i((int)texRightUniform, (int)1);
        int texTopUniform = GL20.glGetUniformLocation((int)shader, (CharSequence)"texTop");
        GL20.glUniform1i((int)texTopUniform, (int)3);
        int texBottomUniform = GL20.glGetUniformLocation((int)shader, (CharSequence)"texBottom");
        GL20.glUniform1i((int)texBottomUniform, (int)2);
        int zoomUniform = GL20.glGetUniformLocation((int)shader, (CharSequence)"zoom");
        GL20.glUniform1f((int)zoomUniform, (float)1.0f);
        int fovxUniform = GL20.glGetUniformLocation((int)shader, (CharSequence)"fovx");
        GL20.glUniform1f((int)fovxUniform, (float)this.getFovX());
        int fovyUniform = GL20.glGetUniformLocation((int)shader, (CharSequence)"fovy");
        GL20.glUniform1f((int)fovyUniform, (float)this.getFovY());
        int backgroundUniform = GL20.glGetUniformLocation((int)shader, (CharSequence)"backgroundColor");
        float[] backgroundColor = this.getBackgroundColor(skyBackground);
        if (backgroundColor != null) {
            GL20.glUniform4f((int)backgroundUniform, (float)backgroundColor[0], (float)backgroundColor[1], (float)backgroundColor[2], (float)backgroundColor[3]);
        } else {
            GL20.glUniform4f((int)backgroundUniform, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected void runShader() {
        int i;
        int shader = projectionShader.getShaderProgram();
        if (shader == 0) {
            projectionShader.createShaderProgram(this.getVertexShader(), this.getFragmentShader());
            shader = projectionShader.getShaderProgram();
        }
        GL20.glUseProgram((int)shader);
        this.loadUniforms(shader);
        for (i = 0; i < this.textureId.length; ++i) {
            GL13.glActiveTexture((int)(33984 + i));
            this.textureId[i] = GL11.glGetInteger((int)32873);
        }
        for (i = 0; i < BufferManager.textures.length; ++i) {
            GL13.glActiveTexture((int)(33984 + i));
            GL11.glBindTexture((int)3553, (int)BufferManager.textures[i]);
        }
        BufferManager.shaderSquare.draw();
        for (i = this.textureId.length - 1; i >= 0; --i) {
            GL13.glActiveTexture((int)(33984 + i));
            GL11.glBindTexture((int)3553, (int)this.textureId[i]);
        }
        GL20.glUseProgram((int)0);
    }

    public int getAntialiasing() {
        return antialiasing;
    }

    public float[] getBackgroundColor(boolean sky) {
        if (sky) {
            return RenderSystem.m_157198_();
        }
        return null;
    }

    public double getPassFov(double fovIn) {
        return BufferManager.getFov();
    }

    public float getFovX() {
        return fov;
    }

    public float getFovY() {
        return this.getFovX() * (float)Minecraft.m_91087_().m_91268_().m_85442_() / (float)Minecraft.m_91087_().m_91268_().m_85441_();
    }
}

