#version 110

#define M_PI 3.14159265

/* This comes interpolated from the vertex shader */
varying vec2 texcoord;

/* The 6 textures to be rendered */
uniform sampler2D textures[6]; //left, right, bottom, top, front, back

uniform bool equiangular;

uniform bool rectangular;

uniform int antialiasing;

uniform vec2 pixelOffset[16];

uniform vec4 backgroundColor;

uniform vec2 cursorPos;

uniform bool drawCursor;

void getCoordNet(vec2 coord, out int texId, out vec2 subCoord) {
	if (coord.y >= -0.333333333 && coord.y < 0.333333333) {
		//Left
		if (coord.x < -0.5) {
			texId = 0;
			subCoord = vec2(coord.x*2.0+2.0, coord.y*1.5+0.5);
		}
		//Front
		else if (coord.x < 0.0) {
			texId = 4;
			subCoord = vec2(coord.x*2.0+1.0, coord.y*1.5+0.5);
		}
		//Right
		else if (coord.x < 0.5) {
			texId = 1;
			subCoord = vec2(coord.x*2.0, coord.y*1.5+0.5);
		}
		//Back
		else {
			texId = 5;
			subCoord = vec2(coord.x*2.0-1.0, coord.y*1.5+0.5);
		}
	}
	else if (coord.x < 0.0 && coord.x >= -0.5) {
		//Bottom
		if (coord.y < -0.333333333) {
			texId = 2;
			subCoord = vec2(coord.x*2.0+1.0, coord.y*1.5+1.5);
		}
		//Top
		else {
			texId = 3;
			subCoord = vec2(coord.x*2.0+1.0, coord.y*1.5-0.5);
		}
	}
	else {
		texId = -1;
		subCoord = vec2(0.0, 0.0);
	}
}

void getCoordRectangular(vec2 coord, out int texId, out vec2 subCoord) {
	texId = -1; //TODO remove
	subCoord = coord;

	if (coord.y >= 0.0) {
		//Left
		if (coord.x < -0.333333333) {
			texId = 0;
			subCoord = vec2(coord.x*1.5+1.5, coord.y);
		}
		//Right
		else if (coord.x >= 0.333333333) {
			texId = 1;
			subCoord = vec2(coord.x*1.5-0.5, coord.y);
		}
		//Front
		else {
			texId = 4;
			subCoord = vec2(coord.x*1.5+0.5, coord.y);
		}
	}
	else {
		//Bottom
		if (coord.x < -0.333333333) {
			texId = 2;
			subCoord = vec2(coord.y+1.0, 1.0-(coord.x*1.5+1.5));
		}
		//Top
		else if (coord.x >= 0.333333333) {
			texId = 3;
			subCoord = vec2(coord.y+1.0, 1.0-(coord.x*1.5-0.5));
		}
		//Back
		else {
			texId = 5;
			subCoord = vec2(-coord.y, coord.x*1.5+0.5);
		}
	}
}

void main(void) {
	//Anti-aliasing
	vec4 colorN[16];

	for (int loop = 0; loop < antialiasing; loop++) {
		vec2 coord = texcoord+pixelOffset[loop];

		int texId;
		vec2 subCoord;

		if (rectangular) {
			getCoordRectangular(coord, texId, subCoord);
		}
		else {
			getCoordNet(coord, texId, subCoord);
		}

		if (equiangular) {
			vec2 angle = (subCoord*2.0-1.0)*M_PI/4.0;
			subCoord = tan(angle)/2.0+0.5;
		}

		if (texId >= 0) {
			colorN[loop] = vec4(texture2D(textures[texId], subCoord).rgb, 1.0);
		}
		else {
			colorN[loop] = backgroundColor;
		}

		if (drawCursor) {
			if (coord.x*2.0 + 0.006 >= cursorPos.x-1.0 && coord.x*2.0 - 0.006 < cursorPos.x-1.0 &&
				coord.y*3.0 + 0.012 >= cursorPos.y*2.0-1.0 && coord.y*3.0 - 0.012 < cursorPos.y*2.0-1.0) {
					colorN[loop] = vec4(1.0, 1.0, 1.0, 1.0);
			}
		}
	}

	if (antialiasing == 16) {
	  vec4 corner[4];
	  corner[0] = mix(mix(colorN[0], colorN[1], 2.0/3.0), mix(colorN[4], colorN[5], 3.0/5.0), 5.0/8.0);
	  corner[1] = mix(mix(colorN[3], colorN[2], 2.0/3.0), mix(colorN[7], colorN[6], 3.0/5.0), 5.0/8.0);
	  corner[2] = mix(mix(colorN[12], colorN[13], 2.0/3.0), mix(colorN[8], colorN[9], 3.0/5.0), 5.0/8.0);
	  corner[3] = mix(mix(colorN[15], colorN[14], 2.0/3.0), mix(colorN[11], colorN[10], 3.0/5.0), 5.0/8.0);
	  gl_FragColor = mix(mix(corner[0], corner[1], 0.5), mix(corner[2], corner[3], 0.5), 0.5);
	}
	else if (antialiasing == 4) {
		gl_FragColor = mix(mix(colorN[0], colorN[1], 0.5), mix(colorN[2], colorN[3], 0.5), 0.5);
	}
	else { //if antialiasing == 1
		gl_FragColor = colorN[0];
	}
}
