/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.common.utils;

import fr.raksrinana.fallingtree.common.wrapper.IBlockPos;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CacheSpeed {
    @NotNull
    private final IBlockPos pos;
    private final float speed;
    private final long startMillis = System.currentTimeMillis();

    public boolean isValid(@NotNull IBlockPos blockPos) {
        return System.currentTimeMillis() <= this.startMillis + 1000L && Objects.equals(this.pos, blockPos);
    }

    public CacheSpeed(@NotNull IBlockPos pos, float speed) {
        if (pos == null) {
            throw new NullPointerException("pos is marked non-null but is null");
        }
        this.pos = pos;
        this.speed = speed;
    }

    @NotNull
    public IBlockPos getPos() {
        return this.pos;
    }

    public float getSpeed() {
        return this.speed;
    }

    public long getStartMillis() {
        return this.startMillis;
    }
}

