/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.entity;

import com.google.common.collect.ImmutableMap;
import com.izofar.bygonenether.init.ModSounds;
import java.util.Map;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class WarpedEndermanEntity
extends EndermanEntity {
    private static final int SHEAR_COOLDOWN = 20;
    private static final WarpedEnderManVariant[] VARIANTS = WarpedEnderManVariant.values();
    private static final DataParameter<Integer> VARIANT_ID = EntityDataManager.func_187226_a(WarpedEndermanEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private WarpedEnderManVariant variant;
    private int shearCooldownCounter = 0;
    private boolean toConvertToEnderman = false;
    private static final Map<SoundEvent, SoundEvent> SOUND_MAP = ImmutableMap.builder().put((Object)SoundEvents.field_187529_aS, (Object)ModSounds.WARPED_ENDERMAN_AMBIENT.get()).put((Object)SoundEvents.field_187530_aT, (Object)ModSounds.WARPED_ENDERMAN_DEATH.get()).put((Object)SoundEvents.field_187531_aU, (Object)ModSounds.WARPED_ENDERMAN_HURT.get()).put((Object)SoundEvents.field_187532_aV, (Object)ModSounds.WARPED_ENDERMAN_SCREAM.get()).put((Object)SoundEvents.field_187533_aW, (Object)ModSounds.WARPED_ENDERMAN_STARE.get()).put((Object)SoundEvents.field_187534_aX, (Object)ModSounds.WARPED_ENDERMAN_TELEPORT.get()).build();

    public WarpedEndermanEntity(EntityType<? extends EndermanEntity> entityType, World world) {
        super(entityType, world);
        this.setVariant(WarpedEndermanEntity.randomVariant(world.func_201674_k()));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EndermiteEntity.class, true, false));
        this.field_70715_bh.func_75776_a(4, (Goal)new ResetAngerGoal((MobEntity)this, false));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 55.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, 8.5).func_233815_a_(Attributes.field_233819_b_, 64.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.shearCooldownCounter > 0) {
                --this.shearCooldownCounter;
            } else if (this.shearCooldownCounter < 0) {
                this.shearCooldownCounter = 0;
            }
            if (this.toConvertToEnderman) {
                EndermanEntity enderman = (EndermanEntity)this.func_233656_b_(EntityType.field_200803_q, false);
                this.playShearSound(enderman);
            }
        }
    }

    public void func_184185_a(SoundEvent event, float f1, float f2) {
        super.func_184185_a(SOUND_MAP.getOrDefault(event, event), f1, f2);
    }

    private void playShearSound(EndermanEntity enderman) {
        this.field_70170_p.func_217384_a(null, (Entity)enderman, SoundEvents.field_187763_eJ, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT_ID, (Object)2);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a("Variant", this.variant.ordinal());
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setVariant(VARIANTS[tag.func_74762_e("Variant")]);
    }

    public WarpedEnderManVariant getVariant() {
        WarpedEnderManVariant ret;
        this.variant = ret = VARIANTS[(Integer)this.field_70180_af.func_187225_a(VARIANT_ID)];
        return ret;
    }

    public void setVariant(WarpedEnderManVariant variant) {
        this.variant = variant;
        this.field_70180_af.func_187227_b(VARIANT_ID, (Object)variant.ordinal());
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151097_aZ) {
            if (this.isReadyForShearing() && !this.field_70170_p.field_72995_K) {
                boolean flag = this.toConvertToEnderman;
                this.shearWarp();
                stack.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(hand));
                if (this.toConvertToEnderman && !flag && player instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_192133_m.func_192229_a((ServerPlayerEntity)player, (Entity)this);
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.CONSUME;
        }
        return super.func_230254_b_(player, hand);
    }

    private boolean isReadyForShearing() {
        return this.shearCooldownCounter == 0;
    }

    private void shearWarp() {
        ItemStack itemstack = new ItemStack((IItemProvider)Items.field_234719_bC_, this.func_70681_au().nextInt(2) + 1);
        ItemEntity itementity = this.func_199701_a_(itemstack);
        itementity.func_213317_d(itementity.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f), (double)(this.field_70146_Z.nextFloat() * 0.05f), (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f)));
        this.shearCooldownCounter = 20;
        switch (this.variant) {
            case FRESH: {
                this.toConvertToEnderman = true;
                break;
            }
            case SHORT_VINE: {
                this.setVariant(WarpedEnderManVariant.FRESH);
                this.playShearSound(this);
                break;
            }
            case LONG_VINE: {
                this.setVariant(WarpedEnderManVariant.SHORT_VINE);
                this.playShearSound(this);
            }
        }
    }

    private static WarpedEnderManVariant randomVariant(Random random) {
        return VARIANTS[random.nextInt(VARIANTS.length)];
    }

    public static enum WarpedEnderManVariant {
        FRESH,
        SHORT_VINE,
        LONG_VINE;

    }
}

