/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.izofar.bygonenether.entity.PiglinPrisonerEntity;
import com.izofar.bygonenether.entity.ai.behvaior.ModAdmireItemTask;
import com.izofar.bygonenether.entity.ai.behvaior.ModFollowLeaderTask;
import com.izofar.bygonenether.entity.ai.behvaior.ModForgetAdmiredItemTask;
import com.izofar.bygonenether.entity.ai.behvaior.ModStartAdmiringItemTask;
import com.izofar.bygonenether.entity.ai.behvaior.ModStopReachingItemTask;
import com.izofar.bygonenether.init.ModEntityTypes;
import com.izofar.bygonenether.init.ModMemoryModuleTypes;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.AttackStrafingTask;
import net.minecraft.entity.ai.brain.task.AttackTargetTask;
import net.minecraft.entity.ai.brain.task.DummyTask;
import net.minecraft.entity.ai.brain.task.FindInteractionAndLookTargetTask;
import net.minecraft.entity.ai.brain.task.FindNewAttackTargetTask;
import net.minecraft.entity.ai.brain.task.FirstShuffledTask;
import net.minecraft.entity.ai.brain.task.ForgetAttackTargetTask;
import net.minecraft.entity.ai.brain.task.GetAngryTask;
import net.minecraft.entity.ai.brain.task.HuntCelebrationTask;
import net.minecraft.entity.ai.brain.task.InteractWithDoorTask;
import net.minecraft.entity.ai.brain.task.InteractWithEntityTask;
import net.minecraft.entity.ai.brain.task.LookAtEntityTask;
import net.minecraft.entity.ai.brain.task.LookTask;
import net.minecraft.entity.ai.brain.task.MoveToTargetTask;
import net.minecraft.entity.ai.brain.task.PickupWantedItemTask;
import net.minecraft.entity.ai.brain.task.PiglinIdleActivityTask;
import net.minecraft.entity.ai.brain.task.PredicateTask;
import net.minecraft.entity.ai.brain.task.RunAwayTask;
import net.minecraft.entity.ai.brain.task.ShootTargetTask;
import net.minecraft.entity.ai.brain.task.SupplementedTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.ai.brain.task.WalkRandomlyTask;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;
import net.minecraft.entity.ai.brain.task.WalkTowardsLookTargetTask;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class PiglinPrisonerAi {
    private static final RangedInteger AVOID_ZOMBIFIED_DURATION = TickRangeConverter.func_233037_a_((int)5, (int)7);
    private static final int CELEBRATION_TIME = 200;
    private static final Predicate<CreatureEntity> isDistracted = mob -> {
        if (mob instanceof PiglinPrisonerEntity) {
            PiglinPrisonerEntity piglin = (PiglinPrisonerEntity)((Object)mob);
            Brain<PiglinPrisonerEntity> brain = piglin.func_213375_cj();
            return brain.func_218191_a(MemoryModuleType.field_234076_J_) || brain.func_218191_a(MemoryModuleType.field_234077_K_) || brain.func_218191_a(MemoryModuleType.field_234106_z_) || brain.func_218207_c(MemoryModuleType.field_234084_R_).orElse(false) != false || brain.func_218207_c((MemoryModuleType)ModMemoryModuleTypes.IS_TEMPTED.get()).orElse(false) == false;
        }
        return false;
    };

    public static Brain<?> makeBrain(PiglinPrisonerEntity piglin, Brain<PiglinPrisonerEntity> brain) {
        PiglinPrisonerAi.initCoreActivity(brain);
        PiglinPrisonerAi.initIdleActivity(brain);
        PiglinPrisonerAi.initAdmireItemActivity(brain);
        PiglinPrisonerAi.initFightActivity(piglin, brain);
        PiglinPrisonerAi.initCelebrateActivity(brain);
        PiglinPrisonerAi.initRetreatActivity(brain);
        brain.func_218199_a((Set)ImmutableSet.of((Object)Activity.field_221365_a));
        brain.func_218200_b(Activity.field_221366_b);
        brain.func_233714_e_();
        return brain;
    }

    private static void initCoreActivity(Brain<PiglinPrisonerEntity> brain) {
        brain.func_233698_a_(Activity.field_221365_a, 0, ImmutableList.of(new ModFollowLeaderTask(isDistracted), (Object)new LookTask(45, 90), (Object)new WalkToTargetTask(), (Object)new InteractWithDoorTask(), PiglinPrisonerAi.avoidZombified(), new ModStartAdmiringItemTask(), new ModAdmireItemTask(120), (Object)new GetAngryTask()));
    }

    private static void initIdleActivity(Brain<PiglinPrisonerEntity> brain) {
        brain.func_233698_a_(Activity.field_221366_b, 10, ImmutableList.of((Object)new LookAtEntityTask(PiglinTasks::func_234482_b_, 14.0f), (Object)new ForgetAttackTargetTask(AbstractPiglinEntity::func_242337_eM, PiglinPrisonerAi::findNearestValidAttackTarget), PiglinPrisonerAi.avoidRepellent(), PiglinPrisonerAi.createIdleLookBehaviors(), PiglinPrisonerAi.createIdleMovementBehaviors(), (Object)new FindInteractionAndLookTargetTask(EntityType.field_200729_aH, 4)));
    }

    private static void initFightActivity(PiglinPrisonerEntity piglin, Brain<PiglinPrisonerEntity> brain) {
        brain.func_233699_a_(Activity.field_234621_k_, 10, ImmutableList.of((Object)new FindNewAttackTargetTask(target -> !PiglinPrisonerAi.isNearestValidAttackTarget(piglin, target)), (Object)new SupplementedTask(PiglinPrisonerAi::hasCrossbow, (Task)new AttackStrafingTask(5, 0.75f)), (Object)new MoveToTargetTask(1.0f), (Object)new AttackTargetTask(20), (Object)new ShootTargetTask(), (Object)new PredicateTask(PiglinPrisonerAi::isNearZombified, MemoryModuleType.field_234103_o_)), MemoryModuleType.field_234103_o_);
    }

    private static void initCelebrateActivity(Brain<PiglinPrisonerEntity> pBrain) {
        pBrain.func_233699_a_(Activity.field_234622_l_, 10, ImmutableList.of(PiglinPrisonerAi.avoidRepellent(), (Object)new LookAtEntityTask(PiglinTasks::func_234482_b_, 14.0f), (Object)new ForgetAttackTargetTask(AbstractPiglinEntity::func_242337_eM, PiglinPrisonerAi::findNearestValidAttackTarget), (Object)new SupplementedTask(mob -> !mob.isDancing(), (Task)new HuntCelebrationTask(2, 1.0f)), (Object)new SupplementedTask(PiglinPrisonerEntity::isDancing, (Task)new HuntCelebrationTask(4, 0.6f)), (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_233591_ai_, 8.0f), (Object)1), (Object)Pair.of((Object)new WalkRandomlyTask(0.6f, 2, 1), (Object)1), (Object)Pair.of((Object)new DummyTask(10, 20), (Object)1)))), MemoryModuleType.field_234083_Q_);
    }

    private static void initAdmireItemActivity(Brain<PiglinPrisonerEntity> brain) {
        brain.func_233699_a_(Activity.field_234623_m_, 10, ImmutableList.of((Object)new PickupWantedItemTask(PiglinPrisonerAi::isNotHoldingLovedItemInOffHand, 1.0f, true, 9), new ModForgetAdmiredItemTask(9), new ModStopReachingItemTask(200, 200)), MemoryModuleType.field_234080_N_);
    }

    private static void initRetreatActivity(Brain<PiglinPrisonerEntity> brain) {
        brain.func_233699_a_(Activity.field_234624_n_, 10, ImmutableList.of((Object)RunAwayTask.func_233965_b_((MemoryModuleType)MemoryModuleType.field_234106_z_, (float)1.0f, (int)12, (boolean)true), PiglinPrisonerAi.createIdleLookBehaviors(), PiglinPrisonerAi.createIdleMovementBehaviors(), (Object)new PredicateTask(PiglinPrisonerAi::wantsToStopFleeing, MemoryModuleType.field_234106_z_)), MemoryModuleType.field_234106_z_);
    }

    private static FirstShuffledTask<PiglinPrisonerEntity> createIdleLookBehaviors() {
        return new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_200729_aH, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_233591_ai_, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask((EntityType)ModEntityTypes.PIGLIN_PRISONER.get(), 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(8.0f), (Object)1), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)1)));
    }

    private static FirstShuffledTask<PiglinPrisonerEntity> createIdleMovementBehaviors() {
        return new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new WalkRandomlyTask(0.6f), (Object)2), (Object)Pair.of((Object)InteractWithEntityTask.func_220445_a((EntityType)EntityType.field_233591_ai_, (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)InteractWithEntityTask.func_220445_a((EntityType)((EntityType)ModEntityTypes.PIGLIN_PRISONER.get()), (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)new SupplementedTask(PiglinPrisonerAi::doesntSeeAnyPlayerHoldingLovedItem, (Task)new WalkTowardsLookTargetTask(0.6f, 3)), (Object)2), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)1)));
    }

    private static RunAwayTask<BlockPos> avoidRepellent() {
        return RunAwayTask.func_233963_a_((MemoryModuleType)MemoryModuleType.field_234098_af_, (float)1.0f, (int)8, (boolean)false);
    }

    private static PiglinIdleActivityTask<PiglinPrisonerEntity, LivingEntity> avoidZombified() {
        return new PiglinIdleActivityTask(PiglinPrisonerAi::isNearZombified, MemoryModuleType.field_234093_aa_, MemoryModuleType.field_234106_z_, AVOID_ZOMBIFIED_DURATION);
    }

    public static void updateActivity(PiglinPrisonerEntity piglin) {
        Brain<PiglinPrisonerEntity> brain = piglin.func_213375_cj();
        Activity activity = brain.func_233716_f_().orElse(null);
        brain.func_233706_a_((List)ImmutableList.of((Object)Activity.field_234623_m_, (Object)Activity.field_234621_k_, (Object)Activity.field_234624_n_, (Object)Activity.field_234622_l_, (Object)Activity.field_221366_b));
        Activity activity1 = brain.func_233716_f_().orElse(null);
        if (activity != activity1) {
            PiglinPrisonerAi.getSoundForCurrentActivity(piglin).ifPresent(piglin::playSound);
        }
        piglin.func_213395_q(brain.func_218191_a(MemoryModuleType.field_234103_o_));
        if (!brain.func_218191_a(MemoryModuleType.field_234083_Q_)) {
            brain.func_218189_b(MemoryModuleType.field_234084_R_);
        }
        piglin.setDancing(brain.func_218191_a(MemoryModuleType.field_234084_R_));
    }

    public static void pickUpItem(PiglinPrisonerEntity pPiglin, ItemEntity pItemEntity) {
        ItemStack itemstack;
        PiglinPrisonerAi.stopWalking(pPiglin);
        if (pItemEntity.func_92059_d().func_77973_b() == Items.field_151074_bl) {
            pPiglin.func_71001_a((Entity)pItemEntity, pItemEntity.func_92059_d().func_190916_E());
            itemstack = pItemEntity.func_92059_d();
            pItemEntity.func_70106_y();
        } else {
            pPiglin.func_71001_a((Entity)pItemEntity, 1);
            itemstack = PiglinPrisonerAi.removeOneItemFromItemEntity(pItemEntity);
        }
        Item item = itemstack.func_77973_b();
        if (PiglinPrisonerAi.isLovedItem(item)) {
            pPiglin.func_213375_cj().func_218189_b(MemoryModuleType.field_242310_O);
            PiglinPrisonerAi.holdInOffhand(pPiglin, itemstack);
            PiglinPrisonerAi.admireGoldItem((LivingEntity)pPiglin);
        } else if (!pPiglin.func_233665_g_(itemstack)) {
            PiglinPrisonerAi.putInInventory(pPiglin, itemstack);
        }
    }

    private static void holdInOffhand(PiglinPrisonerEntity pPiglin, ItemStack pStack) {
        if (PiglinPrisonerAi.isHoldingItemInOffHand(pPiglin)) {
            pPiglin.func_199701_a_(pPiglin.func_184586_b(Hand.OFF_HAND));
        }
        pPiglin.holdInOffHand(pStack);
    }

    private static ItemStack removeOneItemFromItemEntity(ItemEntity pItemEntity) {
        ItemStack itemstack = pItemEntity.func_92059_d();
        ItemStack itemstack1 = itemstack.func_77979_a(1);
        if (itemstack.func_190926_b()) {
            pItemEntity.func_70106_y();
        } else {
            pItemEntity.func_92058_a(itemstack);
        }
        return itemstack1;
    }

    public static void stopHoldingOffHandItem(PiglinPrisonerEntity pPiglin, boolean pShouldBarter) {
        ItemStack itemstack = pPiglin.func_184586_b(Hand.OFF_HAND);
        pPiglin.func_184611_a(Hand.OFF_HAND, ItemStack.field_190927_a);
        if (pPiglin.func_242337_eM()) {
            boolean flag1;
            boolean flag = itemstack.isPiglinCurrency();
            if (pShouldBarter && flag) {
                PiglinPrisonerAi.putInInventory(pPiglin, itemstack);
            } else if (!flag && !(flag1 = pPiglin.func_233665_g_(itemstack))) {
                PiglinPrisonerAi.throwItems(pPiglin, Collections.singletonList(itemstack));
            }
        } else {
            boolean flag2 = pPiglin.func_233665_g_(itemstack);
            if (!flag2) {
                ItemStack itemstack1 = pPiglin.func_184614_ca();
                if (PiglinPrisonerAi.isLovedItem(itemstack1.func_77973_b())) {
                    PiglinPrisonerAi.putInInventory(pPiglin, itemstack1);
                } else {
                    PiglinPrisonerAi.throwItems(pPiglin, Collections.singletonList(itemstack1));
                }
                pPiglin.holdInMainHand(itemstack);
            }
        }
    }

    public static void cancelAdmiring(PiglinPrisonerEntity pPiglin) {
        if (PiglinPrisonerAi.isAdmiringItem(pPiglin) && !pPiglin.func_184592_cb().func_190926_b()) {
            pPiglin.func_199701_a_(pPiglin.func_184592_cb());
            pPiglin.func_184611_a(Hand.OFF_HAND, ItemStack.field_190927_a);
        }
    }

    private static void putInInventory(PiglinPrisonerEntity pPiglin, ItemStack pStack) {
        pPiglin.addToInventory(pStack);
        PiglinPrisonerAi.giveGoldBuff(pPiglin);
        PiglinPrisonerAi.pledgeAllegiance(pPiglin);
    }

    private static void throwItems(PiglinPrisonerEntity pPilgin, List<ItemStack> pStacks) {
        Optional optional = pPilgin.func_213375_cj().func_218207_c(MemoryModuleType.field_220949_j);
        if (optional.isPresent()) {
            PiglinPrisonerAi.throwItemsTowardPlayer(pPilgin, (PlayerEntity)optional.get(), pStacks);
        } else {
            PiglinPrisonerAi.throwItemsTowardRandomPos(pPilgin, pStacks);
        }
    }

    private static void throwItemsTowardRandomPos(PiglinPrisonerEntity pPiglin, List<ItemStack> pStacks) {
        PiglinPrisonerAi.throwItemsTowardPos(pPiglin, pStacks, PiglinPrisonerAi.getRandomNearbyPos(pPiglin));
    }

    private static void throwItemsTowardPlayer(PiglinPrisonerEntity pPiglin, PlayerEntity pPlayer, List<ItemStack> pStacks) {
        PiglinPrisonerAi.throwItemsTowardPos(pPiglin, pStacks, pPlayer.func_213303_ch());
    }

    private static void throwItemsTowardPos(PiglinPrisonerEntity pPiglin, List<ItemStack> pStacks, Vector3d pPos) {
        if (!pStacks.isEmpty()) {
            pPiglin.func_184609_a(Hand.OFF_HAND);
            for (ItemStack itemstack : pStacks) {
                BrainUtil.func_233865_a_((LivingEntity)pPiglin, (ItemStack)itemstack, (Vector3d)pPos.func_72441_c(0.0, 1.0, 0.0));
            }
        }
    }

    public static boolean wantsToPickup(PiglinPrisonerEntity pPiglin, ItemStack pStack) {
        Item item = pStack.func_77973_b();
        if (item.func_206844_a((ITag)ItemTags.field_232902_M_)) {
            return false;
        }
        if (PiglinPrisonerAi.isAdmiringDisabled(pPiglin) && pPiglin.func_213375_cj().func_218191_a(MemoryModuleType.field_234103_o_)) {
            return false;
        }
        if (pStack.isPiglinCurrency() || PiglinPrisonerAi.isLovedItem(item)) {
            return PiglinPrisonerAi.isNotHoldingLovedItemInOffHand(pPiglin);
        }
        boolean flag = pPiglin.canAddToInventory(pStack);
        if (item == Items.field_151074_bl) {
            return flag;
        }
        if (!PiglinPrisonerAi.isLovedItem(item)) {
            return pPiglin.canReplaceCurrentItem(pStack);
        }
        return PiglinPrisonerAi.isNotHoldingLovedItemInOffHand(pPiglin) && flag;
    }

    public static boolean isLovedItem(Item item) {
        return item.func_206844_a((ITag)ItemTags.field_232903_N_);
    }

    private static boolean isNearestValidAttackTarget(PiglinPrisonerEntity piglin, LivingEntity target) {
        return PiglinPrisonerAi.findNearestValidAttackTarget(piglin).filter(potentialTarget -> potentialTarget == target).isPresent();
    }

    private static boolean isNearZombified(PiglinPrisonerEntity piglin) {
        Brain<PiglinPrisonerEntity> brain = piglin.func_213375_cj();
        if (brain.func_218191_a(MemoryModuleType.field_234093_aa_)) {
            return piglin.func_233562_a_((Entity)brain.func_218207_c(MemoryModuleType.field_234093_aa_).get(), 6.0);
        }
        return false;
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(PiglinPrisonerEntity piglin) {
        Brain<PiglinPrisonerEntity> brain = piglin.func_213375_cj();
        if (PiglinPrisonerAi.isNearZombified(piglin)) {
            return Optional.empty();
        }
        Optional optional = BrainUtil.func_233864_a_((LivingEntity)piglin, (MemoryModuleType)MemoryModuleType.field_234078_L_);
        if (optional.isPresent() && PiglinPrisonerAi.isAttackAllowed((LivingEntity)optional.get())) {
            return optional;
        }
        Optional optional1 = brain.func_218207_c(MemoryModuleType.field_234077_K_);
        if (optional1.isPresent()) {
            return optional1;
        }
        return Optional.empty();
    }

    public static void exciteNearbyPiglins(PlayerEntity player, boolean requireVisibility) {
        List list = player.field_70170_p.func_217357_a(PiglinPrisonerEntity.class, player.func_174813_aQ().func_186662_g(16.0));
        list.stream().filter(PiglinTasks::func_234520_i_).filter(piglin -> !requireVisibility || BrainUtil.func_233876_c_((LivingEntity)piglin, (LivingEntity)player)).forEach(PiglinPrisonerAi::startDancing);
    }

    private static void startDancing(PiglinPrisonerEntity piglin) {
        piglin.func_213375_cj().func_233696_a_(MemoryModuleType.field_234084_R_, (Object)true, 200L);
        piglin.func_213375_cj().func_233696_a_(MemoryModuleType.field_234083_Q_, (Object)piglin.func_233580_cy_(), 200L);
    }

    public static ActionResultType mobInteract(PiglinPrisonerEntity pPiglin, PlayerEntity pPlayer, Hand pHand) {
        ItemStack itemstack = pPlayer.func_184586_b(pHand);
        if (PiglinPrisonerAi.canAdmire(pPiglin, itemstack)) {
            ItemStack itemstack1 = itemstack.func_77979_a(1);
            PiglinPrisonerAi.holdInOffhand(pPiglin, itemstack1);
            if (!pPlayer.equals((Object)pPiglin.getTempter())) {
                PiglinPrisonerAi.newTemptingPlayer(pPiglin, pPlayer);
            }
            PiglinPrisonerAi.admireGoldItem((LivingEntity)pPiglin);
            PiglinPrisonerAi.stopWalking(pPiglin);
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public static boolean canAdmire(PiglinPrisonerEntity pPiglin, ItemStack pStack) {
        return !PiglinPrisonerAi.isAdmiringDisabled(pPiglin) && !PiglinPrisonerAi.isAdmiringItem(pPiglin) && pPiglin.func_242337_eM() && (pStack.isPiglinCurrency() || PiglinPrisonerAi.isLovedItem(pStack.func_77973_b()));
    }

    public static void wasHurtBy(PiglinPrisonerEntity pPiglin, LivingEntity pTarget) {
        if (pTarget instanceof AbstractPiglinEntity) {
            return;
        }
        if (PiglinPrisonerAi.isHoldingItemInOffHand(pPiglin)) {
            PiglinPrisonerAi.stopHoldingOffHandItem(pPiglin, false);
        }
        Brain<PiglinPrisonerEntity> brain = pPiglin.func_213375_cj();
        brain.func_218189_b(MemoryModuleType.field_234083_Q_);
        brain.func_218189_b(MemoryModuleType.field_234084_R_);
        brain.func_218189_b(MemoryModuleType.field_234080_N_);
        if (pTarget instanceof PlayerEntity) {
            brain.func_233696_a_(MemoryModuleType.field_234081_O_, (Object)true, 400L);
        }
        PiglinPrisonerAi.getAvoidTarget(pPiglin).ifPresent(target -> {
            if (target.func_200600_R() != pTarget.func_200600_R()) {
                brain.func_218189_b(MemoryModuleType.field_234106_z_);
            }
        });
        PiglinPrisonerAi.maybeRetaliate(pPiglin, pTarget);
    }

    protected static void maybeRetaliate(AbstractPiglinEntity pPiglin, LivingEntity pTarget) {
        if (!pPiglin.func_213375_cj().func_218214_c(Activity.field_234624_n_) && PiglinPrisonerAi.isAttackAllowed(pTarget) && !BrainUtil.func_233861_a_((LivingEntity)pPiglin, (LivingEntity)pTarget, (double)4.0)) {
            PiglinPrisonerAi.setAngerTarget(pPiglin, pTarget);
            PiglinPrisonerAi.broadcastAngerTarget(pPiglin, pTarget);
        }
    }

    public static Optional<SoundEvent> getSoundForCurrentActivity(PiglinPrisonerEntity piglin) {
        return piglin.func_213375_cj().func_233716_f_().map(activity -> PiglinPrisonerAi.getSoundForActivity(piglin, activity));
    }

    private static SoundEvent getSoundForActivity(PiglinPrisonerEntity pPiglin, Activity pActivity) {
        if (pActivity == Activity.field_234621_k_) {
            return SoundEvents.field_232789_kT_;
        }
        if (pPiglin.func_242336_eL()) {
            return SoundEvents.field_232794_kY_;
        }
        if (pActivity == Activity.field_234624_n_ && PiglinPrisonerAi.isNearAvoidTarget(pPiglin)) {
            return SoundEvents.field_232794_kY_;
        }
        if (pActivity == Activity.field_234623_m_) {
            return SoundEvents.field_232787_kR_;
        }
        if (pActivity == Activity.field_234622_l_) {
            return SoundEvents.field_232790_kU_;
        }
        if (PiglinPrisonerAi.seesPlayerHoldingLovedItem((LivingEntity)pPiglin)) {
            return SoundEvents.field_232792_kW_;
        }
        return PiglinPrisonerAi.isNearRepellent(pPiglin) ? SoundEvents.field_232794_kY_ : SoundEvents.field_232788_kS_;
    }

    private static boolean isNearAvoidTarget(PiglinPrisonerEntity pPiglin) {
        Brain<PiglinPrisonerEntity> brain = pPiglin.func_213375_cj();
        return brain.func_218191_a(MemoryModuleType.field_234106_z_) && ((LivingEntity)brain.func_218207_c(MemoryModuleType.field_234106_z_).get()).func_233562_a_((Entity)pPiglin, 12.0);
    }

    private static List<AbstractPiglinEntity> getAdultPiglins(AbstractPiglinEntity pPiglin) {
        return (List)pPiglin.func_213375_cj().func_218207_c(MemoryModuleType.field_234089_W_).orElse(ImmutableList.of());
    }

    private static void stopWalking(PiglinPrisonerEntity pPiglin) {
        pPiglin.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
        pPiglin.func_70661_as().func_75499_g();
    }

    protected static void broadcastAngerTarget(AbstractPiglinEntity pPiglin, LivingEntity pTarget) {
        PiglinPrisonerAi.getAdultPiglins(pPiglin).forEach(abstractPiglin -> PiglinPrisonerAi.setAngerTargetIfCloserThanCurrent(abstractPiglin, pTarget));
    }

    public static void setAngerTarget(AbstractPiglinEntity pPiglin, LivingEntity pTarget) {
        if (PiglinPrisonerAi.isAttackAllowed(pTarget)) {
            pPiglin.func_213375_cj().func_218189_b(MemoryModuleType.field_223021_x);
            pPiglin.func_213375_cj().func_233696_a_(MemoryModuleType.field_234078_L_, (Object)pTarget.func_110124_au(), 600L);
        }
    }

    private static void setAngerTargetIfCloserThanCurrent(AbstractPiglinEntity pPiglin, LivingEntity pCurrentTarget) {
        Optional<LivingEntity> optional = PiglinPrisonerAi.getAngerTarget(pPiglin);
        LivingEntity livingentity = BrainUtil.func_233867_a_((LivingEntity)pPiglin, optional, (LivingEntity)pCurrentTarget);
        if (!optional.isPresent() || optional.get() != livingentity) {
            PiglinPrisonerAi.setAngerTarget(pPiglin, livingentity);
        }
    }

    private static Optional<LivingEntity> getAngerTarget(AbstractPiglinEntity pPiglin) {
        return BrainUtil.func_233864_a_((LivingEntity)pPiglin, (MemoryModuleType)MemoryModuleType.field_234078_L_);
    }

    public static Optional<LivingEntity> getAvoidTarget(PiglinPrisonerEntity pPiglin) {
        return pPiglin.func_213375_cj().func_218191_a(MemoryModuleType.field_234106_z_) ? pPiglin.func_213375_cj().func_218207_c(MemoryModuleType.field_234106_z_) : Optional.empty();
    }

    private static boolean wantsToStopFleeing(PiglinPrisonerEntity piglin) {
        Brain<PiglinPrisonerEntity> brain = piglin.func_213375_cj();
        if (!brain.func_218191_a(MemoryModuleType.field_234106_z_)) {
            return true;
        }
        LivingEntity livingentity = (LivingEntity)brain.func_218207_c(MemoryModuleType.field_234106_z_).get();
        EntityType entitytype = livingentity.func_200600_R();
        if (PiglinPrisonerAi.isZombified(entitytype)) {
            return !brain.func_233708_b_(MemoryModuleType.field_234093_aa_, (Object)livingentity);
        }
        return false;
    }

    private static Vector3d getRandomNearbyPos(PiglinPrisonerEntity pPiglin) {
        Vector3d vector3d = RandomPositionGenerator.func_191377_b((CreatureEntity)pPiglin, (int)4, (int)2);
        return vector3d == null ? pPiglin.func_213303_ch() : vector3d;
    }

    private static boolean hasCrossbow(LivingEntity entity) {
        return entity.func_233634_a_(itemStack -> itemStack.getItem() instanceof CrossbowItem);
    }

    private static void admireGoldItem(LivingEntity pPiglin) {
        pPiglin.func_213375_cj().func_233696_a_(MemoryModuleType.field_234080_N_, (Object)true, 120L);
    }

    private static boolean isAdmiringItem(PiglinPrisonerEntity pPiglin) {
        return pPiglin.func_213375_cj().func_218191_a(MemoryModuleType.field_234080_N_);
    }

    private static boolean isAttackAllowed(LivingEntity pTarget) {
        return EntityPredicates.field_233583_f_.test(pTarget);
    }

    private static boolean isNearRepellent(PiglinPrisonerEntity piglin) {
        return piglin.func_213375_cj().func_218191_a(MemoryModuleType.field_234098_af_);
    }

    private static boolean doesntSeeAnyPlayerHoldingLovedItem(LivingEntity player) {
        return !PiglinPrisonerAi.seesPlayerHoldingLovedItem(player);
    }

    private static boolean seesPlayerHoldingLovedItem(LivingEntity pPiglin) {
        return pPiglin.func_213375_cj().func_218191_a(MemoryModuleType.field_234096_ad_);
    }

    private static boolean isAdmiringDisabled(PiglinPrisonerEntity pPiglin) {
        return pPiglin.func_213375_cj().func_218191_a(MemoryModuleType.field_234081_O_);
    }

    private static boolean isHoldingItemInOffHand(PiglinPrisonerEntity pPiglin) {
        return !pPiglin.func_184592_cb().func_190926_b();
    }

    private static boolean isNotHoldingLovedItemInOffHand(PiglinPrisonerEntity piglin) {
        return piglin.func_184592_cb().func_190926_b() || !PiglinPrisonerAi.isLovedItem(piglin.func_184592_cb().func_77973_b());
    }

    public static boolean isZombified(EntityType<?> pEntityType) {
        return pEntityType == EntityType.field_233592_ba_ || pEntityType == EntityType.field_233590_aW_;
    }

    private static void giveGoldBuff(PiglinPrisonerEntity piglin) {
        piglin.func_195064_c(new EffectInstance(Effects.field_76444_x, 10800, 3, false, true));
        piglin.func_195064_c(new EffectInstance(Effects.field_76428_l, 7200, 1, false, false));
    }

    private static void newTemptingPlayer(PiglinPrisonerEntity piglin, PlayerEntity player) {
        piglin.func_213375_cj().func_218205_a((MemoryModuleType)ModMemoryModuleTypes.TEMPTING_PLAYER.get(), (Object)player);
        piglin.func_213375_cj().func_218205_a((MemoryModuleType)ModMemoryModuleTypes.IS_TEMPTED.get(), (Object)false);
        piglin.setTempterUUID(player.func_110124_au());
    }

    protected static void pledgeAllegiance(PiglinPrisonerEntity piglin) {
        if (piglin.func_213375_cj().func_218191_a((MemoryModuleType)ModMemoryModuleTypes.TEMPTING_PLAYER.get())) {
            piglin.func_213375_cj().func_218205_a((MemoryModuleType)ModMemoryModuleTypes.IS_TEMPTED.get(), (Object)true);
        }
    }

    public static void reloadAllegiance(PiglinPrisonerEntity piglin, PlayerEntity player) {
        piglin.func_213375_cj().func_218205_a((MemoryModuleType)ModMemoryModuleTypes.TEMPTING_PLAYER.get(), (Object)player);
        piglin.func_213375_cj().func_218205_a((MemoryModuleType)ModMemoryModuleTypes.IS_TEMPTED.get(), (Object)true);
    }
}

