/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.event;

import com.izofar.bygonenether.init.ModConfiguredFeatures;
import com.izofar.bygonenether.init.ModConfiguredStructures;
import com.izofar.bygonenether.init.ModStructures;
import java.util.HashMap;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class ModWorldEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.NETHER) {
            event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_NETHER_FORTRESS);
            event.getGeneration().getStructures().removeIf(supplier -> ((StructureFeature)supplier.get()).field_236268_b_ == StructureFeatures.field_244149_o.field_236268_b_);
            if (event.getName().equals((Object)Biomes.field_235252_ay_.func_240901_a_())) {
                event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_CATACOMB);
                event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> ModConfiguredFeatures.SOUL_STONE_BLOBS);
            } else if (event.getName().equals((Object)Biomes.field_235253_az_.func_240901_a_())) {
                event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_PIGLIN_MANOR);
            } else if (event.getName().equals((Object)Biomes.field_235250_aA_.func_240901_a_())) {
                event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_CITADEL);
            }
            if (event.getName().equals((Object)Biomes.field_235251_aB_.func_240901_a_())) {
                event.getGeneration().getStructures().add(() -> StructureFeatures.field_244153_s);
            } else {
                event.getGeneration().getStructures().removeIf(supplier -> ((StructureFeature)supplier.get()).field_236269_c_ instanceof VillageConfig && ((JigsawPattern)((VillageConfig)((StructureFeature)supplier.get()).field_236269_c_).func_242810_c().get()).func_214947_b().equals((Object)((JigsawPattern)((VillageConfig)StructureFeatures.field_244153_s.field_236269_c_).func_242810_c().get()).func_214947_b()));
            }
            if (ModList.get().isLoaded("biomesoplenty") && !event.getName().toString().equals("biomesoplenty:crystalline_chasm") && !event.getName().toString().equals("biomesoplenty:undergrowth") && !event.getName().toString().equals("biomesoplenty:visceral_heap") && event.getName().toString().equals("biomesoplenty:withered_abyss")) {
                event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_CATACOMB);
            }
            if (ModList.get().isLoaded("cinderscapes") && !event.getName().toString().equals("cinderscapes:quartz_canyon") && !event.getName().toString().equals("cinderscapes:luminous_grove") && (event.getName().toString().equals("cinderscapes:ashy_shoals") || event.getName().toString().equals("cinderscapes:blackstone_shales"))) {
                event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_CATACOMB);
                event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> ModConfiguredFeatures.SOUL_STONE_BLOBS);
            }
            if (ModList.get().isLoaded("betternether")) {
                if (event.getName().toString().equals("betternether:bone_reef") || event.getName().toString().equals("betternether:nether_jungle") || event.getName().toString().equals("betternether:old_warped_woods") || event.getName().toString().equals("betternether:upside_down_forest")) {
                    event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_CITADEL);
                } else if (event.getName().toString().equals("betternether:crimson_glowing_woods") || event.getName().toString().equals("betternether:crimson_pinewood")) {
                    event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_PIGLIN_MANOR);
                } else if (event.getName().toString().equals("betternether:flooded_deltas")) {
                    event.getGeneration().getStructures().add(() -> StructureFeatures.field_244153_s);
                } else if (event.getName().toString().equals("betternether:soul_plain")) {
                    event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_CATACOMB);
                    event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> ModConfiguredFeatures.SOUL_STONE_BLOBS);
                } else if (event.getName().toString().equals("betternether:nether_grasslands") || event.getName().toString().equals("betternether:poor_nether_grasslands") || event.getName().toString().equals("betternether:wart_forest") || event.getName().toString().equals("betternether:wart_forest_edge")) {
                    event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> ModConfiguredFeatures.SOUL_STONE_BLOBS);
                } else if (event.getName().toString().equals("betternether:gravel_desert") || event.getName().toString().equals("betternether:magma_land") || event.getName().toString().equals("betternether:nether_mushroom_forest") || event.getName().toString().equals("betternether:nether_mushroom_forest_edge") || event.getName().toString().equals("betternether:nether_swampland") || event.getName().toString().equals("betternether:nether_swampland_terraces") || event.getName().toString().equals("betternether:old_fungiwoods") || event.getName().toString().equals("betternether:old_swampland") || event.getName().toString().equals("betternether:sulfuric_bone_reef")) {
                    // empty if block
                }
            }
            if (!ModList.get().isLoaded("infernalexp") || event.getName().toString().equals("infernalexp:glowstone_canyon")) {
                // empty if block
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void addDimensionSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            ChunkGenerator chunkGenerator = serverWorld.func_72863_F().func_201711_g();
            if (chunkGenerator instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.putIfAbsent(ModStructures.NETHER_FORTRESS.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ModStructures.NETHER_FORTRESS.get()));
            tempMap.putIfAbsent(ModStructures.CATACOMB.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ModStructures.CATACOMB.get()));
            tempMap.putIfAbsent(ModStructures.CITADEL.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ModStructures.CITADEL.get()));
            tempMap.putIfAbsent(ModStructures.PIGLIN_MANOR.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ModStructures.PIGLIN_MANOR.get()));
            chunkGenerator.func_235957_b_().field_236193_d_ = tempMap;
        }
    }
}

