/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.world.feature;

import com.izofar.bygonenether.util.random.WeightedEntry;
import com.izofar.bygonenether.util.random.WeightedRandomList;
import com.mojang.datafixers.util.Pair;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class MobPassengerFeature<P extends MobEntity, V extends MobEntity>
extends Feature<NoFeatureConfig> {
    private final Supplier<WeightedRandomList<Pair<EntityType<? extends P>, EntityType<? extends V>>>> entityTypes = () -> WeightedRandomList.create(WeightedEntry.of(Pair.of((Object)passenger, (Object)vehicle), 1));

    public MobPassengerFeature(EntityType<? extends P> passenger, EntityType<? extends V> vehicle) {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, NoFeatureConfig config) {
        Pair<EntityType<? extends P>, EntityType<? extends V>> pair = this.entityTypes.get().getRandom(world.func_201674_k());
        P passenger = this.createPassenger(world, position, pair);
        V vehicle = this.createVehicle(world, position, pair);
        passenger.func_184220_m(vehicle);
        world.func_242417_l(vehicle);
        return true;
    }

    private V createVehicle(ISeedReader world, BlockPos position, Pair<EntityType<? extends P>, EntityType<? extends V>> pair) {
        MobEntity vehicle = (MobEntity)((EntityType)pair.getSecond()).func_200721_a((World)world.func_201672_e());
        vehicle.func_213386_a((IServerWorld)world, world.func_175649_E(position), SpawnReason.SPAWNER, null, null);
        vehicle.func_70107_b((double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p());
        vehicle.func_110163_bv();
        return (V)vehicle;
    }

    private P createPassenger(ISeedReader world, BlockPos position, Pair<EntityType<? extends P>, EntityType<? extends V>> pair) {
        MobEntity passenger = (MobEntity)((EntityType)pair.getFirst()).func_200721_a((World)world.func_201672_e());
        passenger.func_213386_a((IServerWorld)world, world.func_175649_E(position), SpawnReason.SPAWNER, null, null);
        passenger.func_70107_b((double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p());
        passenger.func_110163_bv();
        return (P)passenger;
    }
}

