/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.inventory.sandbox.diffcalculator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.anti_ad.mc.ipnext.inventory.data.ExtensionsKt;
import org.anti_ad.mc.ipnext.inventory.data.ItemTracker;
import org.anti_ad.mc.ipnext.inventory.sandbox.ContainerSandbox;
import org.anti_ad.mc.ipnext.inventory.sandbox.diffcalculator.DiffCalculatorInstance$CompareSlotDsl;
import org.anti_ad.mc.ipnext.inventory.sandbox.diffcalculator.DiffCalculatorInstance$filtered$1;
import org.anti_ad.mc.ipnext.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class DiffCalculatorInstance {
    @NotNull
    private final ContainerSandbox sandbox;
    @NotNull
    private final ItemTracker goalTracker;
    private int loopCounter;

    public DiffCalculatorInstance(@NotNull ContainerSandbox containerSandbox, @NotNull ItemTracker itemTracker) {
        Intrinsics.checkNotNullParameter((Object)containerSandbox, (String)"");
        Intrinsics.checkNotNullParameter((Object)itemTracker, (String)"");
        this.sandbox = containerSandbox;
        this.goalTracker = itemTracker;
        if (this.getNowTracker().getSlots().size() != this.goalTracker.getSlots().size()) {
            throw new IllegalStateException("Unequal sandbox and goal slot size".toString());
        }
        if (!Intrinsics.areEqual((Object)ExtensionsKt.collect(this.getNowTracker()), (Object)ExtensionsKt.collect(this.goalTracker))) {
            throw new IllegalStateException("Unequal sandbox and goal item counts".toString());
        }
        if (!this.goalTracker.getThrownItems().containsAll(this.getNowTracker().getThrownItems())) {
            throw new IllegalStateException("Impossible. Thrown items cannot be reverted".toString());
        }
    }

    @NotNull
    public final ContainerSandbox getSandbox() {
        return this.sandbox;
    }

    @NotNull
    public final ItemTracker getGoalTracker() {
        return this.goalTracker;
    }

    @NotNull
    public final ItemTracker getNowTracker() {
        return this.sandbox.getItems();
    }

    @NotNull
    public final ItemStack getCursorNow() {
        return this.getNowTracker().getCursor();
    }

    @NotNull
    public final ItemStack getCursorGoal() {
        return this.goalTracker.getCursor();
    }

    public abstract void run();

    public final void increaseLoopCount() {
        ++this.loopCounter;
        int n2 = Math.max(this.loopCounter, this.sandbox.getClickCount());
        if (n2 > 100000) {
            throw new IllegalStateException(("Infinity loop detected. " + n2 + " > 100000").toString());
        }
    }

    @NotNull
    public final IntRange getIndices() {
        return CollectionsKt.getIndices((Collection)this.getNowTracker().getSlots());
    }

    @NotNull
    public final List filtered(@NotNull Function1 function1) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"");
        Object object = (Iterable)this.getIndices();
        Collection collection = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            int n2 = ((IntIterator)object).nextInt();
            DiffCalculatorInstance$CompareSlotDsl diffCalculatorInstance$CompareSlotDsl = new DiffCalculatorInstance$CompareSlotDsl(this, n2);
            DiffCalculatorInstance$CompareSlotDsl diffCalculatorInstance$CompareSlotDsl2 = (Boolean)function1.invoke((Object)diffCalculatorInstance$CompareSlotDsl) != false ? diffCalculatorInstance$CompareSlotDsl : null;
            if (diffCalculatorInstance$CompareSlotDsl2 == null) continue;
            diffCalculatorInstance$CompareSlotDsl = diffCalculatorInstance$CompareSlotDsl2;
            collection.add(diffCalculatorInstance$CompareSlotDsl);
        }
        return (List)collection;
    }

    public static /* synthetic */ List filtered$default(DiffCalculatorInstance diffCalculatorInstance, Function1 function1, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: filtered");
        }
        if ((n2 & 1) != 0) {
            function1 = DiffCalculatorInstance$filtered$1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)function1, (String)"");
        Object object2 = (Iterable)diffCalculatorInstance.getIndices();
        object = new ArrayList();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            int n3 = ((IntIterator)object2).nextInt();
            DiffCalculatorInstance$CompareSlotDsl diffCalculatorInstance$CompareSlotDsl = new DiffCalculatorInstance$CompareSlotDsl(diffCalculatorInstance, n3);
            DiffCalculatorInstance$CompareSlotDsl diffCalculatorInstance$CompareSlotDsl2 = (Boolean)function1.invoke((Object)diffCalculatorInstance$CompareSlotDsl) != false ? diffCalculatorInstance$CompareSlotDsl : null;
            if (diffCalculatorInstance$CompareSlotDsl2 == null) continue;
            diffCalculatorInstance$CompareSlotDsl = diffCalculatorInstance$CompareSlotDsl2;
            object.add(diffCalculatorInstance$CompareSlotDsl);
        }
        return (List)object;
    }
}

