#define WaterFogType 2 //[1 2] //1 is original BSL waterfog, and 2 is modified waterfog.
#define WaterFogColor 0 //[0 1 2] //0 is vibrant blue, 1 is dramatic and filimic, 2 is natural

vec3 calcWaterFog(vec3 color, vec3 fragpos, vec3 wcol, float wstr, float fogrange){
float closerfogrange = fogrange - 55.0;
float DepthLinear = (2.0f * near * closerfogrange / (closerfogrange + near - (2.0f * texture2D(depthtex1, texcoord.st).x - 1.0f) * (closerfogrange - near)));
float fog = length(fragpos)/fogrange;
#if WaterFogType == 1
fog = 1.0-exp(-50.0*fog*fog);
return mix(color,pow(wcol*cmult,vec3(2.0)),min(fog,1.0));
#else
#if WaterFogColor == 0
vec3 waterfogcol = vec3(0.1, 0.5, 1.9)*0.25;
#endif

#if WaterFogColor == 1
vec3 waterfogcol = vec3(0.1, 0.5, 0.8)*0.35;
#endif

#if WaterFogColor == 2
vec3 waterfogcol = vec3(0.1, 0.7, 1.2)*0.34;
#endif
vec3 waterfog = mix(color, waterfogcol, min(DepthLinear * 2.3 / closerfogrange, 1.0));
return waterfog;
#endif
}