#define HorizonDistance 2.0 //[1.0 1.5 2.0 2.5 3.0]

#define getAngle(x) (0.02 / (x * x + 0.02))

#define vanillaModifiedSky

uniform vec3 upPosition;
uniform vec3 fogColor;
uniform vec3 moonPosition;

const float pi = 3.14159265359;
const float invPi = 1.0 / pi;

const float zenithOffset = 0.0;
const float multiScatterPhase = 0.0;
const float density = 0.7;

const float anisotropicIntensity = 0.0; //Higher numbers result in more anisotropic scattering

const vec3 skyColor = (vec3(0.3, 0.7, 1.0)*0.5) * (1.0 + anisotropicIntensity); //Make sure one of the conponents is never 0.0

#define smooth(x) x*x*(3.0-2.0*x)
#define zenithDensity(x) density / pow(max(x - zenithOffset, 0.35e-2), 0.75)

vec3 getSkyAbsorption(vec3 x, float y){
	
	vec3 absorption = x * -y;
	     absorption = exp2(absorption) * 2.0;
	
	return absorption;
}

float getSunPoint(vec3 p, vec3 lp){
	return smoothstep(0.03, 0.026, distance(p, lp)) * 50.0;
}

float getRayleigMultiplier(vec3 p, vec3 lp){
	return 1.0 + pow(1.0 - clamp(distance(p, lp), 0.0, 1.0), 2.0) * pi * 0.5;
}

float getMie(vec3 p, vec3 lp){
	float disk = clamp(1.0 - pow(distance(p, lp), 0.1), 0.0, 1.0);
	
	return disk*disk*(3.0 - 2.0 * disk) * 2.0 * pi;
}

vec3 getAtmosphericScattering(vec3 p, vec3 lp){
		
	float zenith = zenithDensity(p.y);
	float sunPointDistMult =  clamp(length(max(lp.y + multiScatterPhase - zenithOffset, 0.0)), 0.0, 1.0);
	
	float rayleighMult = getRayleigMultiplier(p, lp);
	
	vec3 absorption = getSkyAbsorption(skyColor, zenith);
    vec3 sunAbsorption = getSkyAbsorption(skyColor, zenithDensity(lp.y + multiScatterPhase));
	vec3 sky = skyColor * zenith * rayleighMult;
	vec3 mie = getMie(p, lp) * sunAbsorption;
	
	vec3 totalSky = mix(sky * absorption, sky / (sky + 0.5), sunPointDistMult);
         totalSky += mie;
	     totalSky *= sunAbsorption * 0.5 + 0.5 * length(sunAbsorption);
	
	return totalSky;
}



vec3 getSkyColor(vec3 fragpos, vec3 light){
    vec3 atmospheresimulation = getAtmosphericScattering(mat3(gbufferModelViewInverse)*normalize(fragpos), mat3(gbufferModelViewInverse)*normalize(sunVec))*0.03;
    atmospheresimulation += ambient;
    vec3 moonatmospheresimulation = getAtmosphericScattering(mat3(gbufferModelViewInverse)*normalize(fragpos), mat3(gbufferModelViewInverse)*normalize(moonPosition))*0.03;
    moonatmospheresimulation += ambient*0.2;
    return atmospheresimulation+moonatmospheresimulation;
}