float distx(float dist){
	return (far * (dist - near)) / (dist * (far - near));
}

float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

vec4 distortShadow(vec4 shadowpos, float distortFactor) {
shadowpos.xy *= 1.0f / distortFactor;
shadowpos.z = shadowpos.z*0.2;
shadowpos = shadowpos * 0.5f + 0.5f;

return shadowpos;
}

vec4 getShadowSpace(float shadowdepth, vec2 texcoord){
	vec4 fragpos = gbufferProjectionInverse * (vec4(texcoord.xy,shadowdepth,1.0)*2.0-1.0);
	fragpos /= fragpos.w;

	vec4 wpos = gbufferModelViewInverse * fragpos;
	wpos = shadowModelView * wpos;
	wpos = shadowProjection * wpos;
	wpos /= wpos.w;
	
	float distb = sqrt(wpos.x * wpos.x + wpos.y * wpos.y);
	float distortFactor = 1.0 - shadowMapBias + distb * shadowMapBias;
	wpos = distortShadow(wpos,distortFactor);
	
	return wpos;
}

//Volumetric light from Robobo1221 (modified)
vec3 getVolumetricRays(float depthtex0, float depthtex1, vec3 color, float dither) {
	vec3 vl = vec3(0.0);
	
	vec4 cameraPos = gbufferProjectionInverse * (vec4(texcoord.s, texcoord.t, depthtex0, 1.0) * 2.0 - 1.0);
	cameraPos /= cameraPos.w;

	#if AA == 2
	dither = fract(dither + frameCounter/32.0);
	#endif
	
	float cosS = dot(normalize(cameraPos.xyz), sunVec * (1.0 - 2.0 * float(timeAngle > 0.5325 && timeAngle < 0.9675)));
	float visfactor = 0.02 * (- 0.2 * timeBrightness + 1.0) * (3.0 * rainStrength + 1.0);
	float invvisfactor = 1.0 - visfactor;

    float visibility = 1.0 / 9;

    int samplecount = 9;
	if (visibility > 0.0){
		float maxDist = 512.0;
		
		float depthLinear0 = getDepth(depthtex0);
		float depthLinear1 = getDepth(depthtex1);
		vec4 worldposition = vec4(0.0);
		
		vec3 watercol = water_c*water_c*sqrt(cmult)/sqrt(water_a);
		
		for (int i = 0; i < samplecount; i++) {
			float minDist = (i + dither) * maxDist / 9 + 0.05;
			if (minDist > maxDist) break;

			if (depthLinear1 < minDist || (depthLinear0 < minDist && color == vec3(0.0))){
				break;
			}

			worldposition = getShadowSpace(distx(minDist), texcoord.st);

			if (length(worldposition.xy*2.0-1.0)<1.0){
				vec3 sample = vec3(shadow2D(shadowtex0, vec3(worldposition.xy, worldposition.z)).z);
				
				vec3 colsample = vec3(0.0);
				if (sample.r < 0.9){
					float testsample = shadow2D(shadowtex1, vec3(worldposition.xy, worldposition.z)).z;
					if (testsample > 0.9) colsample = texture2D(shadowcolor0, worldposition.xy).rgb;
					sample = max(sample,colsample*colsample);
				}
				if (depthLinear0 < minDist) sample *= color;
				else if (isEyeInWater == 1.0) sample *= watercol;

				vl += sample;
            }else{
				vl += 1.0;
			}
		}
		vl = sqrt(vl/9);
	}
	
	return vl;
}