#version 120
#extension GL_ARB_shader_texture_lod : enable

/*
BSL Shaders by Capt Tatsu
https://www.bitslablab.com
*/

#define AA 1 //[0 1 2]
#define AO
//#define PromoOutline
//#define BlackOutline
#define Clouds
#define EmissiveRecolor
#define Fog
#define FogRange 8 //[2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 18 20 22 24 26 28 30 32 36 40 44 48 52 56 60 64]
//#define ReflectPrevious
//#define ReflectRain
#define ReflectSpecular
//#define RPSupport
#define ReflectRough
#define SpecularFormat 0 //[0 1 2]

//#define WorldTimeAnimation
#define AnimationSpeed 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00 5.00 6.00 7.00 8.00]

varying vec3 upVec;
varying vec3 sunVec;
varying vec3 moonVec;

varying vec2 texcoord;

uniform int frameCounter;
uniform int isEyeInWater;
uniform int worldTime;

uniform float aspectRatio;
uniform float blindness;
uniform float far;
uniform float frameTimeCounter;
uniform float near;
uniform float nightVision;
uniform float rainStrength;
uniform float shadowFade;
uniform float timeAngle;
uniform float timeBrightness;
uniform float viewWidth;
uniform float viewHeight;

uniform ivec2 eyeBrightnessSmooth;

uniform vec3 cameraPosition;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferProjection;
uniform mat4 gbufferModelView;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D depthtex0;
uniform sampler2D noisetex;

#if defined RPSupport || defined ReflectRain
#if defined ReflectSpecular || defined ReflectRain
uniform sampler2D colortex3;
uniform sampler2D colortex6;
uniform sampler2D colortex7;
#endif
#endif

#ifdef WorldTimeAnimation
float frametime = float(worldTime)/20.0*AnimationSpeed;
#else
float frametime = frameTimeCounter*AnimationSpeed;
#endif

float eBS = eyeBrightnessSmooth.y/240.0;
float sunVisibility = clamp(dot(sunVec,upVec)+0.05,0.0,0.1)/0.1;
float moonVisibility = clamp(dot(-sunVec,upVec)+0.05,0.0,0.1)/0.1;

float luma(vec3 color){
	return dot(color,vec3(0.299, 0.587, 0.114));
}

float ld(float depth) {
   return (2.0 * near) / (far + near - depth * (far - near));
}

float gradNoise(){
	return fract(52.9829189*fract(0.06711056*gl_FragCoord.x + 0.00583715*gl_FragCoord.y)+frameCounter/8.0);
}

#if defined RPSupport || defined ReflectRain
#if defined ReflectSpecular || defined ReflectRain
const int maxf = 4;				//number of refinements
const float stp = 1.4;			//size of one step for raytracing algorithm
const float ref = 0.1;			//refinement multiplier
const float inc = 1.4;			//increasement factor at each step

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

float cdist(vec2 coord) {
	return max(abs(coord.s-0.5),abs(coord.t-0.5))*2.0;
}

vec4 raytrace(vec3 fragpos, vec3 normal, float dither) {
    vec4 color = vec4(0.0);
	#if AA == 2
	dither = fract(dither + frameTimeCounter);
	#endif

    vec3 start = fragpos;
    vec3 rvector = normalize(reflect(normalize(fragpos), normalize(normal)));
    vec3 vector = stp * rvector;
    vec3 oldpos = fragpos;
    fragpos += vector;
	vec3 tvector = vector;
    int sr = 0;
	float border = 0.0;
	vec3 pos = vec3(0.0);
    for(int i=0;i<30;i++){
        pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
		if (pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1) break;
		float depth = texture2D(depthtex0,pos.xy).r;
		vec3 spos = vec3(pos.st, depth);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = abs(length(fragpos.xyz-spos.xyz));
		if (err < pow(length(vector)*pow(length(tvector),0.17),1.1)*1.1){

                sr++;
                if (sr >= maxf){
                    break;
                }
				tvector -=vector;
                vector *=ref;
		}
        vector *= inc;
        oldpos = fragpos;
        tvector += vector * (dither * 0.05 + 0.975);
		fragpos = start + tvector;
    }
	
	if (pos.z <1.0-1e-5){
		border = clamp(1.0 - pow(cdist(pos.st), 200.0), 0.0, 1.0);
		color.a = float(texture2D(depthtex0,pos.xy).r < 1.0);
		if (color.a > 0.5) color.rgb = texture2D(colortex0, pos.st).rgb;
		color.rgb = clamp(color.rgb,vec3(0.0),vec3(8.0));
		color.a *= border;
	}
	
    return color;
}

vec4 raytraceRough(vec3 fragpos, vec3 normal, float dither, float r, vec2 noisecoord){
	r *= r;

	vec4 color = vec4(0.0);
	int steps = 1 + int(4 * r + (dither * 0.05));

	for(int i = 0; i < steps; i++){
		vec3 noise = vec3(texture2D(noisetex,noisecoord+0.1*i).xy*2.0-1.0,0.0);
		noise.xy *= 0.7*r*(i+1.0)/steps;
		noise.z = 1.0 - (noise.x * noise.x + noise.y * noise.y);

		vec3 tangent = normalize(cross(gbufferModelView[1].xyz, normal));
		mat3 tbnMatrix = mat3(tangent, cross(normal, tangent), normal);

		vec3 rnormal = normalize(tbnMatrix * noise);
		
		color += raytrace(fragpos,rnormal,dither);
	}
	color /= steps;
	
	return color;
}
uniform float wetness;
#endif
#endif

#include "/lib/color/lightColor.glsl"
#include "/lib/color/skyColor.glsl"
#include "/lib/color/torchColor.glsl"
#include "/lib/color/waterColor.glsl"
#include "/lib/util/dither.glsl"
#include "/lib/visual/ambientOcclusion.glsl"
#include "/lib/visual/blackOutlineO.glsl"
#include "/lib/visual/promoOutline.glsl"
#include "/lib/visual/clouds.glsl"
#include "/lib/visual/sky.glsl"
#include "/lib/fog/overlandFog.glsl"
#include "/lib/fog/commonFog.glsl"

#ifdef RPSupport
#include "/lib/rps/labMetal.glsl"
#endif

void main(){
	vec4 color = texture2D(colortex0,texcoord.xy);
	float z = texture2D(depthtex0,texcoord.xy).r;
	
	//Dither
	float dither = bayer64(gl_FragCoord.xy);
	
	//NDC Coordinate
	vec4 fragpos = gbufferProjectionInverse * (vec4(texcoord.x, texcoord.y, z, 1.0) * 2.0 - 1.0);
	fragpos /= fragpos.w;
	
	if (z < 1.0){
		//Specular Reflection
		#if defined RPSupport || defined ReflectRain
		#if defined ReflectSpecular || defined ReflectRain
		float smoothness = texture2D(colortex3,texcoord.xy).r;
		float f0 = texture2D(colortex3,texcoord.xy).g;
		float skymap = texture2D(colortex3,texcoord.xy).b;
		vec3 normal = texture2D(colortex6,texcoord.xy).xyz*2.0-1.0;
		
		float fresnel = pow(clamp(1.0 + dot(normal, normalize(fragpos.xyz)),0.0,1.0),5.0);
		vec3 fresnel3 = vec3(mix(f0, 1.0, fresnel));
		#ifdef RPSupport
		#if SpecularFormat == 0
		if (f0 >= 0.9) fresnel3 = complexFresnel(fresnel, f0);
		#endif
		#endif
		fresnel3 *=  smoothness * smoothness;
		
		#ifdef ReflectRough
		vec2 noisecoord = texcoord.xy*vec2(viewWidth,viewHeight)/512.0;
		#if AA == 2
		noisecoord += fract(frameCounter*vec2(0.4,0.25));
		#endif
		#endif
		
		if (length(fresnel3) > 0.002){
			vec4 reflection = vec4(0.0);
			vec3 skyRef = vec3(0.0);

			#ifdef ReflectRough
			if (smoothness >= 0.9) reflection = raytrace(fragpos.xyz,normal,dither);
			else reflection = raytraceRough(fragpos.xyz,normal,dither,1.0-smoothness,noisecoord);
			#else
			reflection = raytrace(fragpos.xyz,normal,dither);
			#endif

			if (reflection.a < 1.0){
				vec3 skyRefPos = reflect(normalize(fragpos.xyz),normal);
				#ifdef ReflectRough
				if (smoothness < 0.95){
					float r = 1.0-smoothness;
					r *= r;

					vec3 noise = vec3(texture2D(noisetex,noisecoord).xy*2.0-1.0,0.0);
					if (length(noise.xy) > 0) noise.xy /= length(noise.xy);
					noise.xy *= 0.7*r;
					noise.z = 1.0 - (noise.x * noise.x + noise.y * noise.y);

					vec3 tangent = normalize(cross(gbufferModelView[1].xyz, normal));
					mat3 tbnMatrix = mat3(tangent, cross(normal, tangent), normal);

					skyRefPos = reflect(normalize(fragpos.xyz),normalize(tbnMatrix * noise));
				}
				#endif
				skyRef = getSkyColor(skyRefPos,light);
				#ifdef Clouds
				vec4 cloud = drawCloud(skyRefPos*2048.0, dither, skyRef, light, ambient);
				skyRef = mix(skyRef,cloud.rgb,cloud.a);
				#endif
				skyRef *= (4.0-3.0*eBS)*skymap;
			}

			reflection.rgb = mix(skyRef,reflection.rgb,reflection.a);
			
			if (f0 >= 0.9){
				reflection.rgb *= color.rgb * 2.0 / (1.0-smoothness*smoothness);
				if (smoothness < 1.0) color.rgb *= mix(vec3(1.0),fresnel3/(1.0-fresnel3),smoothness*smoothness);
			}

			vec3 spec = texture2D(colortex7,texcoord.xy).rgb;
			spec = 4.0*spec/(1.0-spec);
			if (f0 >= 0.9) spec *= smoothness * smoothness;
			else spec *= fresnel3;
			
			color.rgb = mix(color.rgb, reflection.rgb, fresnel3)+spec;
		}
		#endif
		#endif
		
		//Ambient Occlusion
		#ifdef AO
		color.rgb *= dbao(depthtex0, dither);
		#endif

		//Promo Art Outline
		#ifdef PromoOutline
color.rgb = promooutline(color.rgb, depthtex0);
		#endif
		
		//Fog
		#ifdef Fog
		color.rgb = calcFog(color.rgb, fragpos.xyz, blindness);
		#endif
	}else{
		//Lava Fog
		if (isEyeInWater == 2){
			#ifdef EmissiveRecolor
			color.rgb = pow(Torch/TorchS,vec3(4.0))*2.0;
			#else
			color.rgb = vec3(1.0,0.3,0.01);
			#endif
		}

		//Blindness
		float b = clamp(blindness*2.0-1.0,0.0,1.0);
		b = b*b;
		if (blindness > 0.0) color.rgb *= 1.0-b;
	}
	
	//Black Outline
	#ifdef BlackOutline
	color.rgb *= blackoutline(depthtex0, float(z >= 1.0)*(0.875-0.375*rainStrength));
	#endif

/*DRAWBUFFERS:04*/
	gl_FragData[0] = color;
	gl_FragData[1] = vec4(z,0.0,0.0,0.0);
	#ifndef ReflectPrevious
/*DRAWBUFFERS:045*/
	gl_FragData[2] = vec4(pow(color.rgb,vec3(0.125)) * 0.5, float(z < 1.0));
	#endif
}
