#version 120
#extension GL_ARB_shader_texture_lod : enable

/*
BSL Shaders by Capt Tatsu
https://www.bitslablab.com
*/

/*
Note : gbuffers_basic, gbuffers_entities, gbuffers_hand, gbuffers_terrain, gbuffers_textured, and gbuffers_water contains mostly the same code. If you edited one of these files, you need to do the same thing for the rest of the file listed.
*/

#define AA 1 //[0 1 2]
#define Clouds
#define Desaturation
#define DesaturationFactor 1.0 //[2.0 1.5 1.0 0.5 0.0]
//#define DisableTexture
#define EmissiveBrightness 1.00 //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define EmissiveRecolor
#define Fog
#define FogRange 8 //[2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 18 20 22 24 26 28 30 32 36 40 44 48 52 56 60 64]
//#define LightmapBanding
#define LightmapDirStrength 1.0 //[2.0 1.4 1.0 0.7 0.5]
#define POMQuality 64 //[4 8 16 32 64 128 256 512]
#define POMDepth 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.25 2.50 2.75 3.00 3.25 3.50 3.75 4.00]
#define POMDistance 64.0 //[16.0 32.0 48.0 64.0 80.0 96.0 112.0 128.0]
#define POMShadowAngle 2.0 //[0.5 1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 6.5 7.0 7.5 8.0]
#define Reflection
//#define ReflectPrevious
//#define ReflectRain
#define ReflectRainType 0 //[0 1]
#define ReflectRough
#define ReflectSpecular
#define ReflectTranslucent
//#define RPSupport
//#define RPSLightmap
#define RPSPOM
#define RPSShadow
#define ShadowColor
#define ShadowFilter
#define SpecularFormat 0 //[0 1 2]

#define WaterParallax
#define WaterOctave 5 //[2 3 4 5 6 7 8]
#define WaterBump 3.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.25 2.50 2.75 3.00 3.25 3.50 3.75 4.00 4.25 4.50 4.75 5.00]
#define WaterLacunarity 1.50 //[1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00]
#define WaterPersistance 0.80 //[0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90]
#define WaterSize 450.0 //[150.0 200.0 250.0 300.0 350.0 400.0 450.0 500.0 550.0 600.0 650.0 700.0 750.0]
#define WaterSharpness 0.10 //[0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40]
#define WaterSpeed 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]

//#define WorldTimeAnimation
#define AnimationSpeed 0.50 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00 5.00 6.00 7.00 8.00]

const int shadowMapResolution = 2048; //[1024 2048 3072 4096 8192]
const float shadowDistance = 256.0; //[128.0 256.0 512.0 1024.0]
const float shadowMapBias = 1.0-25.6/shadowDistance;

varying float dist;
varying float mat;

varying vec2 lmcoord;
varying vec2 texcoord;

varying vec3 binormal;
varying vec3 normal;
varying vec3 sunVec;
varying vec3 tangent;
varying vec3 upVec;
varying vec3 viewVector;
varying vec3 wpos;

varying vec4 color;

#ifdef RPSupport
varying vec4 vtexcoordam;
varying vec4 vtexcoord;
#endif

uniform int frameCounter;
uniform int isEyeInWater;
uniform int worldTime;

uniform float blindness;
uniform float frameTimeCounter;
uniform float nightVision;
uniform float rainStrength;
uniform float screenBrightness; 
uniform float shadowFade;
uniform float timeAngle;
uniform float timeBrightness;
uniform float viewWidth;
uniform float viewHeight;

uniform ivec2 eyeBrightnessSmooth;

uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;

uniform mat4 gbufferProjection;
uniform mat4 gbufferModelView;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousModelView;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

#ifdef ReflectRain
uniform float wetness;
#endif

uniform sampler2D texture;
uniform sampler2D gaux1;
uniform sampler2D gaux2;
uniform sampler2D noisetex;

#ifdef RPSupport
uniform sampler2D specular;
uniform sampler2D normals;
#endif

float eBS = eyeBrightnessSmooth.y/240.0;
float sunVisibility = clamp(dot(sunVec,upVec)+0.05,0.0,0.1)/0.1;
float moonVisibility = clamp(dot(-sunVec,upVec)+0.05,0.0,0.1)/0.1;

#ifdef RPSupport
vec2 dcdx = dFdx(texcoord.xy);
vec2 dcdy = dFdy(texcoord.xy);
#endif

vec3 lightVec = sunVec*(1.0-2.0*float(timeAngle > 0.5325 && timeAngle < 0.9675));

float luma(vec3 color){
	return dot(color,vec3(0.299, 0.587, 0.114));
}

float gradNoise(){
	return fract(52.9829189*fract(0.06711056*gl_FragCoord.x + 0.00583715*gl_FragCoord.y)+frameCounter/8.0);
}

#ifdef WorldTimeAnimation
float frametime = float(worldTime)/20.0*AnimationSpeed;
#else
float frametime = frameTimeCounter*AnimationSpeed;
#endif

float waterH(vec3 pos, vec3 fpos) {
	float noise = 0;

	float mult = clamp((-dot(normalize(normal),normalize(fpos)))*8.0,0.0,1.0)/sqrt(sqrt(max(dist,4.0)));
	float lacunarity = 1.0;
	float persistance = 1.0;
	float weight = 0.0;
	
	if (mult > 0.01){
		for(int i = 0; i < WaterOctave; i++){
			float mult = (mod(i,2))*2.0-1.0;
			noise += texture2D(noisetex,(pos.xz+vec2(frametime)*WaterSpeed*0.25*mult+pos.y*0.25*mult)/WaterSize * lacunarity).r*persistance*mult;
			if (i==0) noise = -noise;
			weight += persistance;
			lacunarity *= WaterLacunarity;
			persistance *= WaterPersistance;
		}
		noise *= mult * WaterBump / weight * WaterSize / 270.0;
	}

	return noise;
}

vec3 getParallaxWaves(vec3 posxz, vec3 viewVector,vec3 fragpos) {
	vec3 parallaxPos = posxz;
	float waveH = (waterH(posxz,fragpos.xyz)-0.6)*0.25;
	
	for(int i = 0; i < 3; i++){
		parallaxPos.xz += waveH*(viewVector.xy)/dist;
		waveH = (waterH(parallaxPos,fragpos.xyz)-0.6)*0.25;
	}
	return parallaxPos;
}

const int maxf = 4;				//number of refinements
const float stp = 1.4;			//size of one step for raytracing algorithm
const float ref = 0.1;			//refinement multiplier
const float inc = 1.4;			//increasement factor at each step

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

float cdist(vec2 coord) {
	return max(abs(coord.s-0.5),abs(coord.t-0.5))*2.0;
}

vec4 raytrace(vec3 fragpos, vec3 normal, float dither) {
    vec4 color = vec4(0.0);
	#if AA == 2
	dither = fract(dither + frameTimeCounter);
	#endif

    vec3 start = fragpos;
    vec3 rvector = normalize(reflect(normalize(fragpos), normalize(normal)));
    vec3 vector = stp * rvector;
    vec3 oldpos = fragpos;
    fragpos += vector;
	vec3 tvector = vector;
    int sr = 0;
	float border = 0.0;
	vec3 pos = vec3(0.0);
    for(int i=0;i<30;i++){
        pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
		if (pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1) break;
		float depth = texture2D(gaux1, pos.st).r;
		vec3 spos = vec3(pos.st, depth);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = abs(length(fragpos.xyz-spos.xyz));
		if (err < pow(length(vector)*pow(length(tvector),0.2),1.1)*1.1){
                sr++;
                if (sr >= maxf){
                    break;
                }
				tvector -=vector;
                vector *=ref;
		}
        vector *= inc;
        oldpos = fragpos;
        tvector += vector * (dither * 0.005 + 1.275);
		fragpos = start + tvector;
    }
	
	if (pos.z <1.0-1e-5){
		#ifdef ReflectPrevious
		//Previous frame reprojection from Chocapic13
		vec4 fragpositionPrev = gbufferProjectionInverse * vec4(pos*2.0-1.0,1.0);
		fragpositionPrev /= fragpositionPrev.w;
		
		fragpositionPrev = gbufferModelViewInverse * fragpositionPrev;

		vec4 previousPosition = fragpositionPrev + vec4(cameraPosition-previousCameraPosition,0.0);
		previousPosition = gbufferPreviousModelView * previousPosition;
		previousPosition = gbufferPreviousProjection * previousPosition;
		previousPosition.xy = previousPosition.xy/previousPosition.w*0.5+0.5;
		
		color.a = texture2D(gaux2, previousPosition.st).a;
		//color.a = 1.0;
		if (color.a > 0.5){
			color.rgb = texture2D(gaux2, previousPosition.st).rgb;
			color.rgb = pow(color.rgb*2.0,vec3(8.0));
		}
		#else
		color.a = texture2D(gaux2, pos.st).a;
		//color.a = 1.0;
		if (color.a > 0.5){
			color.rgb = texture2D(gaux2, pos.st).rgb;
			color.rgb = pow(color.rgb*2.0,vec3(8.0));
		}
		#endif
		
		border = clamp(1.0 - pow(cdist(pos.st), 200.0), 0.0, 1.0);
		color.a *= border;
	}
	
    return color;
}

vec4 raytraceRough(vec3 fragpos, vec3 normal, float dither, float r, vec2 noisecoord){
	r *= r;

	vec4 color = vec4(0.0);
	int steps = 1 + int(4 * r);

	for(int i = 0; i < steps; i++){
		vec3 noise = vec3(texture2D(noisetex,noisecoord+0.1*i).xy*2.0-1.0,0.0);
		noise.xy *= 0.7*r*(i+1.0)/steps;
		noise.z = 1.0 - (noise.x * noise.x + noise.y * noise.y);

		vec3 tangent = normalize(cross(gbufferModelView[1].xyz, normal));
		mat3 tbnMatrix = mat3(tangent, cross(normal, tangent), normal);

		vec3 rnormal = normalize(tbnMatrix * noise);
		
		color += raytrace(fragpos,rnormal,dither);
	}
	color /= steps;
	
	return color;
}

#ifdef ReflectRain
float getPuddles(vec3 pos){
	pos = (pos + cameraPosition) * 0.005;

	float noise = texture2D(noisetex,pos.xz).r;
		  noise+= texture2D(noisetex,pos.xz*0.5).r*2.0;
		  noise+= texture2D(noisetex,pos.xz*0.25).r*4.0;
		  noise+= texture2D(noisetex,pos.xz*0.125).r*8.0;
		  noise+= texture2D(noisetex,pos.xz*0.0625).r*16.0;
		  noise = max(abs(noise-15.5)*0.8-1.2,0.0)*wetness;
		  noise /= sqrt(noise*noise+1.0);

	return clamp(noise,0.0,0.95);
}
#endif

#include "/lib/color/lightColor.glsl"
#include "/lib/color/skyColor.glsl"
#include "/lib/color/torchColor.glsl"
#include "/lib/color/waterColor.glsl"
#include "/lib/visual/clouds.glsl"
#include "/lib/util/dither.glsl"
#include "/lib/fog/overlandFog.glsl"
#include "/lib/fog/commonFog.glsl"
#include "/lib/rps/ggx.glsl"
#include "/lib/visual/shadows.glsl"
#include "/lib/visual/sky.glsl"
#include "/lib/util/spaceConversion.glsl"

#ifdef RPSupport
#include "/lib/rps/directionalLightmap.glsl"
#include "/lib/rps/labMetal.glsl"
#include "/lib/rps/parallax.glsl"
#endif

#if AA == 2
#include "/lib/util/jitter.glsl"
#endif

void main(){
	//Texture
	vec4 albedo = texture2D(texture, texcoord) * vec4(color.rgb,1.0);
	
	#ifdef RPSupport
	float pomfade = clamp((dist-POMDistance)/32.0,0.0,1.0);
	vec2 newcoord = vtexcoord.st*vtexcoordam.pq+vtexcoordam.st;
	
	#ifdef RPSPOM
	newcoord = getParallaxCoord(pomfade);
	albedo = texture2DGradARB(texture, newcoord, dcdx, dcdy) * vec4(color.rgb,1.0);
	#endif
	#endif

	#if defined RPSupport || defined ReflectRain
	float smoothness = 0.0;
	float f0 = 0.0;
	#endif
	
	vec3 vlalbedo = vec3(1.0);
	
	if (albedo.a > 0.0){
		//NDC Coordinate
		#if AA == 2
		vec3 fragpos = toNDC(vec3(taaJitter(gl_FragCoord.xy/vec2(viewWidth,viewHeight),-0.5),gl_FragCoord.z));
		#else
		vec3 fragpos = toNDC(vec3(gl_FragCoord.xy/vec2(viewWidth,viewHeight),gl_FragCoord.z));
		#endif

		//World Space Coordinate
		vec3 worldpos = toWorld(fragpos);

		//Specular Mapping
		#ifdef RPSupport
		vec4 specularmap = texture2D(specular,texcoord.xy);

		#if SpecularFormat == 0	//labPBR
		smoothness = specularmap.r;
		f0 = specularmap.g;
		if (f0 < 0.9) f0 *= f0;
		#endif
		#if SpecularFormat == 1	//Old PBR
		smoothness = specularmap.r;
		if (specularmap.g >= 0.9) f0 = 1.0;
		else f0 = specularmap.g * 0.78 + 0.02;
		#endif
		#if SpecularFormat == 2	//Grayscale
		smoothness = specularmap.r;
		f0 = float(mat > 3.98 && mat < 4.02) * 0.98 + 0.02;
		#endif
		
		smoothness = min(smoothness, 0.95);
		#endif
		
		//Normal Mapping
		vec3 newnormal = normal;
		vec3 normalmap = vec3(0.0,0.0,1.0);
		mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
							  tangent.y, binormal.y, normal.y,
							  tangent.z, binormal.z, normal.z);
							  
		if (mat > 0.98 && mat < 1.02){
			vec3 posxz = wpos.xyz;
			#ifdef WaterParallax
			posxz = getParallaxWaves(posxz,viewVector,fragpos.xyz);
			#endif
			
			float deltaPos = WaterSharpness;
			#ifdef WaterDistantWave
			deltaPos += 0.3*clamp(dist/64.0-0.25,0.0,1.0);
			#endif
			float h0 = waterH(posxz,fragpos.xyz);
			float h1 = waterH(posxz + vec3(deltaPos,0.0,0.0),fragpos.xyz);
			float h2 = waterH(posxz + vec3(-deltaPos,0.0,0.0),fragpos.xyz);
			float h3 = waterH(posxz + vec3(0.0,0.0,deltaPos),fragpos.xyz);
			float h4 = waterH(posxz + vec3(0.0,0.0,-deltaPos),fragpos.xyz);
			
			float xDelta = ((h1-h0)+(h0-h2))/deltaPos;
			float yDelta = ((h3-h0)+(h0-h4))/deltaPos;
			
			normalmap = vec3(xDelta,yDelta,1.0-xDelta*xDelta-yDelta*yDelta);
			
			float bumpmult = 0.06;	
			
			normalmap = normalmap * vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0f, 0.0f, 1.0f - bumpmult);
			
			newnormal = clamp(normalize(normalmap * tbnMatrix),vec3(-1.0),vec3(1.0));
		}
		#ifdef RPSupport
		if (mat < 0.02 || mat > 1.98){
			normalmap = texture2DGradARB(normals, newcoord.xy, dcdx, dcdy).xyz*2.0-1.0;
			if (texture2DGradARB(normals, newcoord.xy, dcdx, dcdy).a > 0.01) newnormal = normalize(normalmap * tbnMatrix);
		}
		#endif
		
		//Convert to linear color space
		albedo.rgb = pow(albedo.rgb, vec3(2.2));
		
		#ifdef DisableTexture
		albedo.rgb = vec3(0.5);
		#endif

		#ifdef RPSupport
		#ifdef ReflectSpecular
		if (f0 >= 0.9 && mat > 0.98 && mat < 1.02){
			#if SpecularFormat == 0
			if (f0 < 1.0) albedo.rgb = mix(albedo.rgb,vec3(luma(albedo.rgb)),pow(smoothness,4.0));
			#endif
			albedo.rgb *= 1.0 - smoothness * smoothness;
		}
		#endif
		vec3 rawalbedo = albedo.rgb;
		#endif
		
		//Lightmap
		#ifdef LightmapBanding
		float torchmap = clamp(floor(lmcoord.x*14.999 * (0.75 + 0.25 * color.a)) / 14, 0.0, 1.0);
		float skymap = clamp(floor(lmcoord.y*14.999 * (0.75 + 0.25 * color.a)) / 14, 0.0, 1.0);
		#else
		float torchmap = clamp(lmcoord.x, 0.0, 1.0);
		float skymap = clamp(lmcoord.y, 0.0, 1.0);
		#endif

		//Directional Lightmap
		#ifdef RPSupport
		#ifdef RPSLightmap
		mat3 lmTBN = mat3(normalize(dFdx(fragpos)),normalize(dFdy(fragpos)),vec3(0.0));
		lmTBN[2] = cross(lmTBN[0], lmTBN[1]);

		torchmap = directionalLightmap(torchmap,lmcoord.x,newnormal,lmTBN);
		skymap = directionalLightmap(skymap,lmcoord.y,newnormal,lmTBN);
		#endif
		#endif
		
		//Material Flag
		float water = float(mat > 0.98 && mat < 1.02);
		float translucent = float(mat > 1.98 && mat < 2.02);

		#ifndef ReflectTranslucent
		translucent = 0.0;
		#endif
		
		#ifndef WaterVanilla
		if (water > 0.5){
			albedo = vec4(water_c * cmult, water_a);
			albedo.rgb *= albedo.rgb;
		}
		#endif
		
		vlalbedo = mix(vec3(1.0), albedo.rgb, sqrt(albedo.a))*(1.0-pow(albedo.a,64.0));
		
		//Shadows
		vec3 shadow = vec3(0.0);
		
		float NdotL = clamp(dot(newnormal,lightVec)*1.01-0.01,0.0,1.0);
		float quarterNdotU = clamp(0.25 * dot(newnormal, upVec) + 0.75,0.5,1.0);
		quarterNdotU *= quarterNdotU;
		
		worldpos = toShadow(worldpos);
		
		float distb = sqrt(worldpos.x * worldpos.x + worldpos.y * worldpos.y);
		float distortFactor = 1.0 - shadowMapBias + distb * shadowMapBias;
		
		worldpos.xy /= distortFactor;
		worldpos.z *= 0.2;
		worldpos = worldpos*0.5+0.5;
		
		if (NdotL > 0.0 && skymap > 0.001){
			float NdotLm = NdotL * 0.99 + 0.01;
			float diffthresh = (8.0 * distortFactor * distortFactor * sqrt(1.0 - NdotLm *NdotLm) / NdotLm * pow(shadowDistance/256.0, 2.0) + 0.05) / shadowMapResolution;
			float step = 1.0/shadowMapResolution;

			worldpos.z -= diffthresh;
			
			shadow = getShadow(worldpos, step);
		}
		
		//Parallax Self Shadowing
		#ifdef RPSupport
		#ifdef RPSShadow
		if (dist < POMDistance+32.0 && skymap > 0.0 && NdotL > 0.0)
			NdotL *= getParallaxShadow(pomfade, newcoord, lightVec, tbnMatrix);
		#endif
		#endif
		
		vec3 fullshading = shadow * NdotL;
		
		//Lighting Calculation
		vec3 scenelight = (mix(ambient, light, fullshading * (shadowFade * (1.0-0.95*rainStrength))) * (4.0-3.0*eBS))  * skymap * skymap;
		float newtorchmap = pow(torchmap,10.0)*(EmissiveBrightness+0.5)+(torchmap*0.7);
		
		vec3 blocklight = (newtorchmap * newtorchmap) * torch_c;
		#ifdef LightmapBanding
		float minlight = (0.009*screenBrightness + 0.001)*floor(color.a*4.0+0.999)/4.0*(1.0-eBS);
		float sl = 1.0;
		#else
		float minlight = (0.009*screenBrightness + 0.001)*(1.0-eBS);
		float sl = color.a * color.a;
		#endif
		
		vec3 finallight = (scenelight + blocklight + nightVision + minlight) * sl;

		#ifdef RPSupport
		#if SpecularFormat == 0
		if (specularmap.a < 1.0) finallight += albedo.rgb * luma(albedo.rgb) * (specularmap.a * 4.0 / quarterNdotU) * sl;
		#endif
		#endif

		albedo.rgb *= finallight * quarterNdotU;

		//Material AO
		#ifdef RPSupport
		#if SpecularFormat == 0
		float ao = clamp(length(normalmap), 0.0, 1.0);
		albedo.rgb *= ao * ao;
		#endif
		#endif

		//Rain Reflection
		#ifdef ReflectRain
		float NdotU = clamp(dot(newnormal, upVec),0.0,1.0);

		#if ReflectRainType == 0
		float puddles = getPuddles(toWorld(fragpos)) * NdotU * wetness;
		#else
		float puddles = 0.95 * NdotU * wetness;
		#endif
		
		#ifdef WeatherVaried
		float weatherweight = isCold + isDesert + isMesa;
		puddles *= 1.0-weatherweight;
		#endif
		
		puddles *= clamp(skymap * 32.0 - 31.0, 0.0, 1.0);
		
		float porosity = 0.5;
		#ifdef RPSupport
		#if SpeularFormat == 0
		if (f0 < 0.9){
			if (specularmap.b < 0.2525) porosity = clamp(specularmap.b*4.0, 0.0, 1.0);
		} else porosity = 0.5;
		#endif
		#endif

		smoothness = mix(smoothness, 1.0, puddles * (1.0 - 0.5*pow(porosity, 4.0)));
		f0 = max(f0, puddles * 0.02);

		albedo.rgb *= 1.0 - (puddles * sqrt(porosity) * 0.5);
		#endif
		
		//Desaturation
		#ifdef Desaturation
		float desat = clamp(sqrt(max(sqrt(length(fullshading/3))*skymap,skymap))*sunVisibility*(1-rainStrength*0.4) + sqrt(torchmap), DesaturationFactor * 0.3, 1.0);
		vec3 desat_c = mix(vec3(0.1),mix(weather*0.5, light_n*light_n/(LightNS*LightNS), (1.0 - sunVisibility)*(1.0 - rainStrength)),sqrt(skymap))*(1.0-desat);
		albedo.rgb = mix(luma(albedo.rgb)*desat_c*10.0,albedo.rgb,desat);
		#endif
		
		float fresnel = pow(clamp(1.0 + dot(newnormal, normalize(fragpos.xyz)),0.0,1.0),5.5);
		float dither = bayer64(gl_FragCoord.xy);

		#if AA == 2
		dither = fract(dither + frameTimeCounter);
		#endif

		if (water > 0.5 || (translucent > 0.5 && albedo.a < 0.95)){
			vec4 reflection = vec4(0.0);
			vec3 skyRef = vec3(0.0);
	
			fresnel = (fresnel*0.98 + 0.02) * max(1.0-isEyeInWater*0.5*water,0.5) * (1.0-translucent*0.3);
			
			#ifdef Reflection
			reflection = raytrace(fragpos.xyz,newnormal,dither);
			#endif
			
			if (reflection.a < 1.0){
				vec3 skyRefPos = reflect(normalize(fragpos.xyz),newnormal);
				skyRef = getSkyColor(skyRefPos,light);
				
				float sun = GGX(newnormal,normalize(fragpos.xyz),lightVec,0.03,0.01,0.015 * sunVisibility + 0.03) * (1.5-sqrt(rainStrength)) * shadowFade;
				vec3 light_me = mix(light_m,light_a,mefade);
				vec3 speccol = mix(sqrt(light_n),mix(light_me,sqrt(light_d*light_me*LightDS),timeBrightness),sunVisibility);
				speccol *= speccol;
				
				skyRef += (sun / ((4.0-3.0*eBS) * fresnel)) * speccol * shadow;
				#ifdef Clouds
				vec4 cloud = drawCloud(skyRefPos*2048.0, dither, skyRef, light, ambient);
				skyRef = mix(skyRef,cloud.rgb,cloud.a);
				#endif
				skyRef *= (4.0-3.0*eBS) * skymap * clamp(1.0-isEyeInWater,0.0,1.5);
			}
			
			reflection.rgb = mix(skyRef,reflection.rgb,reflection.a);
			
			albedo.rgb = mix(albedo.rgb,max(reflection.rgb,vec3(0.0)),fresnel);
			albedo.a = mix(albedo.a,1.0,fresnel);
		}else{
			#if defined RPSupport || defined ReflectRain
			#if defined ReflectSpecular || defined ReflectRain
			float skymapmod = skymap*skymap*(3.0-2.0*skymap);
			vec3 fresnel3 = vec3(mix(f0, 1.0, fresnel));
			#ifdef RPSupport
			#if SpecularFormat == 0
			if (f0 >= 0.9) fresnel3 = complexFresnel(fresnel, f0);
			#endif
			#endif
			fresnel3 *=  smoothness * smoothness;

			#ifdef ReflectRough
			vec2 noisecoord = gl_FragCoord.xy/512.0;
			#if AA == 2
			noisecoord += fract(frameCounter*vec2(0.4,0.25));
			#endif
			#endif

			if (length(fresnel3) > 0.002){
				vec4 reflection = vec4(0.0);
				vec3 skyRef = vec3(0.0);
				
				#ifdef ReflectRough
				if (smoothness > 0.95) reflection = raytrace(fragpos.xyz,newnormal,dither);
				else reflection = raytraceRough(fragpos.xyz,newnormal,dither,1.0-smoothness,noisecoord);
				#else
				reflection = raytrace(fragpos.xyz,newnormal,dither);
				#endif

				if (reflection.a < 1.0){
					vec3 skyRefPos = reflect(normalize(fragpos.xyz),newnormal);
					#ifdef ReflectRough
					if (smoothness < 0.95){
						float r = 1.0-smoothness;
						r *= r;

						vec3 noise = vec3(texture2D(noisetex,noisecoord).xy*2.0-1.0,0.0);
						if (length(noise.xy) > 0) noise.xy /= length(noise.xy);
						noise.xy *= 0.7*r;
						noise.z = 1.0 - (noise.x * noise.x + noise.y * noise.y);

						vec3 tangent = normalize(cross(gbufferModelView[1].xyz, normal));
						mat3 tbnMatrix = mat3(tangent, cross(normal, tangent), normal);

						skyRefPos = reflect(normalize(fragpos.xyz),normalize(tbnMatrix * noise));
					}
					#endif
					skyRef = getSkyColor(skyRefPos,light);
					#ifdef Clouds
					vec4 cloud = drawCloud(skyRefPos*2048.0, dither, skyRef, light, ambient);
					skyRef = mix(skyRef,cloud.rgb,cloud.a);
					#endif
					skyRef *= (4.0-3.0*eBS)*skymapmod;
				}
				
				reflection.rgb = mix(skyRef,reflection.rgb,reflection.a);
				
				if (f0 >= 0.9){
					reflection.rgb *= albedo.rgb * 2.0 / (1.0-smoothness*smoothness);
					if (smoothness < 1.0) albedo.rgb *= mix(vec3(1.0),fresnel3/(1.0-fresnel3),smoothness*smoothness);
				}
				
				albedo.rgb = mix(albedo.rgb,reflection.rgb,fresnel3);
				albedo.a = mix(albedo.a,1.0,luma(fresnel3));
			}
			#endif
			
			if (dot(fullshading,fullshading) > 0.0){
				vec3 light_me = mix(light_m,light_a,mefade);
				vec3 speccol = mix(sqrt(light_n),mix(light_me,sqrt(light_d*light_me*LightDS),timeBrightness),sunVisibility);
				speccol *= speccol;

				#ifdef RPSupport
				if (f0 >= 0.9){
					speccol = sqrt(speccol);
					#if SpecularFormat == 0
					if (f0 < 1.0) speccol *= getMetalCol(f0);
					else speccol *= rawalbedo * 4.0;
					#else
					speccol *= rawalbedo * 4.0;
					#endif
				}
				#endif

				vec3 spec = speccol * shadow * shadowFade * skymap * (1.0 - sqrt(rainStrength));
				spec *= GGX(newnormal,normalize(fragpos.xyz),lightVec,1.6-smoothness,f0,0.025 * sunVisibility + 0.05);
				albedo.rgb += spec;
			}
			#endif
		}
		
		//Fog
		#ifdef Fog
		albedo.rgb = calcFog(albedo.rgb,fragpos.xyz, blindness);
		if (isEyeInWater == 1) albedo.a = mix(albedo.a,1.0,min(length(fragpos)/wfogrange,1.0));
		#endif
	}
	
/* DRAWBUFFERS:01 */
	gl_FragData[0] = albedo;
	gl_FragData[1] = vec4(vlalbedo,1.0);
}