/*
 * Decompiled with CFR 0.152.
 */
package fuzs.magnumtorch;

import fuzs.magnumtorch.MagnumTorch;
import fuzs.magnumtorch.data.ModBlockTagsProvider;
import fuzs.magnumtorch.data.ModLootTableProvider;
import fuzs.magnumtorch.data.ModRecipeProvider;
import fuzs.magnumtorch.handler.MobSpawningHandler;
import fuzs.puzzleslib.core.CoreServices;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod(value="magnumtorch")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MagnumTorchForge {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        CoreServices.FACTORIES.modConstructor("magnumtorch").accept(new MagnumTorch());
        MagnumTorchForge.registerHandlers();
    }

    private static void registerHandlers() {
        MobSpawningHandler mobSpawningHandler = new MobSpawningHandler();
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            if (!mobSpawningHandler.onLivingSpawn(evt.getEntity().m_6095_(), evt.getLevel(), evt.getX(), evt.getY(), evt.getZ(), evt.getSpawnReason())) {
                evt.setResult(Event.Result.DENY);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            if (evt.getSpawnReason() == MobSpawnType.NATURAL || evt.getSpawnReason() == MobSpawnType.SPAWNER) {
                return;
            }
            if (!mobSpawningHandler.onLivingSpawn(evt.getEntity().m_6095_(), evt.getLevel(), evt.getX(), evt.getY(), evt.getZ(), evt.getSpawnReason())) {
                evt.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent evt) {
        DataGenerator generator = evt.getGenerator();
        ExistingFileHelper existingFileHelper = evt.getExistingFileHelper();
        generator.m_236039_(true, (DataProvider)new ModBlockTagsProvider(generator, "magnumtorch", existingFileHelper));
        generator.m_236039_(true, (DataProvider)new ModLootTableProvider(generator, "magnumtorch"));
        generator.m_236039_(true, (DataProvider)new ModRecipeProvider(generator));
    }
}

