/*
 * Decompiled with CFR 0.152.
 */
package fuzs.magnumtorch.block;

import fuzs.magnumtorch.MagnumTorch;
import fuzs.magnumtorch.config.ServerConfig;
import fuzs.magnumtorch.registry.ModRegistry;
import fuzs.puzzleslib.proxy.Proxy;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MagnumTorchBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape TORCH_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public MagnumTorchBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public VoxelShape m_5940_(BlockState p_154346_, BlockGetter p_154347_, BlockPos p_154348_, CollisionContext p_154349_) {
        return TORCH_AABB;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_153490_) {
        p_153490_.m_61104_(new Property[]{WATERLOGGED});
    }

    public boolean m_7898_(BlockState p_57499_, LevelReader p_57500_, BlockPos p_57501_) {
        return MagnumTorchBlock.m_49863_((LevelReader)p_57500_, (BlockPos)p_57501_.m_7495_(), (Direction)Direction.UP);
    }

    public BlockState m_7417_(BlockState p_153739_, Direction p_153740_, BlockState p_153741_, LevelAccessor p_153742_, BlockPos p_153743_, BlockPos p_153744_) {
        if (((Boolean)p_153739_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_153742_.m_186469_(p_153743_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_153742_));
        }
        return p_153740_ == Direction.DOWN && !this.m_7898_(p_153739_, (LevelReader)p_153742_, p_153743_) ? Blocks.f_50016_.m_49966_() : super.m_7417_(p_153739_, p_153740_, p_153741_, p_153742_, p_153743_, p_153744_);
    }

    public FluidState m_5888_(BlockState p_153759_) {
        return (Boolean)p_153759_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_153759_);
    }

    public PushReaction m_5537_(BlockState p_153494_) {
        return PushReaction.DESTROY;
    }

    public boolean m_7357_(BlockState p_154341_, BlockGetter p_154342_, BlockPos p_154343_, PathComputationType p_154344_) {
        return false;
    }

    public void m_214162_(BlockState p_57494_, Level p_57495_, BlockPos p_57496_, RandomSource p_57497_) {
        double d0 = (double)p_57496_.m_123341_() + 0.5;
        double d1 = (double)p_57496_.m_123342_() + 1.125;
        double d2 = (double)p_57496_.m_123343_() + 0.5;
        p_57495_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
        p_57495_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public void m_5871_(ItemStack p_56193_, @Nullable BlockGetter p_56194_, List<Component> tooltip, TooltipFlag p_56196_) {
        super.m_5871_(p_56193_, p_56194_, tooltip, p_56196_);
        tooltip.add((Component)Component.m_237115_((String)"block.magnumtorch.magnum_torch.info").m_130940_(ChatFormatting.GRAY));
        if (p_56194_ == null) {
            return;
        }
        if (!Proxy.INSTANCE.hasShiftDown()) {
            tooltip.add((Component)Component.m_237110_((String)"block.magnumtorch.magnum_torch.info.more", (Object[])new Object[]{Component.m_237115_((String)"block.magnumtorch.magnum_torch.info.shift").m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GRAY));
        } else {
            ServerConfig.MagnumTorchConfig config = MagnumTorchBlock.getTorchConfig(this);
            if (!config.mobCategories.isEmpty()) {
                tooltip.add((Component)Component.m_237110_((String)"block.magnumtorch.magnum_torch.info.mob_types", (Object[])new Object[]{config.mobCategories.stream().map(category -> Component.m_237113_((String)category.name()).m_130940_(ChatFormatting.YELLOW)).reduce((o1, o2) -> o1.m_130946_(", ").m_7220_((Component)o2)).orElse(Component.m_237119_())}).m_130940_(ChatFormatting.GRAY));
            }
            if (!config.mobBlacklist.isEmpty()) {
                tooltip.add((Component)Component.m_237110_((String)"block.magnumtorch.magnum_torch.info.blacklist", (Object[])new Object[]{config.mobBlacklist.stream().map(mob -> Component.m_237113_((String)Registry.f_122826_.m_7981_(mob).toString()).m_130940_(ChatFormatting.AQUA)).reduce((o1, o2) -> o1.m_130946_(", ").m_7220_((Component)o2)).orElse(Component.m_237119_())}).m_130940_(ChatFormatting.GRAY));
            }
            if (!config.mobWhitelist.isEmpty()) {
                tooltip.add((Component)Component.m_237110_((String)"block.magnumtorch.magnum_torch.info.whitelist", (Object[])new Object[]{config.mobWhitelist.stream().map(mob -> Component.m_237113_((String)Registry.f_122826_.m_7981_(mob).toString()).m_130940_(ChatFormatting.AQUA)).reduce((o1, o2) -> o1.m_130946_(", ").m_7220_((Component)o2)).orElse(Component.m_237119_())}).m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add((Component)Component.m_237110_((String)"block.magnumtorch.magnum_torch.info.shape_type", (Object[])new Object[]{Component.m_237113_((String)config.shapeType.name()).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237110_((String)"block.magnumtorch.magnum_torch.info.horizontal_range", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(config.horizontalRange)).m_130940_(ChatFormatting.LIGHT_PURPLE)}).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237110_((String)"block.magnumtorch.magnum_torch.info.vertical_range", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(config.verticalRange)).m_130940_(ChatFormatting.LIGHT_PURPLE)}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static ServerConfig.MagnumTorchConfig getTorchConfig(MagnumTorchBlock block) {
        if (block == ModRegistry.DIAMOND_MAGNUM_TORCH_BLOCK.get()) {
            return ((ServerConfig)MagnumTorch.CONFIG.get(ServerConfig.class)).diamond;
        }
        if (block == ModRegistry.EMERALD_MAGNUM_TORCH_BLOCK.get()) {
            return ((ServerConfig)MagnumTorch.CONFIG.get(ServerConfig.class)).emerald;
        }
        if (block == ModRegistry.AMETHYST_MAGNUM_TORCH_BLOCK.get()) {
            return ((ServerConfig)MagnumTorch.CONFIG.get(ServerConfig.class)).amethyst;
        }
        throw new IllegalStateException("Torch type does not exist");
    }
}

