/*
 * Decompiled with CFR 0.152.
 */
package fuzs.magnumtorch.handler;

import fuzs.magnumtorch.MagnumTorch;
import fuzs.magnumtorch.config.ServerConfig;
import fuzs.magnumtorch.registry.ModRegistry;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class MobSpawningHandler {
    public boolean onLivingSpawn(EntityType<?> entityType, LevelAccessor levelAccessor, double posX, double posY, double posZ, MobSpawnType spawnType) {
        BlockPos pos;
        if (levelAccessor.m_5776_()) {
            return true;
        }
        PoiManager poiManager = ((ServerLevelAccessor)levelAccessor).m_6018_().m_8904_();
        if (this.isSpawnCancelled(poiManager, entityType, pos = new BlockPos(posX, posY, posZ), spawnType, (ResourceKey<PoiType>)ModRegistry.DIAMOND_MAGNUM_TORCH_POI_TYPE.getResourceKey(), ((ServerConfig)MagnumTorch.CONFIG.get(ServerConfig.class)).diamond)) {
            return false;
        }
        if (this.isSpawnCancelled(poiManager, entityType, pos, spawnType, (ResourceKey<PoiType>)ModRegistry.EMERALD_MAGNUM_TORCH_POI_TYPE.getResourceKey(), ((ServerConfig)MagnumTorch.CONFIG.get(ServerConfig.class)).emerald)) {
            return false;
        }
        return !this.isSpawnCancelled(poiManager, entityType, pos, spawnType, (ResourceKey<PoiType>)ModRegistry.AMETHYST_MAGNUM_TORCH_POI_TYPE.getResourceKey(), ((ServerConfig)MagnumTorch.CONFIG.get(ServerConfig.class)).amethyst);
    }

    private boolean isSpawnCancelled(PoiManager poiManager, EntityType<?> entityType, BlockPos pos, MobSpawnType spawnType, ResourceKey<PoiType> poiType, ServerConfig.MagnumTorchConfig config) {
        return config.blockedSpawnTypes.contains(spawnType) && this.isAffected(entityType, config) && this.anyInRange(poiManager, poiType, pos, config);
    }

    private boolean isAffected(EntityType<?> entityType, ServerConfig.MagnumTorchConfig config) {
        if (config.mobWhitelist.contains(entityType)) {
            return false;
        }
        if (config.mobCategories.contains(entityType.m_20674_())) {
            return true;
        }
        return config.mobBlacklist.contains(entityType);
    }

    private boolean anyInRange(PoiManager poiManager, ResourceKey<PoiType> poiType, BlockPos pos, ServerConfig.MagnumTorchConfig config) {
        Stream all = poiManager.m_27138_(poiType1 -> poiType1.m_203565_(poiType), pos1 -> true, pos, (int)Math.ceil(Math.sqrt(config.horizontalRange * config.horizontalRange + config.verticalRange * config.verticalRange)), PoiManager.Occupancy.ANY);
        return all.anyMatch(center -> this.isInRange((BlockPos)center, pos, config.horizontalRange, config.verticalRange, config.shapeType));
    }

    private boolean isInRange(BlockPos center, BlockPos pos, int horizontalRange, int verticalRange, ServerConfig.ShapeType shapeType) {
        int dimX = Math.abs(center.m_123341_() - pos.m_123341_());
        int dimY = Math.abs(center.m_123342_() - pos.m_123342_());
        int dimZ = Math.abs(center.m_123343_() - pos.m_123343_());
        return switch (shapeType) {
            default -> throw new IncompatibleClassChangeError();
            case ServerConfig.ShapeType.ELLIPSOID -> {
                if ((double)((float)(dimX * dimX + dimZ * dimZ) / (float)(horizontalRange * horizontalRange) + (float)(dimY * dimY) / (float)(verticalRange * verticalRange)) <= 1.0) {
                    yield true;
                }
                yield false;
            }
            case ServerConfig.ShapeType.CYLINDER -> {
                if (dimX * dimX + dimZ * dimZ <= horizontalRange * horizontalRange && dimY <= verticalRange) {
                    yield true;
                }
                yield false;
            }
            case ServerConfig.ShapeType.CUBOID -> dimX <= horizontalRange && dimZ <= horizontalRange && dimY <= verticalRange;
        };
    }
}

