/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.atmospheric.core;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class AtmosphericConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Boolean> showUnobtainableDescription;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("misc");
            this.showUnobtainableDescription = builder.comment("If unimplemented items should show that they are unobtainable in their item description").define("Show unobtainable description", true);
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Integer> rainforestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> rainforestMountainsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> rainforestPlateauWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> sparseRainforestPlateauWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> rainforestBasinWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> sparseRainforestBasinWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> dunesWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> dunesHillsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> flourishingDunesWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> rockyDunesWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> rockyDunesHillsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> petrifiedDunesWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> hotSpringsWeight;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("world");
            builder.push("biomes");
            builder.push("rainforest");
            this.rainforestWeight = builder.define("Rainforest weight", (Object)1);
            this.rainforestMountainsWeight = builder.define("Rainforest Mountains weight", (Object)1);
            this.rainforestPlateauWeight = builder.define("Rainforest Plateau weight", (Object)0);
            this.sparseRainforestPlateauWeight = builder.define("Sparse Rainforest Plateau weight", (Object)0);
            this.rainforestBasinWeight = builder.define("Rainforest Basin weight", (Object)1);
            this.sparseRainforestBasinWeight = builder.define("Sparse Rainforest Basin weight", (Object)0);
            builder.pop();
            builder.push("dunes");
            this.dunesWeight = builder.define("Dunes weight", (Object)5);
            this.dunesHillsWeight = builder.define("Dunes Hills weight", (Object)0);
            this.flourishingDunesWeight = builder.define("Flourishing Dunes weight", (Object)0);
            this.rockyDunesWeight = builder.define("Rocky Dunes weight", (Object)4);
            this.rockyDunesHillsWeight = builder.define("Rocky Dunes Hills weight", (Object)0);
            this.petrifiedDunesWeight = builder.define("Petrified Dunes weight", (Object)0);
            builder.pop();
            builder.comment("These biomes are experimental and not ready for use in gameplay").push("experimental");
            builder.push("hot_springs");
            this.hotSpringsWeight = builder.define("Hot Springs weight", (Object)0);
            builder.pop();
            builder.pop();
            builder.pop();
            builder.pop();
        }
    }
}

