/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.atmospheric.core.registry;

import com.minecraftabnormals.abnormals_core.core.util.BiomeUtil;
import com.minecraftabnormals.abnormals_core.core.util.registry.BiomeSubRegistryHelper;
import com.minecraftabnormals.atmospheric.core.Atmospheric;
import com.minecraftabnormals.atmospheric.core.AtmosphericConfig;
import com.minecraftabnormals.atmospheric.core.registry.AtmosphericSurfaceBuilders;
import com.mojang.datafixers.util.Pair;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atmospheric", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AtmosphericBiomes {
    private static final BiomeSubRegistryHelper HELPER = (BiomeSubRegistryHelper)Atmospheric.REGISTRY_HELPER.getBiomeSubHelper();
    public static final BiomeSubRegistryHelper.KeyedBiome RAINFOREST = HELPER.createBiome("rainforest", () -> AtmosphericBiomes.createRainforestBiome(0.1f, 0.2f));
    public static final BiomeSubRegistryHelper.KeyedBiome RAINFOREST_MOUNTAINS = HELPER.createBiome("rainforest_mountains", () -> AtmosphericBiomes.createRainforestBiome(0.2825f, 1.225f));
    public static final BiomeSubRegistryHelper.KeyedBiome RAINFOREST_PLATEAU = HELPER.createBiome("rainforest_plateau", () -> AtmosphericBiomes.createRainforestBiome(1.5f, 0.025f));
    public static final BiomeSubRegistryHelper.KeyedBiome SPARSE_RAINFOREST_PLATEAU = HELPER.createBiome("sparse_rainforest_plateau", () -> AtmosphericBiomes.createRainforestBiome(1.5f, 0.025f));
    public static final BiomeSubRegistryHelper.KeyedBiome RAINFOREST_BASIN = HELPER.createBiome("rainforest_basin", () -> AtmosphericBiomes.createRainforestBiome(-0.35f, 0.05f));
    public static final BiomeSubRegistryHelper.KeyedBiome SPARSE_RAINFOREST_BASIN = HELPER.createBiome("sparse_rainforest_basin", () -> AtmosphericBiomes.createRainforestBiome(-0.35f, 0.05f));
    public static final BiomeSubRegistryHelper.KeyedBiome DUNES = HELPER.createBiome("dunes", () -> AtmosphericBiomes.createDunesBiome(0.45f, 0.15f));
    public static final BiomeSubRegistryHelper.KeyedBiome DUNES_HILLS = HELPER.createBiome("dunes_hills", () -> AtmosphericBiomes.createDunesBiome(0.45f, 0.2f));
    public static final BiomeSubRegistryHelper.KeyedBiome FLOURISHING_DUNES = HELPER.createBiome("flourishing_dunes", () -> AtmosphericBiomes.createDunesBiome(0.45f, 0.15f));
    public static final BiomeSubRegistryHelper.KeyedBiome ROCKY_DUNES = HELPER.createBiome("rocky_dunes", () -> AtmosphericBiomes.createDunesBiome(0.45f, 0.3f));
    public static final BiomeSubRegistryHelper.KeyedBiome ROCKY_DUNES_HILLS = HELPER.createBiome("rocky_dunes_hills", () -> AtmosphericBiomes.createDunesBiome(0.45f, 0.45f));
    public static final BiomeSubRegistryHelper.KeyedBiome PETRIFIED_DUNES = HELPER.createBiome("petrified_dunes", () -> AtmosphericBiomes.createDunesBiome(0.45f, 0.2f));
    public static final BiomeSubRegistryHelper.KeyedBiome HOT_SPRINGS = HELPER.createBiome("hot_springs", AtmosphericBiomes::createHotSpringsBiome);

    public static void addBiomeVariants() {
        BiomeUtil.addHillBiome((RegistryKey)RAINFOREST.getKey(), (Pair[])new Pair[]{Pair.of((Object)RAINFOREST_BASIN.getKey(), (Object)1), Pair.of((Object)RAINFOREST_PLATEAU.getKey(), (Object)1), Pair.of((Object)SPARSE_RAINFOREST_PLATEAU.getKey(), (Object)1)});
        BiomeUtil.addHillBiome((RegistryKey)RAINFOREST_BASIN.getKey(), (Pair[])new Pair[]{Pair.of((Object)SPARSE_RAINFOREST_BASIN.getKey(), (Object)1), Pair.of((Object)RAINFOREST_PLATEAU.getKey(), (Object)1)});
        BiomeUtil.addHillBiome((RegistryKey)DUNES.getKey(), (Pair[])new Pair[]{Pair.of((Object)DUNES_HILLS.getKey(), (Object)3), Pair.of((Object)FLOURISHING_DUNES.getKey(), (Object)2)});
        BiomeUtil.addHillBiome((RegistryKey)ROCKY_DUNES.getKey(), (Pair[])new Pair[]{Pair.of((Object)ROCKY_DUNES_HILLS.getKey(), (Object)3), Pair.of((Object)PETRIFIED_DUNES.getKey(), (Object)2)});
    }

    public static void registerBiomesToDictionary() {
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(RAINFOREST.getKey(), ((Integer)AtmosphericConfig.COMMON.rainforestWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(RAINFOREST_MOUNTAINS.getKey(), ((Integer)AtmosphericConfig.COMMON.rainforestMountainsWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(RAINFOREST_PLATEAU.getKey(), ((Integer)AtmosphericConfig.COMMON.rainforestPlateauWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(SPARSE_RAINFOREST_PLATEAU.getKey(), ((Integer)AtmosphericConfig.COMMON.sparseRainforestPlateauWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(RAINFOREST_BASIN.getKey(), ((Integer)AtmosphericConfig.COMMON.rainforestBasinWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(SPARSE_RAINFOREST_BASIN.getKey(), ((Integer)AtmosphericConfig.COMMON.sparseRainforestBasinWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(DUNES.getKey(), ((Integer)AtmosphericConfig.COMMON.dunesWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(DUNES_HILLS.getKey(), ((Integer)AtmosphericConfig.COMMON.dunesHillsWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(FLOURISHING_DUNES.getKey(), ((Integer)AtmosphericConfig.COMMON.flourishingDunesWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(ROCKY_DUNES.getKey(), ((Integer)AtmosphericConfig.COMMON.rockyDunesWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(ROCKY_DUNES_HILLS.getKey(), ((Integer)AtmosphericConfig.COMMON.rockyDunesHillsWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(PETRIFIED_DUNES.getKey(), ((Integer)AtmosphericConfig.COMMON.petrifiedDunesWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(HOT_SPRINGS.getKey(), ((Integer)AtmosphericConfig.COMMON.hotSpringsWeight.get()).intValue()));
    }

    public static void addBiomeTypes() {
        BiomeDictionary.addTypes((RegistryKey)RAINFOREST.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((RegistryKey)RAINFOREST_MOUNTAINS.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((RegistryKey)SPARSE_RAINFOREST_PLATEAU.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.PLATEAU, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((RegistryKey)RAINFOREST_PLATEAU.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLATEAU, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((RegistryKey)RAINFOREST_BASIN.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WET, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((RegistryKey)SPARSE_RAINFOREST_BASIN.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WET, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((RegistryKey)DUNES.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((RegistryKey)DUNES_HILLS.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((RegistryKey)FLOURISHING_DUNES.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RARE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((RegistryKey)ROCKY_DUNES.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((RegistryKey)ROCKY_DUNES_HILLS.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((RegistryKey)PETRIFIED_DUNES.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RARE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((RegistryKey)HOT_SPRINGS.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RARE, BiomeDictionary.Type.WET, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD});
    }

    private static Biome createRainforestBiome(float depth, float scale) {
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.JUNGLE).func_205421_a(depth).func_205420_b(scale).func_205414_c(0.9f).func_205417_d(0.95f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(6675400).func_235248_c_(408635).func_235239_a_(12638463).func_242539_d(AtmosphericBiomes.getSkyColorWithTemperatureModifier(0.9f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(new MobSpawnInfo.Builder().func_242577_b()).func_242457_a(new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j).func_242508_a()).func_242455_a();
    }

    private static Biome createDunesBiome(float depth, float scale) {
        return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.DESERT).func_205421_a(depth).func_205420_b(scale).func_205414_c(2.0f).func_205417_d(0.0f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(14988944).func_242539_d(AtmosphericBiomes.getSkyColorWithTemperatureModifier(2.0f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(new MobSpawnInfo.Builder().func_242577_b()).func_242457_a(new BiomeGenerationSettings.Builder().func_242517_a(AtmosphericSurfaceBuilders.Configured.DUNES_WAVES).func_242508_a()).func_242455_a();
    }

    private static Biome createHotSpringsBiome() {
        return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.TAIGA).func_205421_a(0.15f).func_205420_b(0.45f).func_205414_c(0.25f).func_205417_d(0.4f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4445678).func_235248_c_(270131).func_235239_a_(12638463).func_242539_d(AtmosphericBiomes.getSkyColorWithTemperatureModifier(0.25f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(new MobSpawnInfo.Builder().func_242577_b()).func_242457_a(new BiomeGenerationSettings.Builder().func_242517_a(AtmosphericSurfaceBuilders.Configured.HOT_SPRINGS).func_242508_a()).func_242455_a();
    }

    private static int getSkyColorWithTemperatureModifier(float temperature) {
        float lvt_1_1_ = temperature / 3.0f;
        lvt_1_1_ = MathHelper.func_76131_a((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
    }
}

