/*
 * Decompiled with CFR 0.152.
 */
package ca.otterspace.skeletal;

import ca.otterspace.skeletal.Animation;
import ca.otterspace.skeletal.LinearCurve;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1160;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class Animations {
    Map<String, Animation> animMap = new HashMap<String, Animation>();

    public Animation getAnimation(String name) {
        return this.animMap.get(name);
    }

    protected LinearCurve parseCurve(JsonElement channel) {
        if (channel == null) {
            return null;
        }
        if (channel.isJsonArray()) {
            JsonArray array = channel.getAsJsonArray();
            LinearCurve curve = new LinearCurve();
            curve.put(0.0f, new class_1160(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat()));
            return curve;
        }
        if (channel.isJsonObject()) {
            JsonObject object = channel.getAsJsonObject();
            LinearCurve curve = new LinearCurve();
            for (Map.Entry it : object.entrySet()) {
                JsonArray array = ((JsonElement)it.getValue()).getAsJsonArray();
                float time = Float.parseFloat((String)it.getKey());
                class_1160 value = new class_1160(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat());
                curve.put(time, value);
            }
            return curve;
        }
        return null;
    }

    protected void parseAnimations(JsonElement root) {
        JsonObject animationsElement = root.getAsJsonObject().get("animations").getAsJsonObject();
        for (Map.Entry animationEntry : animationsElement.entrySet()) {
            JsonObject animationObject = ((JsonElement)animationEntry.getValue()).getAsJsonObject();
            String animationName = (String)animationEntry.getKey();
            Animation animation = new Animation();
            JsonObject bones = animationObject.get("bones").getAsJsonObject();
            for (Map.Entry boneEntry : bones.entrySet()) {
                LinearCurve rotationCurve;
                String boneName = (String)boneEntry.getKey();
                JsonObject channel = ((JsonElement)boneEntry.getValue()).getAsJsonObject();
                LinearCurve positionCurve = this.parseCurve(channel.get("position"));
                if (positionCurve != null) {
                    positionCurve.points.replaceAll((key, value) -> {
                        value.method_23849(1.0f, -1.0f, 1.0f);
                        return value;
                    });
                    animation.positionCurves.put(boneName, positionCurve);
                }
                if ((rotationCurve = this.parseCurve(channel.get("rotation"))) == null) continue;
                rotationCurve.points.replaceAll((key, value) -> {
                    value.method_4942((float)Math.PI / 180);
                    return value;
                });
                animation.rotationCurves.put(boneName, rotationCurve);
            }
            if (animationObject.get("loop") != null) {
                animation.loop = animationObject.get("loop").getAsBoolean();
            }
            if (animationObject.get("animation_length") != null) {
                animation.length = animationObject.get("animation_length").getAsFloat();
            }
            this.animMap.put(animationName, animation);
        }
    }

    public static Animations loadAnimations(class_2960 location) {
        Animations animations = new Animations();
        try {
            class_3300 manager = class_310.method_1551().method_1478();
            InputStream stream = ((class_3298)manager.method_14486(location).get()).method_14482();
            InputStreamReader reader = new InputStreamReader(stream);
            JsonElement root = JsonParser.parseReader((Reader)reader);
            animations.parseAnimations(root);
            return animations;
        }
        catch (IOException ex) {
            return null;
        }
    }
}

