/*
 * Decompiled with CFR 0.152.
 */
package ca.otterspace.skeletal;

import ca.otterspace.skeletal.Bone;
import ca.otterspace.skeletal.LocRot;
import ca.otterspace.skeletal.Pose;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;

public class Model {
    Map<String, Bone> boneMap = Maps.newHashMap();
    Bone root = new Bone();

    protected void parseGeometry(JsonElement rootEl) {
        HashMap rbones = Maps.newHashMap();
        Gson gson = new Gson();
        rootEl.getAsJsonObject().get("minecraft:geometry").getAsJsonArray().get(0).getAsJsonObject().get("bones").getAsJsonArray().forEach(boneEl -> {
            RawBone rbone = (RawBone)gson.fromJson(boneEl, RawBone.class);
            rbone.bone = new Bone();
            rbone.bone.name = rbone.name;
            rbones.put(rbone.name, rbone);
        });
        for (RawBone rbone : rbones.values()) {
            RawBone rparent = (RawBone)rbones.get(rbone.parent);
            Bone bone = rbone.bone;
            bone.parent = rbone.parent == null ? this.root : rparent.bone;
            bone.parent.children.add(bone);
            this.boneMap.put(bone.name, bone);
            class_1159 boneTransform = class_1159.method_24019((float)1.0f, (float)1.0f, (float)1.0f);
            if (rbone.pivot != null) {
                if (rparent != null) {
                    boneTransform.method_22672(class_1159.method_24021((float)(-rparent.pivot[0] / 16.0f), (float)(rparent.pivot[1] / 16.0f), (float)(-rparent.pivot[2] / 16.0f)));
                }
                boneTransform.method_22672(class_1159.method_24021((float)(rbone.pivot[0] / 16.0f), (float)(-rbone.pivot[1] / 16.0f), (float)(rbone.pivot[2] / 16.0f)));
            }
            if (rbone.rotation != null) {
                boneTransform.method_22670(class_1160.field_20707.method_23214(rbone.rotation[2]));
                boneTransform.method_22670(class_1160.field_20705.method_23214(rbone.rotation[1]));
                boneTransform.method_22670(class_1160.field_20703.method_23214(rbone.rotation[0]));
            }
            bone.transform = boneTransform;
            if (rbone.cubes == null) continue;
            for (RawCube rcube : rbone.cubes) {
                Bone leaf = new Bone();
                leaf.parent = bone;
                class_1159 leafTransform = class_1159.method_24019((float)1.0f, (float)1.0f, (float)1.0f);
                if (rcube.pivot != null) {
                    leafTransform.method_22672(class_1159.method_24021((float)(-rbone.pivot[0] / 16.0f), (float)(rbone.pivot[1] / 16.0f), (float)(-rbone.pivot[2] / 16.0f)));
                    leafTransform.method_22672(class_1159.method_24021((float)(rcube.pivot[0] / 16.0f), (float)(-rcube.pivot[1] / 16.0f), (float)(rcube.pivot[2] / 16.0f)));
                }
                if (rcube.rotation != null) {
                    leafTransform.method_22670(class_1160.field_20707.method_23214(rcube.rotation[2]));
                    leafTransform.method_22670(class_1160.field_20705.method_23214(rcube.rotation[1]));
                    leafTransform.method_22670(class_1160.field_20703.method_23214(rcube.rotation[0]));
                }
                if (rcube.pivot == null) {
                    rcube.pivot = rbone.pivot;
                }
                leaf.transform = leafTransform;
                leaf.cube = new class_630.class_628(rcube.uv[0], rcube.uv[1], rcube.origin[0] - rcube.pivot[0], -(rcube.origin[1] - rcube.pivot[1]) - rcube.size[1], rcube.origin[2] - rcube.pivot[2], rcube.size[0], rcube.size[1], rcube.size[2], 0.0f, 0.0f, 0.0f, false, 128.0f, 128.0f);
                bone.children.add(leaf);
            }
        }
    }

    public void applyPose(Pose pose) {
        for (Map.Entry<String, Bone> entry : this.boneMap.entrySet()) {
            LocRot locrot = pose.getLocal(entry.getKey());
            if (locrot != null) {
                entry.getValue().locrot = locrot;
                continue;
            }
            entry.getValue().locrot = new LocRot();
        }
    }

    public static Model loadGeometry(class_2960 location) {
        Model result = new Model();
        try {
            InputStream stream = ((class_3298)class_310.method_1551().method_1478().method_14486(location).get()).method_14482();
            InputStreamReader reader = new InputStreamReader(stream);
            JsonElement root = JsonParser.parseReader((Reader)reader);
            result.parseGeometry(root);
            return result;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public Bone getBone(String name) {
        return this.boneMap.get(name);
    }

    public void render(class_4587 mats, class_4588 vbuf, int i, int j, float f, float g, float h, float k) {
        this.root.render(mats, vbuf, i, j, f, g, h, k);
    }

    class RawBone {
        String name;
        String parent;
        float[] pivot;
        float[] rotation;
        RawCube[] cubes;
        transient Bone bone;

        RawBone() {
        }
    }

    class RawCube {
        int[] uv;
        float[] origin;
        float[] size;
        float[] pivot;
        float[] rotation;

        RawCube() {
        }
    }
}

