/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.handlers.dispenserbehavior;

import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import pegbeard.dungeontactics.entities.projectiles.DTEntityCryoBomb;
import pegbeard.dungeontactics.entities.projectiles.DTEntityFragBomb;
import pegbeard.dungeontactics.entities.projectiles.DTEntityPortBomb;
import pegbeard.dungeontactics.entities.projectiles.DTEntityPyroBomb;
import pegbeard.dungeontactics.entities.projectiles.DTEntityThrowingKnife;
import pegbeard.dungeontactics.entities.projectiles.DTThrowableGeneric;

public class DTDispenseThrowable
implements IBehaviorDispenseItem {
    public boolean knife = false;
    public boolean cluster = false;
    public boolean fire = false;
    public boolean porting = false;
    public boolean cryo = false;
    public int fuse = 50;

    public DTDispenseThrowable() {
        this.knife = true;
    }

    public DTDispenseThrowable(boolean isCluster, boolean isFire, boolean isPorting, boolean isCryo) {
        this.cluster = isCluster;
        this.fire = isFire;
        this.porting = isPorting;
        this.cryo = isCryo;
    }

    public ItemStack func_82482_a(IBlockSource source, ItemStack stack) {
        World world = source.func_82618_k();
        IPosition iposition = BlockDispenser.func_149939_a((IBlockSource)source);
        EnumFacing enumfacing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
        IProjectile iprojectile = this.getProjectileEntity(world, iposition, stack);
        iprojectile.func_70186_c((double)enumfacing.func_82601_c(), (double)((float)enumfacing.func_96559_d() + 0.1f), (double)enumfacing.func_82599_e(), this.getProjectileVelocity(), this.getProjectileInaccuracy());
        world.func_72838_d((Entity)iprojectile);
        stack.func_190918_g(1);
        return stack;
    }

    protected IProjectile getProjectileEntity(World world, IPosition position, ItemStack stack) {
        if (this.knife) {
            DTEntityThrowingKnife knife = new DTEntityThrowingKnife(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            knife.setKnifeType(stack.func_77973_b());
            return knife;
        }
        DTThrowableGeneric grenade = new DTEntityFragBomb(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
        if (this.fire) {
            grenade = new DTEntityPyroBomb(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
        } else if (this.porting) {
            grenade = new DTEntityPortBomb(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
        } else if (this.cryo) {
            grenade = new DTEntityCryoBomb(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
        }
        grenade.cluster = this.cluster;
        grenade.fuse = this.fuse;
        return grenade;
    }

    protected void playDispenseSound(IBlockSource source) {
        source.func_82618_k().func_175718_b(1002, source.func_180699_d(), 0);
    }

    protected float getProjectileInaccuracy() {
        return 6.0f;
    }

    protected float getProjectileVelocity() {
        return 1.1f;
    }
}

