/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.common.entites;

import com.cgessinger.creaturesandbeasts.common.entites.FriendlySporelingEntity;
import com.cgessinger.creaturesandbeasts.common.init.ModSoundEventTypes;
import com.cgessinger.creaturesandbeasts.common.interfaces.IRunningEntity;
import com.cgessinger.creaturesandbeasts.common.interfaces.ITimedAttackEntity;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public abstract class AbstractSporelingEntity
extends CreatureEntity
implements IAnimatable,
ITimedAttackEntity,
IRunningEntity {
    private static final DataParameter<Integer> SPORELING_VARIANT = EntityDataManager.func_187226_a(AbstractSporelingEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(AbstractSporelingEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RUNNING = EntityDataManager.func_187226_a(AbstractSporelingEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<ItemStack> HOLDING = EntityDataManager.func_187226_a(FriendlySporelingEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    protected int attackTimer;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    protected AbstractSporelingEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70180_af.func_187214_a(SPORELING_VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
        this.field_70180_af.func_187214_a(RUNNING, (Object)false);
        this.field_70180_af.func_187214_a(HOLDING, (Object)ItemStack.field_190927_a);
        this.attackTimer = 0;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (dataTag != null && dataTag.func_74764_b("variant")) {
            this.setSporelingType(dataTag.func_74762_e("variant"));
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_213352_e(Vector3d travelVector) {
        if (!this.field_70170_p.func_201670_d()) {
            this.setRunning(this.func_70605_aq().func_75638_b() >= this.getRunThreshold());
        }
        super.func_213352_e(travelVector);
    }

    public <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        if (!(this.field_70721_aZ > -0.15f) || !(this.field_70721_aZ < 0.15f)) {
            if (this.isRunning()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("sporeling.run", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("sporeling.walk", Boolean.valueOf(true)));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    protected BodyController func_184650_s() {
        return super.func_184650_s();
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public SporelingType getSporelingType() {
        return SporelingType.values()[(Integer)this.field_70180_af.func_187225_a(SPORELING_VARIANT)];
    }

    public void setSporelingType(int variant) {
        this.field_70180_af.func_187227_b(SPORELING_VARIANT, (Object)variant);
    }

    @Override
    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    @Override
    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    @Override
    public void setRunning(boolean running) {
        this.field_70180_af.func_187227_b(RUNNING, (Object)running);
    }

    @Override
    public boolean isRunning() {
        return (Boolean)this.field_70180_af.func_187225_a(RUNNING);
    }

    public void setHolding(ItemStack stack) {
        this.field_70180_af.func_187227_b(HOLDING, (Object)stack);
    }

    public ItemStack getHolding() {
        return (ItemStack)this.field_70180_af.func_187225_a(HOLDING);
    }

    @Override
    public double getRunThreshold() {
        return 1.3;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 16.0).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("variant", ((Integer)this.field_70180_af.func_187225_a(SPORELING_VARIANT)).intValue());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("variant")) {
            this.setSporelingType(compound.func_74762_e("variant"));
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        this.func_184185_a((SoundEvent)ModSoundEventTypes.SPORELING_BITE.get(), this.func_70599_aP() * 2.0f, this.func_70647_i());
        return super.func_70652_k(entityIn);
    }

    public int func_184649_cE() {
        return 5;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public static enum SporelingType {
        OVERWORLD_BROWN(SporelingType.createLocation("geo/overworld_brown_sporeling.geo.json"), SporelingType.createLocation("textures/model/entity/sporeling_brown_overworld.png")),
        OVERWORLD_RED(SporelingType.createLocation("geo/overworld_red_sporeling.geo.json"), SporelingType.createLocation("textures/model/entity/sporeling_red_overworld.png")),
        NETHER_BROWN(SporelingType.createLocation("geo/nether_brown_sporeling.geo.json"), SporelingType.createLocation("textures/model/entity/sporeling_brown_nether.png")),
        NETHER_RED(SporelingType.createLocation("geo/nether_red_sporeling.geo.json"), SporelingType.createLocation("textures/model/entity/sporeling_red_nether.png")),
        WARPED_FUNGI(SporelingType.createLocation("geo/warped_fungi_sporeling.geo.json"), SporelingType.createLocation("textures/model/entity/sporeling_warped_fungi.png")),
        CRIMSON_FUNGUS(SporelingType.createLocation("geo/warped_fungi_sporeling.geo.json"), SporelingType.createLocation("textures/model/entity/sporeling_crimson_fungus.png"));

        public final ResourceLocation modelLocation;
        public final ResourceLocation textureLocation;

        private SporelingType(ResourceLocation ml, ResourceLocation tl) {
            this.modelLocation = ml;
            this.textureLocation = tl;
        }

        private static ResourceLocation createLocation(String pathPart) {
            return new ResourceLocation("cnb", pathPart);
        }

        public ResourceLocation getModelLocation() {
            return this.modelLocation;
        }

        public ResourceLocation getTextureLocation() {
            return this.textureLocation;
        }
    }
}

