/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.common.entites;

import com.cgessinger.creaturesandbeasts.common.config.CNBConfig;
import com.cgessinger.creaturesandbeasts.common.goals.FindWaterOneDeepGoal;
import com.cgessinger.creaturesandbeasts.common.init.ModItems;
import com.cgessinger.creaturesandbeasts.common.init.ModSoundEventTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IForgeShearable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class LilytadEntity
extends AnimalEntity
implements IForgeShearable,
IAnimatable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final DataParameter<Boolean> SHEARED = EntityDataManager.func_187226_a(LilytadEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int shearedTimer = 0;

    public LilytadEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70749_g = new LookController((MobEntity)this){

            public void func_75649_a() {
                LilytadEntity lilytad = (LilytadEntity)this.field_75659_a;
                if (lilytad.shouldLookAround()) {
                    super.func_75649_a();
                }
            }
        };
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SHEARED, (Object)false);
        super.func_70088_a();
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.shearedTimer = compound.func_74762_e("ShearedTimer");
        this.setSheared(this.shearedTimer > 0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("ShearedTimer", this.shearedTimer);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new FindWaterOneDeepGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0){

            public boolean func_75250_a() {
                return !this.field_75457_a.field_70170_p.func_204610_c(this.field_75457_a.func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206959_a) && super.func_75250_a();
            }

            public boolean func_75253_b() {
                return !this.field_75457_a.field_70170_p.func_204610_c(this.field_75457_a.func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206959_a) && super.func_75253_b();
            }
        });
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.func_201670_d() && this.shearedTimer > 0) {
            this.setSheared(--this.shearedTimer > 0);
        }
    }

    protected void func_85033_bc() {
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2), EntityPredicates.func_200823_a((Entity)this));
        if (!list.isEmpty()) {
            int i = this.field_70170_p.func_82736_K().func_223592_c(GameRules.field_223616_s);
            if (i > 0 && list.size() > i - 1 && this.field_70146_Z.nextInt(4) == 0) {
                int j = 0;
                for (Entity entity : list) {
                    if (entity.func_184218_aH()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.func_70097_a(DamageSource.field_191291_g, 6.0f);
                }
            }
            for (Entity entity : list) {
                this.func_82167_n(entity);
            }
        }
    }

    public boolean func_241845_aY() {
        return this.func_70089_S();
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    private <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        if (!(this.field_70721_aZ > -0.15f) || !(this.field_70721_aZ < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("lilytad.walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    public boolean getSheared() {
        return (Boolean)this.field_70180_af.func_187225_a(SHEARED);
    }

    public boolean isShearable(@Nonnull ItemStack item, World world, BlockPos pos) {
        return !this.getSheared();
    }

    public void setSheared(boolean sheared) {
        this.field_70180_af.func_187227_b(SHEARED, (Object)sheared);
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable PlayerEntity player, @Nonnull ItemStack item, World world, BlockPos pos, int fortune) {
        if (!world.field_72995_K) {
            this.setSheared(true);
            this.shearedTimer = 18000;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.add(new ItemStack((IItemProvider)ModItems.LILYTAD_FLOWER.get()));
            return items;
        }
        return Collections.emptyList();
    }

    public boolean shouldLookAround() {
        return !this.field_70170_p.func_204610_c(this.func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEventTypes.LILYTAD_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEventTypes.LILYTAD_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEventTypes.LILYTAD_DEATH.get();
    }

    public void func_70623_bb() {
        if (!CNBConfig.ServerConfig.LILYTAD_CONFIG.shouldExist) {
            this.func_70106_y();
            return;
        }
        super.func_70623_bb();
    }

    public static boolean canLilytadSpawn(EntityType<LilytadEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return true;
    }
}

