/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.client.entity.model;

import com.cgessinger.creaturesandbeasts.entities.CindershellEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class CindershellModel
extends AnimatedGeoModel<CindershellEntity> {
    private static final ResourceLocation CINDERSHELL_MODEL = new ResourceLocation("cnb", "geo/entity/cindershell/cindershell.geo.json");
    private static final ResourceLocation BABY_CINDERSHELL_MODEL = new ResourceLocation("cnb", "geo/entity/cindershell/baby_cindershell.geo.json");
    private static final ResourceLocation CINDERSHELL_FURNACE_MODEL = new ResourceLocation("cnb", "geo/entity/cindershell/cindershell_furnace.geo.json");
    private static final ResourceLocation CINDERSHELL_TEXTURE = new ResourceLocation("cnb", "textures/entity/cindershell/cindershell.png");
    private static final ResourceLocation BABY_CINDERSHELL_TEXTURE = new ResourceLocation("cnb", "textures/entity/cindershell/baby_cindershell.png");
    private static final ResourceLocation CINDERSHELL_ANIMATIONS = new ResourceLocation("cnb", "animations/cindershell.json");

    public ResourceLocation getModelResource(CindershellEntity entity) {
        if (entity.m_6162_()) {
            return BABY_CINDERSHELL_MODEL;
        }
        if (entity.hasFurnace()) {
            return CINDERSHELL_FURNACE_MODEL;
        }
        return CINDERSHELL_MODEL;
    }

    public ResourceLocation getTextureResource(CindershellEntity entity) {
        return entity.m_6162_() ? BABY_CINDERSHELL_TEXTURE : CINDERSHELL_TEXTURE;
    }

    public ResourceLocation getAnimationResource(CindershellEntity entity) {
        return CINDERSHELL_ANIMATIONS;
    }

    public void setLivingAnimations(CindershellEntity entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone head_rotation = this.getAnimationProcessor().getBone("head_rotation");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        head_rotation.setRotationX(extraData.headPitch * ((float)Math.PI / 180));
        head_rotation.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
    }
}

