/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.config.library.element.handler;

import com.cgessinger.creaturesandbeasts.config.library.annotation.DoubleRange;
import com.cgessinger.creaturesandbeasts.config.library.annotation.FloatRange;
import com.cgessinger.creaturesandbeasts.config.library.annotation.IntegerRange;
import com.cgessinger.creaturesandbeasts.config.library.element.IConfigElement;
import com.cgessinger.creaturesandbeasts.config.library.element.NumberConfigElement;
import com.cgessinger.creaturesandbeasts.config.library.element.handler.IConfigElementHandler;
import com.cgessinger.creaturesandbeasts.config.library.util.annotation.Nullable;
import java.lang.reflect.Field;

public final class DoubleElementHandler
implements IConfigElementHandler<Double, Number> {
    public static final DoubleElementHandler INSTANCE = new DoubleElementHandler();

    private DoubleElementHandler() {
    }

    @Override
    public IConfigElement<Double> create(Field field) {
        DoubleRange rangeD = field.getAnnotation(DoubleRange.class);
        FloatRange rangeF = field.getAnnotation(FloatRange.class);
        IntegerRange rangeI = field.getAnnotation(IntegerRange.class);
        if (rangeF != null) {
            System.err.println(String.format("WARNING: %s has a %s annotation, but is a double.", field.toGenericString(), FloatRange.class.getSimpleName()));
        }
        if (rangeI != null) {
            System.err.println(String.format("WARNING: %s has an %s annotation, but is a double.", field.toGenericString(), IntegerRange.class.getSimpleName()));
        }
        double min = Double.MIN_VALUE;
        double max = Double.MAX_VALUE;
        if (rangeD != null) {
            min = rangeD.min();
            max = rangeD.max();
        }
        return new NumberConfigElement<Double>(field, min, max, this);
    }

    @Override
    public IConfigElement<Double> update(IConfigElement<Double> element, @Nullable Double value) {
        if (value != null) {
            element.set((double)value);
        }
        return element;
    }

    @Override
    public Number serialize(IConfigElement<Double> element) {
        Double value = element.getFromField();
        return value == null ? element.getDefault() : value;
    }

    @Override
    public Double deserialize(Number obj) {
        return obj.doubleValue();
    }

    @Override
    public boolean canHandle(Class<?> clazz) {
        return clazz.equals(Double.class) || clazz.equals(Double.TYPE) || clazz.isAssignableFrom(Double.class) || clazz.isAssignableFrom(Double.TYPE);
    }
}

