/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.config.library.element.handler;

import com.cgessinger.creaturesandbeasts.config.library.element.IConfigElement;
import com.cgessinger.creaturesandbeasts.config.library.element.NumberConfigElement;
import com.cgessinger.creaturesandbeasts.config.library.element.handler.IConfigElementHandler;
import com.cgessinger.creaturesandbeasts.config.library.util.Util;
import com.cgessinger.creaturesandbeasts.config.library.util.annotation.Nullable;
import java.lang.reflect.Field;

public class NumberElementHandler
implements IConfigElementHandler<Number, Number> {
    public static final NumberElementHandler INSTANCE = new NumberElementHandler();

    private NumberElementHandler() {
    }

    @Override
    public IConfigElement<Number> create(Field field) {
        return new NumberConfigElement<Number>(field, Double.MIN_VALUE, Double.MAX_VALUE, this);
    }

    @Override
    public IConfigElement<Number> update(IConfigElement<Number> element, @Nullable Number obj) {
        if (obj != null) {
            element.set(obj.doubleValue());
        }
        return element;
    }

    @Override
    public Number serialize(IConfigElement<Number> element) {
        Number value = element.getFromField();
        return value == null ? (Number)element.getDefault() : (Number)value;
    }

    @Override
    public Number deserialize(Number obj) {
        return obj;
    }

    @Override
    public boolean canHandle(Class<?> clazz) {
        return Util.isNumber(clazz);
    }
}

