/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.config.library.util;

import com.cgessinger.creaturesandbeasts.config.library.annotation.Category;
import com.cgessinger.creaturesandbeasts.config.library.annotation.Configurable;
import com.cgessinger.creaturesandbeasts.config.library.util.annotation.Nullable;
import java.lang.reflect.Field;
import java.util.Objects;

public final class Util {
    private Util() {
    }

    @Nullable
    public static Class<?> getPrimitive(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz must not be null");
        if (clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        if (clazz.equals(Byte.class)) {
            return Byte.TYPE;
        }
        if (clazz.equals(Character.class)) {
            return Character.TYPE;
        }
        if (clazz.equals(Short.class)) {
            return Short.TYPE;
        }
        if (clazz.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (clazz.equals(Long.class)) {
            return Long.TYPE;
        }
        if (clazz.equals(Float.class)) {
            return Float.TYPE;
        }
        if (clazz.equals(Double.class)) {
            return Double.TYPE;
        }
        return null;
    }

    public static boolean isNumber(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz must not be null");
        if (clazz.isPrimitive()) {
            clazz = Util.getPrimitive(clazz);
        }
        return clazz.isAssignableFrom(Number.class) || clazz.equals(Byte.TYPE) || clazz.equals(Short.TYPE) || clazz.equals(Integer.TYPE) || clazz.equals(Long.TYPE) || clazz.equals(Float.TYPE) || clazz.equals(Double.TYPE);
    }

    public static String getCategory(Field field) {
        Objects.requireNonNull(field, "field must not be null");
        Configurable configurable = field.getAnnotation(Configurable.class);
        Object category = configurable != null ? configurable.category() : "";
        if ("".equals(category)) {
            category = Util.getCategory(field.getDeclaringClass());
        } else {
            String superCategory = Util.getCategory(field.getDeclaringClass());
            if (!"".equals(superCategory)) {
                category = superCategory + "." + (String)category;
            }
        }
        return category;
    }

    public static String getCategory(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz must not be null");
        Category configurable = clazz.getAnnotation(Category.class);
        Object category = configurable != null ? configurable.value() : "";
        Class<?> clazz2 = clazz.getDeclaringClass();
        if (clazz2 != null) {
            if ("".equals(category)) {
                category = Util.getCategory(clazz2);
            } else {
                String superCategory = Util.getCategory(clazz2);
                if (!"".equals(superCategory)) {
                    category = superCategory + "." + (String)category;
                }
            }
        }
        return category;
    }
}

