/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.entities;

import com.cgessinger.creaturesandbeasts.entities.ThrownCactemSpearEntity;
import com.cgessinger.creaturesandbeasts.init.CNBEntityTypes;
import com.cgessinger.creaturesandbeasts.init.CNBItems;
import com.cgessinger.creaturesandbeasts.init.CNBParticleTypes;
import com.cgessinger.creaturesandbeasts.init.CNBSoundEvents;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.Animation;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.SoundKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class CactemEntity
extends AgeableMob
implements RangedAttackMob,
IAnimatable {
    private static final EntityDataAccessor<Boolean> ELDER = SynchedEntityData.m_135353_(CactemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(CactemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SPEAR_SHOWN = SynchedEntityData.m_135353_(CactemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HEALING = SynchedEntityData.m_135353_(CactemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TRADING = SynchedEntityData.m_135353_(CactemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> IDLE_ANIM = SynchedEntityData.m_135353_(CactemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final RandomStrollGoal elderStrollGoal = new RandomStrollGoal((PathfinderMob)this, 0.65);
    private final TradeGoal tradeGoal = new TradeGoal(this, 16.0, 0.65);
    private final HealGoal healGoal = new HealGoal(this, 0.65, 100, 160, 16.0f, 7.0f);
    private final RandomStrollGoal randomStrollGoal = new RandomStrollGoal((PathfinderMob)this, 1.0);
    private final FollowElderGoal followElderGoal = new FollowElderGoal(this, 1.0);
    private final RangedSpearAttackGoal spearAttackGoal = new RangedSpearAttackGoal(this, 60, 16.0f);
    private final BecomeElderGoal becomeElderGoal = new BecomeElderGoal(this, 32.0f);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private final UUID healthReductionUUID = UUID.fromString("65a301bb-531d-499e-939c-eda5b857c0b4");
    private final float babyHealth = 20.0f;
    private int healCooldown = 0;

    public CactemEntity(EntityType<CactemEntity> entity, Level level) {
        super(entity, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ELDER, (Object)false);
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(SPEAR_SHOWN, (Object)true);
        this.f_19804_.m_135372_(HEALING, (Object)false);
        this.f_19804_.m_135372_(TRADING, (Object)false);
        this.f_19804_.m_135372_(IDLE_ANIM, (Object)0);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("IsElder")) {
            this.setElder(tag.m_128471_("IsElder"));
        } else if (tag.m_128441_("Age") && tag.m_128451_("Age") >= 0) {
            this.m_21008_(this.m_7655_(), new ItemStack((ItemLike)CNBItems.CACTEM_SPEAR.get()));
        }
        this.reassessGoals();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("IsElder", ((Boolean)this.f_19804_.m_135370_(ELDER)).booleanValue());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{CactemEntity.class}).m_26044_(new Class[0]));
    }

    private void reassessGoals() {
        this.f_21345_.m_25363_((Goal)this.elderStrollGoal);
        this.f_21345_.m_25363_((Goal)this.randomStrollGoal);
        this.f_21345_.m_25363_((Goal)this.spearAttackGoal);
        this.f_21345_.m_25363_((Goal)this.followElderGoal);
        this.f_21345_.m_25363_((Goal)this.becomeElderGoal);
        this.f_21345_.m_25363_((Goal)this.tradeGoal);
        this.f_21345_.m_25363_((Goal)this.healGoal);
        if (this.isElder()) {
            this.f_21345_.m_25352_(1, (Goal)this.tradeGoal);
            this.f_21345_.m_25352_(1, (Goal)this.healGoal);
            this.f_21345_.m_25352_(2, (Goal)this.elderStrollGoal);
        } else if (!this.m_6162_()) {
            this.f_21345_.m_25352_(1, (Goal)this.spearAttackGoal);
            this.f_21345_.m_25352_(1, (Goal)this.followElderGoal);
            this.f_21345_.m_25352_(2, (Goal)this.randomStrollGoal);
            this.f_21345_.m_25352_(5, (Goal)this.becomeElderGoal);
        } else {
            this.f_21345_.m_25352_(1, (Goal)this.followElderGoal);
            this.f_21345_.m_25352_(2, (Goal)this.randomStrollGoal);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isElder() && !this.m_21120_(this.m_7655_()).m_150930_((Item)CNBItems.HEAL_SPELL_BOOK_1.get())) {
            this.m_21008_(this.m_7655_(), new ItemStack((ItemLike)CNBItems.HEAL_SPELL_BOOK_1.get()));
        }
        if (this.isHealing()) {
            this.spawnHealParticles();
        }
        if (this.healCooldown > 0) {
            --this.healCooldown;
        }
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public int m_213860_() {
        return 3 + this.f_19853_.f_46441_.m_188503_(4);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroup, @Nullable CompoundTag tag) {
        double elderChance = level.m_213780_().m_188500_();
        if (spawnGroup == null) {
            spawnGroup = new AgeableMob.AgeableMobGroupData(0.5f);
        }
        if (!this.m_6162_()) {
            if (elderChance < 0.25) {
                this.setElder(true);
                this.m_21008_(this.m_7655_(), new ItemStack((ItemLike)CNBItems.HEAL_SPELL_BOOK_1.get()));
            } else {
                this.m_21008_(this.m_7655_(), new ItemStack((ItemLike)CNBItems.CACTEM_SPEAR.get()));
                this.setIdleAnim(this.f_19796_.m_188503_(2));
            }
        }
        this.reassessGoals();
        return super.m_6518_(level, difficulty, spawnType, spawnGroup, tag);
    }

    public void m_6504_(LivingEntity entity, float damage) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(this.m_7655_()));
        ThrownCactemSpearEntity spearEntity = new ThrownCactemSpearEntity(this.f_19853_, (LivingEntity)this, itemstack);
        double d0 = entity.m_20185_() - this.m_20185_();
        double d1 = entity.m_20227_(0.3333333333333333) - spearEntity.m_20186_();
        double d2 = entity.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        spearEntity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.f_19853_.m_46791_().m_19028_() * 4);
        this.f_19853_.m_7967_((Entity)spearEntity);
    }

    private void performHeal(float range) {
        List list = this.f_19853_.m_45976_(CactemEntity.class, this.m_20191_().m_82377_((double)range, 4.0, (double)range));
        for (CactemEntity nearbyCactem : list) {
            nearbyCactem.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 1));
        }
    }

    private void spawnHealParticles() {
        for (float i = 0.0f; i < (float)Math.PI * 2; i += this.f_19796_.m_188501_() * 0.8f + 0.5f) {
            this.f_19853_.m_7106_((ParticleOptions)CNBParticleTypes.CACTEM_HEAL_PARTICLE.get(), this.m_20185_() + (double)Mth.m_14089_((float)i) * 1.25, this.m_20186_(), this.m_20189_() + (double)Mth.m_14031_((float)i) * 1.25, 0.0, 0.0, 0.0);
        }
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        double MAX_HEALTH = this.m_21051_(Attributes.f_22276_).m_22135_();
        if (this.m_6162_()) {
            Objects.requireNonNull(this);
            if (MAX_HEALTH > 20.0) {
                HashMultimap multimap = HashMultimap.create();
                Objects.requireNonNull(this);
                multimap.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(this.healthReductionUUID, "cactem_health_reduction", 20.0 - MAX_HEALTH, AttributeModifier.Operation.ADDITION));
                this.m_21204_().m_22178_((Multimap)multimap);
                this.m_21153_(this.babyHealth);
            }
        }
    }

    protected void m_30232_() {
        super.m_30232_();
        double elderChance = this.f_19796_.m_188500_();
        if (!this.m_6162_()) {
            if (elderChance < 0.25) {
                this.setElder(true);
                this.m_21008_(this.m_7655_(), new ItemStack((ItemLike)CNBItems.HEAL_SPELL_BOOK_1.get()));
            } else {
                this.m_21008_(this.m_7655_(), new ItemStack((ItemLike)CNBItems.CACTEM_SPEAR.get()));
            }
        }
        float percentHealth = this.m_21223_() / this.babyHealth;
        this.m_21051_(Attributes.f_22276_).m_22120_(this.healthReductionUUID);
        this.m_21153_(percentHealth * (float)this.m_21051_(Attributes.f_22276_).m_22135_());
        this.reassessGoals();
    }

    protected float m_21519_(EquipmentSlot p_21520_) {
        return 0.0f;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.5f;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob entity) {
        return (AgeableMob)((EntityType)CNBEntityTypes.CACTEM.get()).m_20615_((Level)level);
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)CNBSoundEvents.CACTEM_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)CNBSoundEvents.CACTEM_HURT.get();
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.75f : 1.0f;
    }

    public boolean isElder() {
        return (Boolean)this.f_19804_.m_135370_(ELDER);
    }

    public void setElder(boolean isElder) {
        this.f_19804_.m_135381_(ELDER, (Object)isElder);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setAttacking(boolean isAttacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)isAttacking);
    }

    public boolean isSpearShown() {
        return (Boolean)this.f_19804_.m_135370_(SPEAR_SHOWN);
    }

    public void setSpearShown(boolean isShown) {
        this.f_19804_.m_135381_(SPEAR_SHOWN, (Object)isShown);
    }

    public boolean isHealing() {
        return (Boolean)this.f_19804_.m_135370_(HEALING);
    }

    public void setHealing(boolean isHealing) {
        this.f_19804_.m_135381_(HEALING, (Object)isHealing);
    }

    public boolean isTrading() {
        return (Boolean)this.f_19804_.m_135370_(TRADING);
    }

    public void setTrading(boolean isTrading) {
        this.f_19804_.m_135381_(TRADING, (Object)isTrading);
    }

    public int getIdleAnim() {
        return (Integer)this.f_19804_.m_135370_(IDLE_ANIM);
    }

    public void setIdleAnim(int anim) {
        switch (anim) {
            default: {
                this.f_19804_.m_135381_(IDLE_ANIM, (Object)0);
                break;
            }
            case 1: {
                this.f_19804_.m_135381_(IDLE_ANIM, (Object)1);
            }
        }
    }

    private <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        if (this.isHealing()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("cactem_elder_heal"));
        } else if (this.isTrading()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("cactem_admire"));
        } else if (!(this.f_20924_ > -0.075f) || !(this.f_20924_ < 0.075f)) {
            if (this.isElder()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("cactem_elder_walk"));
            } else if (this.m_6162_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("cactem_baby_run"));
            } else if (this.isAttacking() || !this.isSpearShown()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("cactem_run_throw"));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("cactem_run"));
                this.setIdleAnim(this.f_19796_.m_188503_(2));
            }
        } else if (this.isElder()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("cactem_idle_2"));
        } else if (this.m_6162_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("cactem_idle"));
        } else if (this.getIdleAnim() == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("cactem_idle"));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("cactem_idle_2"));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState attackAnimationPredicate(AnimationEvent<E> event) {
        Animation currentAnim = event.getController().getCurrentAnimation();
        if (this.isAttacking() || currentAnim != null && currentAnim.animationName.equals("cactem_throw") && event.getController().getAnimationState().equals((Object)AnimationState.Running)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("cactem_throw"));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        this.setSpearShown(true);
        return PlayState.STOP;
    }

    private <E extends IAnimatable> void soundListener(SoundKeyframeEvent<E> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (event.sound.equals("cactem_heal")) {
            player.m_5496_((SoundEvent)CNBSoundEvents.CACTEM_HEAL.get(), 1.0f, 1.0f);
        } else if (event.sound.equals("spear_throw")) {
            player.m_5496_((SoundEvent)CNBSoundEvents.SPEAR_THROW.get(), 1.0f, 1.0f);
        }
    }

    public void registerControllers(AnimationData animationData) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate);
        AnimationController attackController = new AnimationController((IAnimatable)this, "attackController", 0.0f, this::attackAnimationPredicate);
        controller.registerSoundListener(this::soundListener);
        attackController.registerSoundListener(this::soundListener);
        animationData.addAnimationController(controller);
        animationData.addAnimationController(attackController);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class TradeGoal
    extends Goal {
        protected Path path;
        protected ItemEntity itemInstance;
        protected double tradeTime;
        protected double tradeDelay;
        protected final double speed;
        protected final CactemEntity entityIn;
        protected final double range;
        protected final PathNavigation navigation;

        public TradeGoal(CactemEntity entityIn, double range, double speedIn) {
            this.entityIn = entityIn;
            this.range = range;
            this.speed = speedIn;
            this.navigation = entityIn.m_21573_();
        }

        public boolean m_8036_() {
            if (this.itemInstance == null && this.entityIn.m_5448_() == null) {
                List list = this.entityIn.f_19853_.m_45976_(ItemEntity.class, this.entityIn.m_20191_().m_82377_(this.range, 3.0, this.range));
                for (ItemEntity item : list) {
                    if (!item.m_32055_().m_41656_(Items.f_42747_.m_7968_())) continue;
                    this.path = this.navigation.m_7864_(item.m_20097_(), 0);
                    this.itemInstance = item;
                    return this.path != null;
                }
            }
            return false;
        }

        public void m_8041_() {
            this.itemInstance = null;
            this.path = null;
            this.navigation.m_26573_();
            this.entityIn.setTrading(false);
        }

        public void m_8056_() {
            this.navigation.m_26536_(this.path, this.speed);
        }

        public boolean m_8045_() {
            return !(this.navigation.m_26571_() && !(this.tradeTime > 0.0) || this.itemInstance.m_213877_() && !this.entityIn.isTrading());
        }

        public void trade() {
            this.entityIn.setTrading(false);
            double lootChance = this.entityIn.f_19796_.m_188500_();
            ItemStack returnItem = lootChance < 0.2 ? new ItemStack((ItemLike)Items.f_42616_, 15 + this.entityIn.f_19796_.m_188503_(10)) : (lootChance < 0.7 ? new ItemStack((ItemLike)CNBItems.HEAL_SPELL_BOOK_1.get()) : new ItemStack((ItemLike)Items.f_41866_));
            this.entityIn.m_19983_(returnItem);
            this.entityIn.m_5496_(SoundEvents.f_12019_, 0.8f, 1.0f);
        }

        public void m_8037_() {
            if (this.tradeDelay <= 0.0) {
                if (this.entityIn.m_20280_((Entity)this.itemInstance) < 2.0) {
                    this.navigation.m_26517_(0.0);
                    if (!this.entityIn.isTrading() && !this.itemInstance.m_213877_()) {
                        this.entityIn.setTrading(true);
                        this.itemInstance.m_32055_().m_41774_(1);
                        if (this.itemInstance.m_32055_().m_41619_()) {
                            this.itemInstance.m_146870_();
                        }
                        this.entityIn.m_7618_(EntityAnchorArgument.Anchor.EYES, this.itemInstance.m_20182_());
                        this.tradeTime = 54.0;
                    } else {
                        double d;
                        this.tradeTime -= 1.0;
                        if (d <= 0.0) {
                            this.trade();
                            this.tradeDelay = 20.0;
                        } else if (this.tradeTime % 3.0 == 0.0) {
                            this.entityIn.m_7618_(EntityAnchorArgument.Anchor.EYES, this.itemInstance.m_20182_());
                            this.entityIn.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.itemInstance.m_32055_()), this.entityIn.m_20208_(0.5) + this.entityIn.m_20154_().f_82479_ / 2.0, this.entityIn.m_20187_(), this.entityIn.m_20262_(0.5) + this.entityIn.m_20154_().f_82481_ / 2.0, 4.0, 0.0, 0.0);
                        }
                    }
                } else {
                    this.navigation.m_26517_(this.speed);
                }
            } else {
                this.tradeDelay -= 1.0;
            }
        }
    }

    static class HealGoal
    extends Goal {
        private final CactemEntity cactem;
        private final double speedModifier;
        private final int healIntervalMin;
        private final int healIntervalDiff;
        private final float healRadius;
        private final float avoidDist;

        public HealGoal(CactemEntity cactem, double speedModifier, int healIntervalMin, int healIntervalMax, float healRadius, float avoidDist) {
            this.cactem = cactem;
            this.speedModifier = speedModifier;
            this.healIntervalMin = healIntervalMin;
            this.healIntervalDiff = healIntervalMax - healIntervalMin;
            this.healRadius = healRadius;
            this.avoidDist = avoidDist;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.cactem.m_5448_();
            if (livingentity != null && !livingentity.m_6084_()) {
                this.cactem.m_6710_(null);
                livingentity = null;
            }
            boolean cactemNeedsHealing = this.cactemNeedsHeal(this.cactem, this.cactem.f_19853_);
            if (livingentity == null && !cactemNeedsHealing) {
                return false;
            }
            if (cactemNeedsHealing) {
                return true;
            }
            return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            if (this.cactem.m_5448_() != null) {
                this.cactem.m_21561_(true);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.cactem.m_21561_(false);
            this.cactem.setHealing(false);
            this.cactem.m_5810_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            Vec3 vec3;
            LivingEntity targetEntity = this.cactem.m_5448_();
            if (this.cactem.m_6117_()) {
                this.cactem.m_21573_().m_26573_();
                int i = this.cactem.m_21252_();
                if (i == 20) {
                    this.cactem.performHeal(this.healRadius);
                } else if (i >= 38) {
                    this.cactem.setHealing(false);
                    this.cactem.m_5810_();
                    this.cactem.healCooldown = this.healIntervalMin + this.cactem.f_19796_.m_188503_(this.healIntervalDiff + 1);
                }
            } else if (this.cactem.healCooldown <= 0 && this.cactemNeedsHeal(this.cactem, this.cactem.f_19853_)) {
                this.cactem.m_21573_().m_26573_();
                this.cactem.setHealing(true);
                this.cactem.m_6672_(this.cactem.m_7655_());
            } else if (targetEntity != null && !this.cactem.m_21573_().m_26572_() && this.cactem.m_20280_((Entity)this.cactem.m_5448_()) <= (double)(this.avoidDist * this.avoidDist)) {
                Vec3 vec32 = DefaultRandomPos.m_148407_((PathfinderMob)this.cactem, (int)((int)this.avoidDist), (int)7, (Vec3)targetEntity.m_20182_());
                if (vec32 != null) {
                    Path path = this.cactem.m_21573_().m_26524_(vec32.f_82479_, vec32.f_82480_, vec32.f_82481_, 0);
                    this.cactem.m_21573_().m_26536_(path, this.speedModifier);
                }
            } else if (targetEntity != null && !this.cactem.m_21573_().m_26572_() && (vec3 = DefaultRandomPos.m_148412_((PathfinderMob)this.cactem, (int)((int)this.avoidDist), (int)7, (Vec3)targetEntity.m_20182_(), (double)1.5707963705062866)) != null) {
                Path path = this.cactem.m_21573_().m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
                this.cactem.m_21573_().m_26536_(path, this.speedModifier);
            }
        }

        private boolean cactemNeedsHeal(CactemEntity elder, Level level) {
            List list = level.m_45976_(CactemEntity.class, elder.m_20191_().m_82377_((double)this.healRadius, 4.0, (double)this.healRadius));
            for (CactemEntity nearbyCactem : list) {
                if (nearbyCactem.isElder() || !((double)(nearbyCactem.m_21223_() / nearbyCactem.m_21233_()) <= 0.5)) continue;
                return true;
            }
            return false;
        }
    }

    static class FollowElderGoal
    extends Goal {
        public static final int HORIZONTAL_SCAN_RANGE = 32;
        public static final int VERTICAL_SCAN_RANGE = 4;
        public static final int DONT_FOLLOW_IF_CLOSER_THAN = 20;
        private final CactemEntity cactem;
        @Nullable
        private CactemEntity elder;
        private final double speedModifier;
        private int timeToRecalcPath;

        public FollowElderGoal(CactemEntity cactem, double speedModifier) {
            this.cactem = cactem;
            this.speedModifier = speedModifier;
        }

        public boolean m_8036_() {
            List list = this.cactem.f_19853_.m_45976_(CactemEntity.class, this.cactem.m_20191_().m_82377_(32.0, 4.0, 32.0));
            CactemEntity followTarget = null;
            double closestElderDistance = Double.MAX_VALUE;
            for (CactemEntity nearbyCactem : list) {
                double distanceToCactem;
                if (!nearbyCactem.isElder() || (distanceToCactem = this.cactem.m_20280_((Entity)nearbyCactem)) > closestElderDistance) continue;
                closestElderDistance = distanceToCactem;
                followTarget = nearbyCactem;
            }
            if (followTarget == null) {
                return false;
            }
            if (closestElderDistance < 400.0) {
                return false;
            }
            this.elder = followTarget;
            return true;
        }

        public boolean m_8045_() {
            if (!this.elder.m_6084_()) {
                return false;
            }
            double d0 = this.cactem.m_20280_((Entity)this.elder);
            return !(d0 < 8.0) && !(d0 > 256.0);
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
        }

        public void m_8041_() {
            this.elder = null;
        }

        public void m_8037_() {
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                Path path = this.cactem.m_21573_().m_6570_((Entity)this.elder, 8);
                this.cactem.m_21573_().m_26536_(path, this.speedModifier);
            }
        }
    }

    static class RangedSpearAttackGoal
    extends Goal {
        private final CactemEntity cactem;
        private final int attackIntervalMin;
        private final float attackRadiusSqr;
        private int attackTime = -1;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;

        public RangedSpearAttackGoal(CactemEntity cactem, int attackIntervalMin, float attackRadius) {
            this.cactem = cactem;
            this.attackIntervalMin = attackIntervalMin;
            this.attackRadiusSqr = attackRadius * attackRadius;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.cactem.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.cactem.m_21561_(true);
        }

        public void m_8041_() {
            super.m_8041_();
            this.cactem.m_21561_(false);
            this.seeTime = 0;
            this.attackTime = -1;
            this.cactem.setAttacking(false);
            this.cactem.m_5810_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity targetEntity = this.cactem.m_5448_();
            if (targetEntity != null) {
                boolean flag1;
                double d0 = this.cactem.m_20275_(targetEntity.m_20185_(), targetEntity.m_20186_(), targetEntity.m_20189_());
                boolean flag = this.cactem.m_21574_().m_148306_((Entity)targetEntity);
                boolean bl = flag1 = this.seeTime > 0;
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
                    this.cactem.m_21573_().m_26573_();
                    ++this.strafingTime;
                }
                if (this.strafingTime >= 20) {
                    if ((double)this.cactem.m_217043_().m_188501_() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)this.cactem.m_217043_().m_188501_() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)(this.attackRadiusSqr * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)(this.attackRadiusSqr * 0.5f)) {
                        this.strafingBackwards = true;
                    }
                    if (!this.cactem.m_6117_()) {
                        this.cactem.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                    }
                    this.cactem.m_21391_((Entity)targetEntity, 30.0f, 30.0f);
                } else {
                    this.cactem.m_21563_().m_24960_((Entity)targetEntity, 30.0f, 30.0f);
                }
                if (this.cactem.m_6117_()) {
                    int i;
                    if (!flag && this.seeTime < -60) {
                        this.cactem.setAttacking(false);
                        this.cactem.m_5810_();
                    } else if (flag && (i = this.cactem.m_21252_()) >= 6) {
                        this.cactem.setSpearShown(false);
                        this.cactem.setAttacking(false);
                        this.cactem.m_5810_();
                        this.cactem.m_6504_(targetEntity, 1.0f);
                        this.attackTime = this.attackIntervalMin;
                    }
                } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                    this.cactem.setAttacking(true);
                    this.cactem.m_6672_(this.cactem.m_7655_());
                }
            }
        }
    }

    static class BecomeElderGoal
    extends Goal {
        private final CactemEntity cactem;
        private final float elderRadius;

        public BecomeElderGoal(CactemEntity cactem, float elderRadius) {
            this.cactem = cactem;
            this.elderRadius = elderRadius;
        }

        public void m_8056_() {
            this.cactem.setElder(true);
            this.cactem.m_21008_(this.cactem.m_7655_(), new ItemStack((ItemLike)CNBItems.HEAL_SPELL_BOOK_1.get()));
            this.cactem.reassessGoals();
        }

        public boolean m_8036_() {
            return !this.isElderNear();
        }

        private boolean isElderNear() {
            List list = this.cactem.f_19853_.m_45976_(CactemEntity.class, this.cactem.m_20191_().m_82377_((double)this.elderRadius, 16.0, (double)this.elderRadius));
            for (CactemEntity nearbyCactem : list) {
                if (!nearbyCactem.isElder()) continue;
                return true;
            }
            return false;
        }
    }
}

