/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.entities;

import com.cgessinger.creaturesandbeasts.containers.CinderFurnaceContainer;
import com.cgessinger.creaturesandbeasts.init.CNBBlocks;
import com.cgessinger.creaturesandbeasts.init.CNBEntityTypes;
import com.cgessinger.creaturesandbeasts.init.CNBItems;
import com.cgessinger.creaturesandbeasts.init.CNBSoundEvents;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.SoundKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class CindershellEntity
extends Animal
implements IAnimatable,
Bucketable,
ContainerListener,
Container,
RecipeHolder,
StackedContentsCompatible,
MenuProvider {
    private static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.m_135353_(CindershellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(CindershellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FURNACE = SynchedEntityData.m_135353_(CindershellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> PLAYER = SynchedEntityData.m_135353_(CindershellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41954_, Items.f_41955_});
    private final UUID healthReductionUUID = UUID.fromString("189faad9-35de-4e15-a598-82d147b996d7");
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    protected CinderFurnaceContainer inventory;
    private Player playerInMenu;
    private int eatTimer = 0;
    int cookingProgress;
    int cookingTotalTime;
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return CindershellEntity.this.cookingProgress;
                }
                case 1: {
                    return CindershellEntity.this.cookingTotalTime;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    CindershellEntity.this.cookingProgress = value;
                    break;
                }
                case 1: {
                    CindershellEntity.this.cookingTotalTime = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();

    public CindershellEntity(EntityType<CindershellEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22278_, 100.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EATING, (Object)false);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(FURNACE, (Object)false);
        this.f_19804_.m_135372_(PLAYER, Optional.empty());
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("FromBucket", this.m_27487_());
        tag.m_128379_("HasFurnace", this.hasFurnace());
        if (this.hasFurnace()) {
            ListTag listtag = new ListTag();
            NonNullList<ItemStack> items = this.items;
            for (int i = 0; i < items.size(); ++i) {
                ItemStack itemstack = (ItemStack)items.get(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.m_128344_("Slot", (byte)i);
                itemstack.m_41739_(compoundtag);
                listtag.add((Object)compoundtag);
            }
            tag.m_128365_("Items", (Tag)listtag);
            if (((Optional)this.f_19804_.m_135370_(PLAYER)).isPresent()) {
                tag.m_128362_("Player", (UUID)((Optional)this.f_19804_.m_135370_(PLAYER)).get());
            }
            tag.m_128405_("CookTime", this.cookingProgress);
            tag.m_128405_("CookTimeTotal", this.cookingTotalTime);
        }
    }

    public void m_7378_(CompoundTag tag) {
        this.m_27497_(tag.m_128471_("FromBucket"));
        UUID playerUUID = null;
        if (tag.m_128441_("Player")) {
            playerUUID = tag.m_128342_("Player");
        }
        this.setFurnace(tag.m_128471_("HasFurnace"), playerUUID);
        if (this.hasFurnace()) {
            this.inventory = tag.m_128441_("Player") && this.f_19853_.m_46003_(tag.m_128342_("Player")) != null ? this.createMenu(this.m_19879_(), this.f_19853_.m_46003_(tag.m_128342_("Player")).m_150109_(), this.f_19853_.m_46003_(tag.m_128342_("Player"))) : this.createMenu(this.m_19879_(), new Inventory(null), null);
            ListTag listtag = tag.m_128437_("Items", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.m_128728_(i);
                int j = compoundtag.m_128445_("Slot") & 0xFF;
                if (j >= this.items.size()) continue;
                this.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundtag));
            }
            this.cookingProgress = tag.m_128451_("CookTime");
            this.cookingTotalTime = tag.m_128451_("CookTimeTotal");
        }
        super.m_7378_(tag);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new CindershellFloatGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new CindershellBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getEating()) {
            this.f_21344_.m_26573_();
            --this.eatTimer;
        }
        if (this.eatTimer == 10) {
            this.setHolding(ItemStack.f_41583_);
        } else if (this.eatTimer == 0) {
            this.setEating(false);
        }
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return 10.0f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.hasFurnace() && this.f_19796_.m_188500_() <= 0.25) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + (this.f_19796_.m_188500_() * 0.5 - 0.25), this.m_20186_() + 2.5 + (this.f_19796_.m_188500_() * 0.1 - 0.05), this.m_20189_() + (this.f_19796_.m_188500_() * 0.5 - 0.25), this.m_20184_().f_82479_, 0.0, this.m_20184_().f_82481_);
        }
        if (!this.f_19853_.f_46443_ && this.hasFurnace() && this.inventory.m_38853_(0).m_6657_()) {
            Recipe recipe = this.f_19853_.m_7465_().m_44015_(this.inventory.getRecipeType(), (Container)this, this.f_19853_).orElse(null);
            if (this.canBurn(recipe, (NonNullList<ItemStack>)this.inventory.m_38927_(), 64)) {
                if (this.f_19796_.m_188500_() < 0.1) {
                    this.m_5496_(SoundEvents.f_11907_, 1.0f, 1.0f);
                }
                ++this.cookingProgress;
                if (this.cookingProgress >= this.cookingTotalTime) {
                    this.cookingProgress = 0;
                    this.cookingTotalTime = CindershellEntity.getTotalCookTime(this.f_19853_, this.inventory.getRecipeType(), this);
                    if (this.smelt(recipe, this.items, 64)) {
                        this.m_6029_(recipe);
                    }
                }
            } else {
                this.cookingProgress = 0;
            }
        }
    }

    protected void m_20157_() {
        if (!this.hasFurnace()) {
            super.m_20157_();
        }
    }

    @Nullable
    public Entity m_5489_(ServerLevel level) {
        if (this.playerInMenu != null) {
            this.playerInMenu.m_6915_();
        }
        if (this.hasFurnace()) {
            this.cookingTotalTime = CindershellEntity.getTotalCookTime((Level)level, this.inventory.getRecipeType(), this);
        }
        return super.m_5489_(level);
    }

    public boolean m_6126_() {
        return true;
    }

    public static boolean checkCindershellSpawnRules(EntityType<CindershellEntity> entity, LevelAccessor level, MobSpawnType mobSpawnType, BlockPos pos, RandomSource random) {
        return pos.m_123342_() <= 50;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        if (dataTag != null) {
            if (dataTag.m_128441_("Age")) {
                this.m_146762_(dataTag.m_128451_("Age"));
            }
            if (dataTag.m_128441_("Health")) {
                this.m_21153_(dataTag.m_128457_("Health"));
            }
            if (dataTag.m_128441_("Name")) {
                this.m_6593_(Component.m_130674_((String)dataTag.m_128461_("Name")));
            }
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean m_6898_(ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    public InteractionResult tryStartEat(Player player, ItemStack stack) {
        if (stack.m_41720_() == Items.f_41954_ || stack.m_41720_() == Items.f_41955_) {
            int i = this.m_146764_();
            if (!this.f_19853_.f_46443_ && i == 0 && this.m_5957_()) {
                this.m_142075_(player, player.m_7655_(), stack);
                this.setEating(true);
                this.m_27595_(player);
                this.m_5496_((SoundEvent)CNBSoundEvents.CINDERSHELL_ADULT_EAT.get(), 1.2f, 1.0f);
                this.setHolding(stack);
                return InteractionResult.SUCCESS;
            }
            if (this.m_6162_()) {
                this.m_5496_((SoundEvent)CNBSoundEvents.CINDERSHELL_BABY_EAT.get(), 1.3f, 1.0f);
                this.m_142075_(player, player.m_7655_(), stack);
                this.m_146740_((int)((float)(-i) / 20.0f * 0.1f), true);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (this.f_19853_.f_46443_) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        if (item.m_41656_(Items.f_42448_.m_7968_()) && this.m_6084_() && this.m_6162_()) {
            this.m_5496_(this.m_142623_(), 1.0f, 1.0f);
            ItemStack bucketItem = this.m_28282_();
            this.m_6872_(bucketItem);
            ItemStack bucketWithData = ItemUtils.m_41817_((ItemStack)item, (Player)player, (ItemStack)bucketItem, (boolean)false);
            player.m_21008_(hand, bucketWithData);
            Level level = this.f_19853_;
            if (!level.f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, bucketItem);
            }
            this.m_146870_();
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (!this.m_6162_() && !this.hasFurnace() && item.m_41656_(((BlockItem)CNBItems.CINDERSHELL_FURNACE.get()).m_7968_())) {
            this.setFurnace(true, player.m_20148_());
            this.inventory = this.createMenu(this.m_19879_(), player.m_150109_(), player);
            if (!player.m_150110_().f_35937_) {
                item.m_41774_(1);
            }
            this.m_5496_(SoundEvents.f_12034_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (this.m_6898_(item) && !this.getEating()) {
            return this.tryStartEat(player, item);
        }
        if (this.hasFurnace() && player.m_36341_()) {
            this.m_5907_();
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (this.hasFurnace()) {
            if (!this.f_19853_.f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public CinderFurnaceContainer createMenu(int id, Inventory playerInventory, Player player) {
        this.playerInMenu = player;
        return new CinderFurnaceContainer(id, playerInventory, this, this.dataAccess);
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.hasFurnace()) {
            this.m_5496_(SoundEvents.f_12034_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.8f);
            if (!this.f_19853_.f_46443_) {
                this.m_19998_((ItemLike)CNBBlocks.CINDER_FURNACE.get());
                for (int i = 0; i < this.inventory.m_6653_(); ++i) {
                    this.m_19983_(this.inventory.m_38853_(i).m_7993_());
                }
                ((CinderFurnaceContainer.CinderFurnaceResultSlot)this.inventory.m_38853_(1)).m_5845_(this.inventory.m_38853_(1).m_7993_());
                this.m_6211_();
            }
            this.setFurnace(false, null);
        }
    }

    public int m_6643_() {
        return 2;
    }

    public boolean m_7983_() {
        return this.items.isEmpty();
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.items, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        ItemStack itemstack = this.m_8020_(slot);
        boolean flag = !stack.m_41619_() && stack.m_41656_(itemstack) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)itemstack);
        this.items.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (slot == 0 && !flag) {
            this.dataAccess.m_8050_(1, CindershellEntity.getTotalCookTime(this.f_19853_, this.inventory.getRecipeType(), this));
            this.dataAccess.m_8050_(0, 0);
            this.m_6596_();
        }
    }

    public void m_6596_() {
    }

    public void m_6211_() {
        this.inventory.m_6650_();
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public static int getTotalCookTime(Level level, RecipeType<? extends AbstractCookingRecipe> recipeType, CindershellEntity container) {
        ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)container.f_19853_.m_46472_().m_135782_());
        float cookTimeMultiplier = dimensionKey.equals((Object)Level.f_46429_) ? 1.0f : 1.667f;
        return (int)((float)level.m_7465_().m_44015_(recipeType, (Container)container, level).map(AbstractCookingRecipe::m_43753_).orElse(200).intValue() * cookTimeMultiplier);
    }

    private boolean smelt(@Nullable Recipe<?> recipe, NonNullList<ItemStack> stack, int amount) {
        if (recipe != null && this.canBurn(recipe, stack, amount)) {
            ItemStack itemstack = (ItemStack)stack.get(0);
            ItemStack itemstack1 = recipe.m_5874_((Container)this);
            ItemStack itemstack2 = (ItemStack)stack.get(1);
            if (itemstack2.m_41619_()) {
                stack.set(1, (Object)itemstack1.m_41777_());
            } else if (itemstack2.m_150930_(itemstack1.m_41720_())) {
                itemstack2.m_41769_(itemstack1.m_41613_());
            }
            itemstack.m_41774_(1);
            return true;
        }
        return false;
    }

    private boolean canBurn(@Nullable Recipe<?> recipe, NonNullList<ItemStack> items, int maxStack) {
        if (!((ItemStack)items.get(0)).m_41619_() && recipe != null) {
            ItemStack itemstack = recipe.m_5874_((Container)this);
            if (itemstack.m_41619_()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)items.get(1);
            if (itemstack1.m_41619_()) {
                return true;
            }
            if (!itemstack1.m_41656_(itemstack)) {
                return false;
            }
            if (itemstack1.m_41613_() + itemstack.m_41613_() <= maxStack && itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack1.m_41741_()) {
                return true;
            }
            return itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack.m_41741_();
        }
        return false;
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.m_6423_();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @org.jetbrains.annotations.Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        List<Recipe<?>> list = this.getRecipesToAwardAndPopExperience(player.m_9236_(), player.m_20182_());
        player.m_7281_(list);
        this.recipesUsed.clear();
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 vec3) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                CindershellEntity.createExperience(level, vec3, entry.getIntValue(), ((AbstractCookingRecipe)recipe).m_43750_());
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel level, Vec3 vec3, int value, float experience) {
        int i = Mth.m_14143_((float)((float)value * experience));
        float f = Mth.m_14187_((float)((float)value * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)vec3, (int)i);
    }

    public void m_5809_(StackedContents stackedContents) {
        for (ItemStack itemstack : this.items) {
            stackedContents.m_36491_(itemstack);
        }
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    public void m_6872_(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        if (this.m_21525_()) {
            tag.m_128379_("NoAI", this.m_21525_());
        }
        if (this.m_20067_()) {
            tag.m_128379_("Silent", this.m_20067_());
        }
        if (this.m_20068_()) {
            tag.m_128379_("NoGravity", this.m_20068_());
        }
        if (this.m_146886_()) {
            tag.m_128379_("Glowing", this.m_146886_());
        }
        if (this.m_20147_()) {
            tag.m_128379_("Invulnerable", this.m_20147_());
        }
        tag.m_128350_("Health", this.m_21223_());
        tag.m_128405_("Age", this.m_146764_());
    }

    public void m_142278_(CompoundTag compound) {
        if (compound.m_128441_("NoAI")) {
            this.m_21557_(compound.m_128471_("NoAI"));
        }
        if (compound.m_128441_("Silent")) {
            this.m_20225_(compound.m_128471_("Silent"));
        }
        if (compound.m_128441_("NoGravity")) {
            this.m_20242_(compound.m_128471_("NoGravity"));
        }
        if (compound.m_128441_("Glowing")) {
            this.m_146915_(compound.m_128471_("Glowing"));
        }
        if (compound.m_128441_("Invulnerable")) {
            this.m_20331_(compound.m_128471_("Invulnerable"));
        }
        if (compound.m_128425_("Health", 99)) {
            this.m_21153_(compound.m_128457_("Health"));
        }
        if (compound.m_128441_("Age")) {
            this.m_146762_(compound.m_128451_("Age"));
        } else {
            this.m_146762_(-24000);
        }
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)CNBItems.CINDERSHELL_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11783_;
    }

    public void m_5757_(Container container) {
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        double MAX_HEALTH = this.m_21051_(Attributes.f_22276_).m_22135_();
        float babyHealth = 10.0f;
        if (this.m_6162_() && MAX_HEALTH > (double)babyHealth) {
            HashMultimap multimap = HashMultimap.create();
            multimap.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(this.healthReductionUUID, "yeti_health_reduction", (double)babyHealth - MAX_HEALTH, AttributeModifier.Operation.ADDITION));
            this.m_21204_().m_22178_((Multimap)multimap);
            this.m_21153_(babyHealth);
        }
    }

    protected void m_30232_() {
        super.m_30232_();
        this.m_21051_(Attributes.f_22276_).m_22120_(this.healthReductionUUID);
        this.m_21153_((float)this.m_21051_(Attributes.f_22276_).m_22135_());
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 23 && !this.f_19853_.m_5776_()) {
            this.f_19853_.m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        return pose == Pose.SLEEPING ? f_20910_ : super.m_6972_(pose).m_20390_(this.m_6134_(), this.getHeightScale());
    }

    private float getHeightScale() {
        return this.m_6162_() ? 0.35f : 1.0f;
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.55f : 1.0f;
    }

    public float m_20236_(Pose pose) {
        return this.m_20206_() * 0.2f;
    }

    public ItemStack getHolding() {
        return this.m_6844_(EquipmentSlot.MAINHAND);
    }

    public void setHolding(ItemStack stack) {
        this.m_8061_(EquipmentSlot.MAINHAND, stack);
    }

    public void setEating(boolean isEating) {
        this.eatTimer = isEating ? 40 : 0;
        this.f_19804_.m_135381_(EATING, (Object)isEating);
    }

    public boolean getEating() {
        return (Boolean)this.f_19804_.m_135370_(EATING);
    }

    public boolean hasFurnace() {
        return (Boolean)this.f_19804_.m_135370_(FURNACE);
    }

    public void setFurnace(boolean hasFurnace, @Nullable UUID playerUUID) {
        this.f_19804_.m_135381_(FURNACE, (Object)hasFurnace);
        if (playerUUID != null) {
            this.f_19804_.m_135381_(PLAYER, Optional.of(playerUUID));
        } else {
            this.f_19804_.m_135381_(PLAYER, Optional.empty());
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)CNBEntityTypes.CINDERSHELL.get()).m_20615_((Level)level);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return distanceToClosestPlayer > 256.0 && !this.hasFurnace();
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)CNBSoundEvents.CINDERSHELL_AMBIENT.get();
    }

    public int m_8100_() {
        return 120;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)CNBSoundEvents.CINDERSHELL_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)CNBSoundEvents.CINDERSHELL_HURT.get();
    }

    protected float m_6121_() {
        return super.m_6121_() * 2.0f;
    }

    public int m_8085_() {
        return 50;
    }

    public int m_8132_() {
        return 25;
    }

    private <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        if (!(this.f_20924_ > -0.05f) || !(this.f_20924_ < 0.05f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.m_6162_() ? "baby_cindershell_walk" : "cindershell_walk"));
        } else if (this.getEating()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("cindershell_idle_eat"));
        } else if (this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("cindershell_death"));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("cindershell_idle"));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState eatAnimationPredicate(AnimationEvent<E> event) {
        if (this.getEating()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("cindershell_eat"));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    private <E extends IAnimatable> void soundListener(SoundKeyframeEvent<E> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        player.m_5496_(this.m_6162_() ? (SoundEvent)CNBSoundEvents.CINDERSHELL_BABY_EAT.get() : (SoundEvent)CNBSoundEvents.CINDERSHELL_ADULT_EAT.get(), 0.4f, 1.0f);
    }

    public void registerControllers(AnimationData animationData) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate);
        AnimationController eatController = new AnimationController((IAnimatable)this, "eatController", 0.0f, this::eatAnimationPredicate);
        eatController.registerSoundListener(this::soundListener);
        animationData.addAnimationController(controller);
        animationData.addAnimationController(eatController);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class CindershellFloatGoal
    extends FloatGoal {
        private final CindershellEntity cindershell;

        public CindershellFloatGoal(CindershellEntity cindershell) {
            super((Mob)cindershell);
            this.cindershell = cindershell;
        }

        public boolean m_8036_() {
            return this.cindershell.m_20077_();
        }
    }

    static class CindershellBreedGoal
    extends BreedGoal {
        public CindershellBreedGoal(Animal cindershell, double speedModifier) {
            super(cindershell, speedModifier);
        }

        protected void m_8026_() {
            int range = this.f_25113_.m_217043_().m_188503_(4) + 3;
            for (int i = 0; i <= range; ++i) {
                super.m_8026_();
            }
        }
    }
}

