/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.entities;

import com.cgessinger.creaturesandbeasts.init.CNBSoundEvents;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EndWhaleEntity
extends TamableAnimal
implements FlyingAnimal,
Saddleable,
IAnimatable {
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.m_135353_(EndWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public EndWhaleEntity(EntityType<EndWhaleEntity> entityType, Level level) {
        super(entityType, level);
        this.m_7105_(false);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 2, true);
        this.f_21365_ = new EndWhaleLookControl(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 160.0).m_22268_(Attributes.f_22279_, 1.0).m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22280_, 1.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new EndWhaleTemptGoal(this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42730_})));
        this.f_21345_.m_25352_(1, (Goal)new EndWhaleWanderGoal(this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SADDLED, (Object)false);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Saddled", this.m_6254_());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        boolean isSaddled = tag.m_128471_("Saddled");
        if (isSaddled) {
            this.m_5853_(SoundSource.PLAYERS);
        }
    }

    protected BodyRotationControl m_7560_() {
        return new EndWhaleBodyRotationControl(this);
    }

    public int m_8085_() {
        return 0;
    }

    public int m_21529_() {
        return 30;
    }

    public boolean m_6741_() {
        return this.m_21824_();
    }

    public void m_5853_(@Nullable SoundSource soundSource) {
        this.f_19804_.m_135381_(SADDLED, (Object)true);
        this.m_5496_(SoundEvents.f_12034_, 1.0f, 1.0f);
    }

    public void removeSaddle() {
        this.f_19804_.m_135381_(SADDLED, (Object)false);
        this.m_19998_((ItemLike)Items.f_42450_);
        this.m_5496_(SoundEvents.f_12034_, 0.8f, 1.0f);
    }

    public boolean m_6254_() {
        return (Boolean)this.f_19804_.m_135370_(SADDLED);
    }

    private void mountWhale(Player player) {
        if (!this.f_19853_.f_46443_) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
        }
    }

    public void m_7332_(Entity rider) {
        if (this.m_20363_(rider)) {
            double verticalOffset = this.m_6048_() + rider.m_6049_();
            float whaleRoll = this.getWhaleRoll(rider) * (float)Math.PI / 180.0f;
            float whalePitch = this.getWhalePitch(rider) * (float)Math.PI / 180.0f;
            rider.m_6034_(this.m_20185_() + (double)Mth.m_14089_((float)(this.m_146908_() * (float)Math.PI / 180.0f)) * verticalOffset * (double)Mth.m_14031_((float)whaleRoll) + (double)Mth.m_14031_((float)(this.m_146908_() * (float)Math.PI / 180.0f)) * verticalOffset * (double)Mth.m_14031_((float)whalePitch), this.m_20186_() + verticalOffset * (double)Mth.m_14089_((float)whaleRoll) * (double)Mth.m_14089_((float)whalePitch), this.m_20189_() + (double)Mth.m_14031_((float)(this.m_146908_() * (float)Math.PI / 180.0f)) * verticalOffset * (double)Mth.m_14031_((float)whaleRoll) - (double)Mth.m_14089_((float)(this.m_146908_() * (float)Math.PI / 180.0f)) * verticalOffset * (double)Mth.m_14031_((float)whalePitch));
            this.clampRotation(rider);
        }
    }

    protected void clampRotation(Entity rider) {
        rider.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(rider.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-90.0f, (float)90.0f);
        rider.f_19859_ += f1 - f;
        rider.m_146922_(rider.m_146908_() + f1 - f);
        rider.m_5616_(rider.m_146908_());
    }

    public double m_6048_() {
        return (double)this.m_6972_((Pose)this.m_20089_()).f_20378_ * 0.7;
    }

    private float getWhaleRoll(Entity rider) {
        float whaleRotY = this.m_146908_();
        float riderRotY = rider.m_146908_();
        return Mth.m_14177_((float)(whaleRotY - riderRotY)) / 2.0f;
    }

    private float getWhalePitch(Entity rider) {
        float whaleRotY = this.m_146909_();
        float riderRotY = rider.m_146909_();
        return Mth.m_14177_((float)(whaleRotY - riderRotY));
    }

    public boolean m_6109_() {
        return this.m_6688_() instanceof LivingEntity;
    }

    @Nullable
    public Entity m_6688_() {
        return this.m_146895_();
    }

    public boolean m_6146_() {
        return true;
    }

    public boolean m_6040_() {
        return true;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6084_()) {
            if (this.m_20160_() && this.m_6109_() && this.m_6254_()) {
                LivingEntity livingentity = (LivingEntity)this.m_6688_();
                this.m_146922_(Mth.m_14189_((float)0.05f, (float)this.m_146908_(), (float)livingentity.m_146908_()));
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float forwardMovement = livingentity.f_20902_;
                if (forwardMovement <= 0.0f) {
                    forwardMovement *= 0.25f;
                }
                float verticalMovement = 0.0f;
                if (Mth.m_14154_((float)livingentity.m_146909_()) > 7.0f) {
                    verticalMovement = Mth.m_14189_((float)0.01f, (float)this.m_146909_(), (float)livingentity.m_146909_()) * -forwardMovement / 50.0f;
                }
                this.f_20887_ = this.m_6113_() * 0.1f;
                if (this.m_6109_()) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22280_));
                    Vec3 proposedMovement = new Vec3(0.0, (double)verticalMovement, (double)forwardMovement);
                    if (this.m_20077_()) {
                        this.m_19920_(0.02f, proposedMovement);
                        this.m_6478_(MoverType.SELF, this.m_20184_());
                        this.m_20256_(this.m_20184_().m_82490_(0.5));
                    } else {
                        BlockPos ground = new BlockPos(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_());
                        float f = 0.91f;
                        if (this.f_19861_) {
                            f = this.f_19853_.m_8055_(ground).getFriction((LevelReader)this.f_19853_, ground, (Entity)this) * 0.91f;
                        }
                        float f1 = 0.16277137f / (f * f * f);
                        this.m_19920_(this.f_19861_ ? 0.1f * f1 : 0.1f, proposedMovement);
                        this.m_6478_(MoverType.SELF, this.m_20184_());
                        this.m_20256_(this.m_20184_().m_82490_((double)f));
                    }
                } else if (livingentity instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                this.m_21043_((LivingEntity)this, false);
                this.m_146872_();
            } else {
                this.f_20887_ = 0.02f;
                if (this.m_20077_()) {
                    this.m_19920_(0.02f, travelVector);
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    this.m_20256_(this.m_20184_().m_82490_(0.5));
                } else {
                    BlockPos ground = new BlockPos(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_());
                    float f = 0.91f;
                    if (this.f_19861_) {
                        f = this.f_19853_.m_8055_(ground).getFriction((LevelReader)this.f_19853_, ground, (Entity)this) * 0.91f;
                    }
                    float f1 = 0.16277137f / (f * f * f);
                    this.m_19920_(this.f_19861_ ? 0.1f * f1 : 0.02f, travelVector);
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    this.m_20256_(this.m_20184_().m_82490_((double)f));
                }
                this.m_21043_((LivingEntity)this, false);
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || itemstack.m_150930_(Items.f_42730_) && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_6254_() && player.m_36341_()) {
            this.removeSaddle();
            return InteractionResult.CONSUME;
        }
        if (this.m_6254_()) {
            this.mountWhale(player);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (!this.m_21824_() && itemstack.m_150930_(Items.f_42730_)) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(10) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_7340_(Entity entity) {
        this.clampRotation(entity);
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob endWhale) {
        return null;
    }

    public int m_213860_() {
        return 12 + this.f_19853_.f_46441_.m_188503_(5);
    }

    public static boolean checkEndWhaleSpawnRules(EntityType<EndWhaleEntity> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return true;
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return 10.0f;
    }

    public boolean m_29443_() {
        return true;
    }

    public boolean m_142535_(float p_148750_, float p_148751_, DamageSource p_148752_) {
        return false;
    }

    protected void m_7840_(double p_27754_, boolean p_27755_, BlockState p_27756_, BlockPos p_27757_) {
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.m_26443_(false);
        return flyingpathnavigation;
    }

    @Nullable
    public SoundEvent m_7515_() {
        return (SoundEvent)CNBSoundEvents.END_WHALE_AMBIENT.get();
    }

    public int m_8100_() {
        return 800;
    }

    protected float m_6121_() {
        return 5.0f;
    }

    private <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("whale_fly"));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class EndWhaleLookControl
    extends LookControl {
        private final EndWhaleEntity endWhale;

        public EndWhaleLookControl(EndWhaleEntity endWhale) {
            super((Mob)endWhale);
            this.endWhale = endWhale;
        }

        public void m_8128_() {
            if (this.endWhale.f_20883_ != this.endWhale.m_6080_()) {
                this.endWhale.f_20885_ = Mth.m_14189_((float)0.05f, (float)this.endWhale.m_6080_(), (float)this.endWhale.f_20883_);
            }
        }
    }

    static class EndWhaleTemptGoal
    extends Goal {
        private static final TargetingConditions TEMP_TARGETING = TargetingConditions.m_148353_().m_26883_(100.0).m_148355_();
        private final TargetingConditions targetingConditions;
        protected final EndWhaleEntity endWhale;
        private final double speedModifier;
        @Nullable
        protected Player player;
        private int calmDown;
        private final Ingredient items;

        public EndWhaleTemptGoal(EndWhaleEntity endWhale, double speedModifier, Ingredient temptIngredient) {
            this.endWhale = endWhale;
            this.speedModifier = speedModifier;
            this.items = temptIngredient;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.targetingConditions = TEMP_TARGETING.m_148354_().m_26888_(this::shouldFollow);
        }

        public boolean m_8036_() {
            if (this.calmDown > 0) {
                --this.calmDown;
                return false;
            }
            this.player = this.endWhale.f_19853_.m_45946_(this.targetingConditions, (LivingEntity)this.endWhale);
            return this.player != null && !this.endWhale.m_20160_();
        }

        private boolean shouldFollow(LivingEntity entity) {
            return this.items.test(entity.m_21205_()) || this.items.test(entity.m_21206_());
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8041_() {
            this.player = null;
            this.endWhale.m_21573_().m_26573_();
            this.calmDown = EndWhaleTemptGoal.m_186073_((int)100);
        }

        public void m_8037_() {
            this.endWhale.m_21563_().m_24960_((Entity)this.player, (float)(this.endWhale.m_8085_() + 20), (float)this.endWhale.m_8132_());
            if (this.endWhale.m_20280_((Entity)this.player) < 6.25) {
                this.endWhale.m_21573_().m_26573_();
            } else {
                this.endWhale.m_21573_().m_5624_((Entity)this.player, this.speedModifier);
            }
        }
    }

    static class EndWhaleWanderGoal
    extends Goal {
        private final EndWhaleEntity endWhale;

        EndWhaleWanderGoal(EndWhaleEntity endWhale) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.endWhale = endWhale;
        }

        public boolean m_8036_() {
            return this.endWhale.f_21344_.m_26571_() && this.endWhale.f_19796_.m_188503_(3) == 0 && !this.endWhale.m_20160_();
        }

        public boolean m_8045_() {
            return this.endWhale.f_21344_.m_26572_() && !this.endWhale.m_20160_();
        }

        public void m_8056_() {
            Vec3 vec3 = this.findPos();
            if (vec3 != null) {
                this.endWhale.f_21344_.m_26536_(this.endWhale.f_21344_.m_7864_(new BlockPos(vec3), 3), 1.0);
            }
        }

        public void m_8041_() {
            this.endWhale.f_21344_.m_26573_();
        }

        @Nullable
        private Vec3 findPos() {
            Vec3 vec3 = this.endWhale.m_20252_(0.5f);
            Vec3 vec32 = HoverRandomPos.m_148465_((PathfinderMob)this.endWhale, (int)20, (int)20, (double)vec3.f_82479_, (double)vec3.f_82481_, (float)((float)Math.PI), (int)50, (int)15);
            Vec3 vec33 = vec32 = vec32 != null ? vec32 : AirAndWaterRandomPos.m_148357_((PathfinderMob)this.endWhale, (int)20, (int)20, (int)-2, (double)vec3.f_82479_, (double)vec3.f_82481_, (double)3.1415927410125732);
            if (this.endWhale.m_6254_() && vec32 != null && this.endWhale.m_21826_() != null && vec32.m_82554_(this.endWhale.m_21826_().m_20182_()) > 100.0) {
                vec32 = null;
            }
            return vec32;
        }
    }

    static class EndWhaleBodyRotationControl
    extends BodyRotationControl {
        private final EndWhaleEntity endWhale;
        private int headStableTime;
        private float lastStableYHeadRot;

        public EndWhaleBodyRotationControl(EndWhaleEntity endWhale) {
            super((Mob)endWhale);
            this.endWhale = endWhale;
        }

        public void m_8121_() {
            if (this.isMoving()) {
                this.endWhale.f_20883_ = Mth.m_14189_((float)0.05f, (float)this.endWhale.f_20883_, (float)this.endWhale.m_146908_());
                this.rotateHeadIfNecessary();
                this.lastStableYHeadRot = this.endWhale.f_20885_;
                this.headStableTime = 0;
            } else if (this.notCarryingMobPassengers()) {
                if (Math.abs(this.endWhale.f_20885_ - this.lastStableYHeadRot) > 15.0f) {
                    this.headStableTime = 0;
                    this.lastStableYHeadRot = this.endWhale.f_20885_;
                    this.rotateHeadIfNecessary();
                } else {
                    ++this.headStableTime;
                    if (this.headStableTime > 10) {
                        this.rotateHeadTowardsFront();
                    }
                }
            }
        }

        private void rotateHeadIfNecessary() {
            this.endWhale.f_20885_ = Mth.m_14189_((float)0.05f, (float)this.endWhale.f_20885_, (float)this.endWhale.f_20883_);
        }

        private void rotateHeadTowardsFront() {
            this.endWhale.f_20885_ = Mth.m_14189_((float)0.05f, (float)this.endWhale.f_20885_, (float)this.endWhale.f_20883_);
        }

        private boolean notCarryingMobPassengers() {
            return !(this.endWhale.m_146895_() instanceof Mob);
        }

        private boolean isMoving() {
            double d1;
            double d0 = this.endWhale.m_20185_() - this.endWhale.f_19854_;
            return d0 * d0 + (d1 = this.endWhale.m_20189_() - this.endWhale.f_19856_) * d1 > 2.500000277905201E-7;
        }
    }
}

