/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.entities;

import com.cgessinger.creaturesandbeasts.entities.ai.FindWaterOneDeepGoal;
import com.cgessinger.creaturesandbeasts.init.CNBLilytadTypes;
import com.cgessinger.creaturesandbeasts.init.CNBSoundEvents;
import com.cgessinger.creaturesandbeasts.util.LilytadType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IForgeShearable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class LilytadEntity
extends Animal
implements IForgeShearable,
IAnimatable {
    public static final EntityDataAccessor<String> TYPE = SynchedEntityData.m_135353_(LilytadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(LilytadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private int shearedTimer = 0;

    public LilytadEntity(EntityType<LilytadEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21365_ = new LookControl((Mob)this){

            public void m_8128_() {
                LilytadEntity lilytad = (LilytadEntity)this.f_24937_;
                if (lilytad.shouldLookAround()) {
                    super.m_8128_();
                }
            }
        };
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)CNBLilytadTypes.PINK.getId().toString());
        this.f_19804_.m_135372_(SHEARED, (Object)false);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        LilytadType type = LilytadType.getById(compound.m_128461_("LilytadType"));
        if (type == null) {
            type = CNBLilytadTypes.PINK;
        }
        this.setLilytadType(type);
        this.shearedTimer = compound.m_128451_("ShearedTimer");
        this.setSheared(this.shearedTimer > 0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("ShearedTimer", this.shearedTimer);
        compound.m_128359_("LilytadType", this.getLilytadType().getId().toString());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FindWaterOneDeepGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(2, (Goal)new LilytadPanicGoal(this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean m_8036_() {
                return !this.f_25725_.f_19853_.m_6425_(this.f_25725_.m_20183_()).m_205070_(FluidTags.f_13131_) && super.m_8036_();
            }

            public boolean m_8045_() {
                return !this.f_25725_.f_19853_.m_6425_(this.f_25725_.m_20183_()).m_205070_(FluidTags.f_13131_) && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.m_5776_() && --this.shearedTimer == 0) {
            this.setSheared(false);
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        switch (this.f_19796_.m_188503_(3)) {
            default: {
                this.setLilytadType(CNBLilytadTypes.PINK);
                break;
            }
            case 1: {
                this.setLilytadType(CNBLilytadTypes.LIGHT_PINK);
                break;
            }
            case 2: {
                this.setLilytadType(CNBLilytadTypes.YELLOW);
            }
        }
        return super.m_6518_(level, difficulty, spawnType, spawnGroupData, tag);
    }

    public static boolean checkLilytadSpawnRules(EntityType<LilytadEntity> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return true;
    }

    protected void m_6138_() {
        List list = this.f_19853_.m_6249_((Entity)this, this.m_20191_().m_82377_(0.2, 0.0, 0.2), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            int i = this.f_19853_.m_46469_().m_46215_(GameRules.f_46149_);
            if (i > 0 && list.size() > i - 1 && this.f_19796_.m_188503_(4) == 0) {
                int j = 0;
                for (Entity entity : list) {
                    if (entity.m_20159_()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.m_6469_(DamageSource.f_19311_, 6.0f);
                }
            }
            for (Entity entity : list) {
                this.m_7324_(entity);
            }
        }
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob entity) {
        return null;
    }

    public boolean getSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.shearedTimer = sheared ? 18000 : 0;
        this.f_19804_.m_135381_(SHEARED, (Object)sheared);
    }

    public void setLilytadType(LilytadType lilytadType) {
        this.f_19804_.m_135381_(TYPE, (Object)lilytadType.getId().toString());
    }

    public LilytadType getLilytadType() {
        return LilytadType.getById((String)this.f_19804_.m_135370_(TYPE));
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos pos) {
        return !this.getSheared();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos pos, int fortune) {
        world.m_6269_(null, (Entity)this, SoundEvents.f_12344_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        this.m_146852_(GameEvent.f_157781_, (Entity)player);
        if (!world.f_46443_) {
            this.setSheared(true);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.add(new ItemStack((ItemLike)this.getLilytadType().getShearItem()));
            return items;
        }
        return Collections.emptyList();
    }

    public boolean shouldLookAround() {
        return !this.f_19853_.m_6425_(this.m_20183_()).m_205070_(FluidTags.f_13131_);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)CNBSoundEvents.LILYTAD_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)CNBSoundEvents.LILYTAD_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)CNBSoundEvents.LILYTAD_DEATH.get();
    }

    private <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        if (!(this.f_20924_ > -0.05f) || !(this.f_20924_ < 0.05f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("lilytad.walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class LilytadPanicGoal
    extends PanicGoal {
        private final LilytadEntity lilytad;

        public LilytadPanicGoal(LilytadEntity lilytad, double speedModifier) {
            super((PathfinderMob)lilytad, speedModifier);
            this.lilytad = lilytad;
        }

        public void m_8056_() {
            this.lilytad.m_21573_().m_26519_(this.f_25686_, this.f_25687_, this.f_25688_, this.f_25685_);
            this.f_25689_ = true;
        }

        protected boolean m_25702_() {
            boolean flag = GoalUtils.m_148442_((PathfinderMob)this.lilytad, (int)5);
            Vec3 vec3 = RandomPos.m_148542_((PathfinderMob)this.lilytad, () -> {
                BlockPos blockpos = RandomPos.m_217851_((RandomSource)this.lilytad.m_217043_(), (int)5, (int)4);
                return LilytadPanicGoal.generateRandomPosTowardDirection(this.lilytad, 5, flag, blockpos);
            });
            if (vec3 == null) {
                return false;
            }
            this.f_25686_ = vec3.f_82479_;
            this.f_25687_ = vec3.f_82480_;
            this.f_25688_ = vec3.f_82481_;
            return true;
        }

        @Nullable
        private static BlockPos generateRandomPosTowardDirection(LilytadEntity lilytad, int horizontalRange, boolean flag, BlockPos posTowards) {
            BlockPos blockpos = RandomPos.m_217863_((PathfinderMob)lilytad, (int)horizontalRange, (RandomSource)lilytad.m_217043_(), (BlockPos)posTowards);
            return !GoalUtils.m_148451_((BlockPos)blockpos, (PathfinderMob)lilytad) && !GoalUtils.m_148454_((boolean)flag, (PathfinderMob)lilytad, (BlockPos)blockpos) && !GoalUtils.m_148458_((PathfinderMob)lilytad, (BlockPos)blockpos) && (!GoalUtils.m_148448_((PathNavigation)lilytad.m_21573_(), (BlockPos)blockpos) || GoalUtils.m_148445_((PathfinderMob)lilytad, (BlockPos)blockpos) && lilytad.f_19853_.m_8055_(blockpos.m_7495_()).m_60815_() && lilytad.f_19853_.m_8055_(blockpos.m_7494_()).m_60795_()) ? blockpos : null;
        }
    }
}

