/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.entities;

import com.cgessinger.creaturesandbeasts.entities.ai.GoToWaterGoal;
import com.cgessinger.creaturesandbeasts.entities.ai.MountAdultGoal;
import com.cgessinger.creaturesandbeasts.entities.ai.SmoothSwimGoal;
import com.cgessinger.creaturesandbeasts.init.CNBEntityTypes;
import com.cgessinger.creaturesandbeasts.init.CNBSoundEvents;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class LittleGrebeEntity
extends Animal
implements IAnimatable {
    public static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_, Items.f_42527_, Items.f_42528_});
    private static final EntityDataAccessor<BlockPos> TRAVEL_POS = SynchedEntityData.m_135353_(LittleGrebeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private final UUID healthReductionUUID = UUID.fromString("189faad9-35de-4e15-a598-82d147b996d7");
    public float flapSpeed;
    private float nextFlap = 1.0f;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public LittleGrebeEntity(EntityType<LittleGrebeEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, 10.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MountAdultGoal(this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new SmoothSwimGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new SwimTravelGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new WanderGoal(this, 1.0, 120));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new GoToWaterGoal(this, 0.8));
    }

    public static boolean checkGrebeSpawnRules(EntityType<LittleGrebeEntity> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return worldIn.m_45524_(pos, 0) > 8;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableMob.AgeableMobGroupData(0.6f);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        double MAX_HEALTH = this.m_21051_(Attributes.f_22276_).m_22135_();
        float babyHealth = 5.0f;
        if (this.m_6162_() && MAX_HEALTH > (double)babyHealth) {
            HashMultimap multimap = HashMultimap.create();
            multimap.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(this.healthReductionUUID, "yeti_health_reduction", (double)babyHealth - MAX_HEALTH, AttributeModifier.Operation.ADDITION));
            this.m_21204_().m_22178_((Multimap)multimap);
            this.m_21153_(babyHealth);
        }
    }

    protected void m_30232_() {
        this.m_8127_();
        this.m_21051_(Attributes.f_22276_).m_22120_(this.healthReductionUUID);
        this.m_21153_((float)this.m_21051_(Attributes.f_22276_).m_22135_());
    }

    public void m_8107_() {
        super.m_8107_();
        this.flapSpeed += (this.f_19861_ ? -1.0f : 4.0f) * 0.3f;
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        Vec3 vec3 = this.m_20184_();
        if (!this.f_19861_ && !this.m_6162_() && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return (AgeableMob)((EntityType)CNBEntityTypes.LITTLE_GREBE.get()).m_20615_((Level)p_241840_1_);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return this.m_6162_() && super.m_142535_(distance, damageMultiplier, source);
    }

    protected float m_6121_() {
        return 0.6f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_6162_()) {
            return (SoundEvent)CNBSoundEvents.LITTLE_GREBE_CHICK_AMBIENT.get();
        }
        return (SoundEvent)CNBSoundEvents.LITTLE_GREBE_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)CNBSoundEvents.LITTLE_GREBE_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)CNBSoundEvents.LITTLE_GREBE_HURT.get();
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.3;
    }

    public boolean m_6063_() {
        return false;
    }

    private BlockPos getTravelPos() {
        return (BlockPos)this.f_19804_.m_135370_(TRAVEL_POS);
    }

    public int m_8085_() {
        return 60;
    }

    public int m_8132_() {
        return 35;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TRAVEL_POS, (Object)new BlockPos(0, 2, 0));
    }

    public boolean m_6898_(ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(0.1f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.5));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    private <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        if (!(this.m_20096_() || this.m_20069_() || this.m_6162_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("little_grebe.fall", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.m_20069_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("little_grebe.swim", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (!(this.f_20924_ > -0.15f) || !(this.f_20924_ < 0.15f)) {
            if (this.m_6162_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("little_grebe_chick.walk", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("little_grebe.walk", Boolean.valueOf(true)));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class SwimTravelGoal
    extends Goal {
        private final LittleGrebeEntity grebeEntity;
        private final double speed;
        private boolean stuck;

        SwimTravelGoal(LittleGrebeEntity grebeEntity, double speedIn) {
            this.grebeEntity = grebeEntity;
            this.speed = speedIn;
        }

        public boolean m_8036_() {
            return this.grebeEntity.m_20069_();
        }

        public void m_8056_() {
            this.stuck = false;
        }

        public void m_8037_() {
            if (this.grebeEntity.m_21573_().m_26571_()) {
                int j;
                int i;
                Vec3 vector3d = Vec3.m_82539_((Vec3i)this.grebeEntity.getTravelPos());
                Vec3 vector3d1 = DefaultRandomPos.m_148412_((PathfinderMob)this.grebeEntity, (int)16, (int)3, (Vec3)vector3d, (double)0.3141592741012573);
                if (vector3d1 == null) {
                    vector3d1 = DefaultRandomPos.m_148412_((PathfinderMob)this.grebeEntity, (int)8, (int)7, (Vec3)vector3d, (double)1.5707963705062866);
                }
                if (vector3d1 != null && !this.grebeEntity.f_19853_.m_46812_((i = Mth.m_14107_((double)vector3d1.f_82479_)) - 34, 0, (j = Mth.m_14107_((double)vector3d1.f_82481_)) - 34, i + 34, 0, j + 34)) {
                    vector3d1 = null;
                }
                if (vector3d1 == null) {
                    this.stuck = true;
                    return;
                }
                this.grebeEntity.m_21573_().m_26519_(vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_, this.speed);
            }
        }

        public boolean m_8045_() {
            return !this.grebeEntity.m_21573_().m_26571_() && !this.stuck && !this.grebeEntity.m_27593_();
        }
    }

    static class WanderGoal
    extends RandomStrollGoal {
        private WanderGoal(LittleGrebeEntity entity, double speedIn, int chance) {
            super((PathfinderMob)entity, speedIn, chance);
        }

        public boolean m_8036_() {
            return !this.f_25725_.m_20069_() && super.m_8036_();
        }
    }
}

