/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.config.library.element;

import com.cgessinger.creaturesandbeasts.config.library.element.PrimitiveConfigElement;
import com.cgessinger.creaturesandbeasts.config.library.element.handler.IConfigElementHandler;
import com.cgessinger.creaturesandbeasts.config.library.util.annotation.Nullable;
import com.electronwill.nightconfig.core.conversion.InvalidValueException;
import java.lang.reflect.Field;

public class NumberConfigElement<T extends Number>
extends PrimitiveConfigElement<T> {
    private final T min;
    private final T max;

    public NumberConfigElement(Field field, T min, T max, IConfigElementHandler<T, ?> handler) {
        super(field, handler);
        this.min = min;
        this.max = max;
        if (!this.isValid((Number)this.getDefault())) {
            throw new IllegalStateException(String.format("Default value \"%s\" is not in range [%s, %s]\n\tat: %s", this.getDefault(), this.min, this.max, this.getField().toGenericString()));
        }
    }

    @Override
    public String getComment() {
        StringBuilder s = new StringBuilder();
        String comment = super.getComment();
        if (comment != null) {
            s.append(comment);
        }
        String minString = "-inf";
        String maxString = "inf";
        if (this.min != null && ((Number)this.min).doubleValue() != Double.MIN_VALUE && ((Number)this.min).intValue() != Integer.MIN_VALUE && ((Number)this.min).floatValue() != Float.MIN_VALUE) {
            minString = String.valueOf(this.min);
        }
        if (this.max != null && ((Number)this.max).doubleValue() != Double.MAX_VALUE && ((Number)this.max).intValue() != Integer.MAX_VALUE && ((Number)this.max).floatValue() != Float.MAX_VALUE) {
            maxString = String.valueOf(this.max);
        }
        if (s.length() > 0) {
            s.append("\n");
        }
        s.append(String.format(" Range: [%s, %s]", minString, maxString));
        return s.toString();
    }

    @Override
    public void set(@Nullable T value) {
        if (value != null) {
            if (this.isValid((Number)value)) {
                super.set(value);
            } else {
                throw new InvalidValueException(String.format("Value \"%s\" is not valid for field \"%s.%s\"", value, this.getField().getDeclaringClass().getName(), this.getField().getName()));
            }
        }
    }

    public boolean isValid(Object value) {
        Number number;
        if (value == null) {
            return true;
        }
        Object object = value;
        return object instanceof Number && this.isValid(number = (Number)object);
    }

    public boolean isValid(Number value) {
        return value.doubleValue() >= ((Number)this.min).doubleValue() && value.doubleValue() <= ((Number)this.max).doubleValue();
    }
}

