/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.init;

import com.cgessinger.creaturesandbeasts.util.LizardType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class CNBLizardTypes {
    private static final List<LizardType> LIZARD_TYPES = new ArrayList<LizardType>(5);
    public static final LizardType DESERT = CNBLizardTypes.registerWithCNBDirectory("lizard_item_desert", "cnb", "desert");
    public static final LizardType DESERT_2 = CNBLizardTypes.registerWithCNBDirectory("lizard_item_desert_2", "cnb", "desert_2");
    public static final LizardType JUNGLE = CNBLizardTypes.registerWithCNBDirectory("lizard_item_jungle", "cnb", "jungle");
    public static final LizardType JUNGLE_2 = CNBLizardTypes.registerWithCNBDirectory("lizard_item_jungle_2", "cnb", "jungle_2");
    public static final LizardType MUSHROOM = CNBLizardTypes.registerWithCNBDirectory("lizard_item_mushroom", "cnb", "mushroom");

    private static LizardType registerWithCNBDirectory(String itemName, String namespace, String name) {
        return CNBLizardTypes.registerWithCNBDirectory(() -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(namespace, itemName)), namespace, name);
    }

    private static LizardType registerWithCNBDirectory(@Nullable Item spawnItem, String namespace, String name) {
        return CNBLizardTypes.registerWithCNBDirectory(() -> spawnItem, namespace, name);
    }

    private static LizardType registerWithCNBDirectory(@Nullable Supplier<Item> spawnItem, String namespace, String name) {
        return CNBLizardTypes.register(new LizardType(spawnItem, new ResourceLocation(namespace, name), new ResourceLocation("cnb", "textures/entity/lizard/lizard_" + name + ".png"), new ResourceLocation("cnb", "textures/entity/lizard/sad_lizard_" + name + ".png")));
    }

    private static LizardType register(LizardType lizardType) {
        LIZARD_TYPES.add(lizardType);
        return lizardType;
    }

    public static void registerAll() {
        for (LizardType lizardType : LIZARD_TYPES) {
            LizardType.registerLizardType(lizardType);
        }
    }
}

