/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.config;

import com.mojang.brigadier.StringReader;
import eu.pb4.graves.config.data.ConfigData;
import eu.pb4.graves.grave.GraveBlock;
import eu.pb4.graves.grave.GravesLookType;
import eu.pb4.graves.grave.GravesXPCalculation;
import eu.pb4.placeholders.TextParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2259;
import net.minecraft.class_2291;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class Config {
    public final ConfigData configData;
    public final GravesLookType style;
    public final class_2561[] hologramProtectedText;
    public final class_2561[] hologramText;
    public final class_2561[] signProtectedText;
    public final class_2561[] signText;
    public final class_2561 graveTitle;
    public final class_2561 guiTitle;
    public final class_2561[] guiProtectedText;
    public final class_2561[] guiText;
    public final class_1799[] guiProtectedItem;
    public final class_1799[] guiItem;
    @Nullable
    public final class_2561 noLongerProtectedMessage;
    @Nullable
    public final class_2561 graveExpiredMessage;
    @Nullable
    public final class_2561 graveBrokenMessage;
    @Nullable
    public final class_2561 createdGraveMessage;
    @Nullable
    public final class_2561 creationFailedGraveMessage;
    @Nullable
    public final class_2561 creationFailedVoidMessage;
    @Nullable
    public final class_2561 creationFailedPvPMessage;
    @Nullable
    public final class_2561 creationFailedClaimMessage;
    public final GravesXPCalculation xpCalc;
    public final BlockStyleEntry[] customBlockStateStylesLocked;
    public final BlockStyleEntry[] customBlockStateStylesUnlocked;
    public final Set<class_2960> skippedEnchantments;
    public final Map<class_2960, class_2561> worldNameOverrides;
    public final Set<class_2960> blacklistedWorlds;

    public Config(ConfigData data) {
        this.configData = data;
        this.style = GravesLookType.byName(this.configData.graveStyle);
        this.xpCalc = GravesXPCalculation.byName(this.configData.xpStorageType);
        this.hologramProtectedText = Config.parse(data.hologramProtectedText);
        this.hologramText = Config.parse(data.hologramText);
        this.signProtectedText = Config.parse(data.customStyleSignProtectedText);
        this.signText = Config.parse(data.customStyleSignText);
        this.graveTitle = TextParser.parse((String)data.graveTitle);
        this.guiTitle = TextParser.parse((String)data.guiTitle);
        this.guiProtectedText = Config.parse(data.guiProtectedText);
        this.guiText = Config.parse(data.guiText);
        this.noLongerProtectedMessage = Config.parse(data.messageProtectionEnded);
        this.graveExpiredMessage = Config.parse(data.messageGraveExpired);
        this.graveBrokenMessage = Config.parse(data.messageGraveBroken);
        this.createdGraveMessage = Config.parse(data.messageGraveCreated);
        this.creationFailedGraveMessage = Config.parse(data.messageCreationFailed);
        this.creationFailedVoidMessage = Config.parse(data.messageCreationFailedVoid);
        this.creationFailedPvPMessage = Config.parse(data.messageCreationFailedPvP);
        this.creationFailedClaimMessage = Config.parse(data.messageCreationFailedClaim);
        this.customBlockStateStylesLocked = Config.parseBlockStyles(this.configData.customBlockStateLockedStyles);
        this.customBlockStateStylesUnlocked = Config.parseBlockStyles(this.configData.customBlockStateUnlockedStyles);
        this.guiProtectedItem = Config.parseItems(this.configData.guiProtectedItem);
        this.guiItem = Config.parseItems(this.configData.guiItem);
        this.skippedEnchantments = Config.parseIds(data.skippedEnchantments);
        this.blacklistedWorlds = Config.parseIds(data.blacklistedWorlds);
        this.worldNameOverrides = new HashMap<class_2960, class_2561>();
        for (Map.Entry<String, String> entry : data.worldNameOverrides.entrySet()) {
            class_2960 id = class_2960.method_12829((String)entry.getKey());
            if (id == null) continue;
            this.worldNameOverrides.put(id, Config.parse(entry.getValue()));
        }
    }

    private static Set<class_2960> parseIds(List<String> ids) {
        HashSet<class_2960> set = new HashSet<class_2960>();
        for (String id : ids) {
            class_2960 identifier;
            if (id == null || (identifier = class_2960.method_12829((String)id)) == null) continue;
            set.add(identifier);
        }
        return set;
    }

    @Nullable
    private static class_2561 parse(String string) {
        return !string.isEmpty() ? TextParser.parse((String)string) : null;
    }

    private static class_1799[] parseItems(List<String> stringList) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (String itemDef : stringList) {
            try {
                class_2291 item = new class_2291(new StringReader(itemDef), true).method_9789();
                class_1799 itemStack = item.method_9786().method_7854();
                if (item.method_9797() != null) {
                    itemStack.method_7980(item.method_9797());
                }
                items.add(itemStack);
            }
            catch (Exception exception) {}
        }
        if (items.isEmpty()) {
            items.add(class_1802.field_8106.method_7854());
        }
        return items.toArray(new class_1799[0]);
    }

    private static BlockStyleEntry[] parseBlockStyles(List<String> stringList) {
        ArrayList<BlockStyleEntry> blockStates = new ArrayList<BlockStyleEntry>();
        for (String stateName : stringList) {
            try {
                class_2259 stateData = new class_2259(new StringReader(stateName), true).method_9678(true);
                if (stateData.method_9669().method_26204() != GraveBlock.INSTANCE && stateData.method_9669() != null) {
                    if (stateData.method_9669().method_31709()) {
                        class_2586 blockEntity = ((class_2343)stateData.method_9669().method_26204()).method_10123(class_2338.field_10980, stateData.method_9669());
                        class_2591 i = null;
                        class_2596 packet = blockEntity.method_38235();
                        if (packet instanceof class_2622) {
                            class_2622 bePacket = (class_2622)packet;
                            i = bePacket.method_11291();
                        }
                        if (stateData.method_9694() != null) {
                            blockEntity.method_11014(stateData.method_9694());
                        }
                        blockStates.add(new BlockStyleEntry(stateData.method_9669(), i, blockEntity.method_16887()));
                        continue;
                    }
                    blockStates.add(new BlockStyleEntry(stateData.method_9669(), null, null));
                    continue;
                }
                blockStates.add(new BlockStyleEntry((class_2680)class_2246.field_10247.method_9564().method_11657((class_2769)class_2302.field_10835, (Comparable)Integer.valueOf(7)), null, null));
            }
            catch (Exception e) {
                e.printStackTrace();
                blockStates.add(new BlockStyleEntry(class_2246.field_10481.method_9564(), null, null));
            }
        }
        if (blockStates.size() == 0) {
            blockStates.add(new BlockStyleEntry(class_2246.field_10481.method_9564(), null, null));
        }
        return blockStates.toArray(new BlockStyleEntry[0]);
    }

    public String getFormattedTime(long time) {
        long seconds = time % 60L;
        long minutes = time / 60L % 60L;
        long hours = time / 3600L % 24L;
        long days = time / 86400L % 365L;
        long years = time / 31536000L;
        StringBuilder builder = new StringBuilder();
        if (years > 0L) {
            builder.append(years).append(this.configData.yearsText);
        }
        if (days > 0L) {
            builder.append(days).append(this.configData.daysText);
        }
        if (hours > 0L) {
            builder.append(hours).append(this.configData.hoursText);
        }
        if (minutes > 0L) {
            builder.append(minutes).append(this.configData.minutesText);
        }
        if (seconds > 0L || time <= 0L) {
            builder.append(seconds).append(this.configData.secondsText);
        }
        return builder.toString();
    }

    private static class_2561[] parse(List<String> strings) {
        ArrayList<class_2561> texts = new ArrayList<class_2561>();
        for (String line : strings) {
            if (line == null) continue;
            if (line.isEmpty()) {
                texts.add(class_2585.field_24366);
                continue;
            }
            texts.add(TextParser.parse((String)line));
        }
        return texts.toArray(new class_2561[0]);
    }

    public record BlockStyleEntry(class_2680 state, class_2591<?> blockEntityType, class_2487 blockEntityNbt) {
    }
}

