/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.pb4.graves.GravesMod;
import eu.pb4.graves.config.Config;
import eu.pb4.graves.config.data.ConfigData;
import eu.pb4.graves.config.data.VersionedConfigData;
import eu.pb4.graves.config.data.old.ConfigDataV1;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.IOUtils;

public class ConfigManager {
    public static final int VERSION = 2;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().create();
    private static Config CONFIG = new Config(new ConfigData());
    private static boolean ENABLED = false;

    public static Config getConfig() {
        if (CONFIG == null) {
            ConfigManager.loadConfig();
        }
        return CONFIG;
    }

    public static boolean isEnabled() {
        return ENABLED;
    }

    public static boolean loadConfig() {
        ENABLED = false;
        CONFIG = null;
        try {
            ConfigData config;
            File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "universal-graves.json");
            if (configFile.exists()) {
                String json = IOUtils.toString((Reader)new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8));
                config = switch (((VersionedConfigData)ConfigManager.GSON.fromJson((String)json, VersionedConfigData.class)).CONFIG_VERSION_DONT_TOUCH_THIS) {
                    case 1 -> ((ConfigDataV1)GSON.fromJson(json, ConfigDataV1.class)).update();
                    default -> (ConfigData)GSON.fromJson(json, ConfigData.class);
                };
                config.CONFIG_VERSION_DONT_TOUCH_THIS = 2;
            } else {
                config = new ConfigData();
            }
            ConfigManager.overrideConfig(config);
            ENABLED = true;
        }
        catch (IOException exception) {
            ENABLED = false;
            GravesMod.LOGGER.error("Something went wrong while reading config!");
            exception.printStackTrace();
        }
        return ENABLED;
    }

    public static void overrideConfig(ConfigData configData) {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "universal-graves.json");
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8));
            writer.write(GSON.toJson((Object)configData));
            writer.close();
            CONFIG = new Config(configData);
        }
        catch (Exception e) {
            GravesMod.LOGGER.error("Something went wrong while saving config!");
            e.printStackTrace();
        }
    }
}

