/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.config.data;

import eu.pb4.graves.config.data.VersionedConfigData;
import eu.pb4.graves.grave.GravesLookType;
import eu.pb4.graves.grave.GravesXPCalculation;
import eu.pb4.graves.other.GraveUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2246;
import net.minecraft.class_2544;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4778;

public class ConfigData
extends VersionedConfigData
implements Cloneable {
    public String _comment = "Before changing anything, see https://github.com/Patbox/UniversalGraves#configuration";
    public String graveStyle;
    public String presetHeadLockedTexture;
    public String presetHeadUnlockedTexture;
    public List<String> customBlockStateLockedStyles;
    public List<String> customBlockStateUnlockedStyles;
    public List<String> customStyleSignText;
    public List<String> customStyleSignProtectedText;
    public int customStyleUpdateRate;
    public boolean isProtected;
    public int protectionTime;
    public int breakingTime;
    public boolean breakEmptyGraves;
    public String xpStorageType;
    public double xpPercentTypeValue;
    public boolean replaceAnyBlock;
    public int maxPlacementDistance;
    public boolean createFromPvP;
    public boolean createFromVoid;
    public boolean createFromCommandDeaths;
    public boolean createInClaims;
    public boolean dropItemsAfterExpiring;
    public boolean shiftClickTakesItems;
    public boolean allowAttackersToTakeItems;
    public String graveTitle;
    public boolean hologram;
    public double hologramOffset;
    public List<String> hologramProtectedText;
    public List<String> hologramText;
    public String guiTitle;
    public List<String> guiProtectedText;
    public List<String> guiText;
    public List<String> guiProtectedItem;
    public List<String> guiItem;
    public String messageGraveCreated;
    public String messageProtectionEnded;
    public String messageGraveExpired;
    public String messageGraveBroken;
    public String messageCreationFailed;
    public String messageCreationFailedVoid;
    public String messageCreationFailedPvP;
    public String messageCreationFailedClaim;
    public String yearsText;
    public String daysText;
    public String hoursText;
    public String minutesText;
    public String secondsText;
    public String infinityText;
    public Map<String, String> worldNameOverrides;
    public List<String> blacklistedWorlds;
    public boolean tryDetectionSoulbound;
    public List<String> skippedEnchantments;

    public ConfigData() {
        this.graveStyle = GravesLookType.PLAYER_HEAD.name;
        this.presetHeadLockedTexture = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjdjYWI1NmM4MmNiODFiZGI5OTc5YTQ2NGJjOWQzYmEzZTY3MjJiYTEyMmNmNmM1Mjg3MzAxMGEyYjU5YWVmZSJ9fX0=";
        this.presetHeadUnlockedTexture = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjdjYWI1NmM4MmNiODFiZGI5OTc5YTQ2NGJjOWQzYmEzZTY3MjJiYTEyMmNmNmM1Mjg3MzAxMGEyYjU5YWVmZSJ9fX0=";
        this.customBlockStateLockedStyles = List.of(GraveUtils.blockStateToString((class_2680)((class_2680)((class_2680)class_2246.field_10252.method_9564().method_11657((class_2769)class_2544.field_22157, (Comparable)class_4778.field_22179)).method_11657((class_2769)class_2544.field_22158, (Comparable)class_4778.field_22179)).method_11657((class_2769)class_2544.field_11717, (Comparable)Boolean.valueOf(true))), GraveUtils.blockStateToString((class_2680)((class_2680)((class_2680)class_2246.field_10252.method_9564().method_11657((class_2769)class_2544.field_22156, (Comparable)class_4778.field_22179)).method_11657((class_2769)class_2544.field_22159, (Comparable)class_4778.field_22179)).method_11657((class_2769)class_2544.field_11717, (Comparable)Boolean.valueOf(true))));
        this.customBlockStateUnlockedStyles = List.of(GraveUtils.blockStateToString((class_2680)((class_2680)((class_2680)class_2246.field_10059.method_9564().method_11657((class_2769)class_2544.field_22157, (Comparable)class_4778.field_22179)).method_11657((class_2769)class_2544.field_22158, (Comparable)class_4778.field_22179)).method_11657((class_2769)class_2544.field_11717, (Comparable)Boolean.valueOf(true))), GraveUtils.blockStateToString((class_2680)((class_2680)((class_2680)class_2246.field_10059.method_9564().method_11657((class_2769)class_2544.field_22156, (Comparable)class_4778.field_22179)).method_11657((class_2769)class_2544.field_22159, (Comparable)class_4778.field_22179)).method_11657((class_2769)class_2544.field_11717, (Comparable)Boolean.valueOf(true))));
        this.customStyleSignText = ConfigData.getDefaultSign();
        this.customStyleSignProtectedText = ConfigData.getDefaultProtectedSign();
        this.customStyleUpdateRate = 20;
        this.isProtected = true;
        this.protectionTime = 900;
        this.breakingTime = 1800;
        this.breakEmptyGraves = true;
        this.xpStorageType = GravesXPCalculation.PERCENT_POINTS.name;
        this.xpPercentTypeValue = 100.0;
        this.replaceAnyBlock = false;
        this.maxPlacementDistance = 8;
        this.createFromPvP = true;
        this.createFromVoid = true;
        this.createFromCommandDeaths = true;
        this.createInClaims = true;
        this.dropItemsAfterExpiring = true;
        this.shiftClickTakesItems = true;
        this.allowAttackersToTakeItems = false;
        this.graveTitle = "<lang:'text.graves.players_grave':'${player}'>";
        this.hologram = true;
        this.hologramOffset = 1.2;
        this.hologramProtectedText = ConfigData.getDefaultProtectedHologram();
        this.hologramText = ConfigData.getDefaultHologram();
        this.guiTitle = "<lang:'text.graves.gui_title':'${player}'>";
        this.guiProtectedText = ConfigData.getDefaultProtectedGui();
        this.guiText = ConfigData.getDefaultGui();
        this.guiProtectedItem = Collections.singletonList("chest");
        this.guiItem = Collections.singletonList("trapped_chest");
        this.messageGraveCreated = "<white><lang:'text.graves.created_at_expire':'<yellow>${position}':'<gray>${world}':'<red>${break_time}'>";
        this.messageProtectionEnded = "<red><lang:'text.graves.no_longer_protected':'<gold>${position}':'<white>${world}':'<yellow>${item_count}'>";
        this.messageGraveExpired = "<red><lang:'text.graves.expired':'<gold>${position}':'<white>${world}':'<yellow>${item_count}'>";
        this.messageGraveBroken = "<gray><lang:'text.graves.somebody_broke':'<white>${position}':'<white>${world}':'<white>${item_count}'>";
        this.messageCreationFailed = "<red><lang:'text.graves.creation_failed':'<gold>${position}':'<yellow>${world}'>";
        this.messageCreationFailedVoid = "<red><lang:'text.graves.creation_failed_void':'<gold>${position}':'<yellow>${world}'>";
        this.messageCreationFailedPvP = "<red><lang:'text.graves.creation_failed_pvp':'<gold>${position}':'<yellow>${world}'>";
        this.messageCreationFailedClaim = "<red><lang:'text.graves.creation_failed_claim':'<gold>${position}':'<yellow>${world}'>";
        this.yearsText = "y";
        this.daysText = "d";
        this.hoursText = "h";
        this.minutesText = "m";
        this.secondsText = "s";
        this.infinityText = "\u221e";
        this.worldNameOverrides = new HashMap<String, String>();
        this.blacklistedWorlds = new ArrayList<String>();
        this.tryDetectionSoulbound = true;
        this.skippedEnchantments = new ArrayList<String>();
    }

    private static List<String> getDefaultProtectedHologram() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("<gold><lang:'text.graves.grave_of':'<white>${player}'>");
        list.add("<yellow>${death_cause}");
        list.add("");
        list.add("<gray><lang:'text.graves.items_xp':'<white>${item_count}':'<white>${xp}'>");
        list.add("<blue><lang:'text.graves.protected_time':'<white>${protection_time}'>");
        list.add("<red><lang:'text.graves.break_time':'<white>${break_time}'>");
        return list;
    }

    private static List<String> getDefaultHologram() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("<gold><lang:'text.graves.grave_of':'<white>${player}'>");
        list.add("<yellow>${death_cause}");
        list.add("");
        list.add("<gray><lang:'text.graves.items_xp':'<white>${item_count}':'<white>${xp}'>");
        list.add("<blue><lang:'text.graves.not_protected'>");
        list.add("<red><lang:'text.graves.break_time':'<white>${break_time}'>");
        return list;
    }

    private static List<String> getDefaultProtectedGui() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("${position} <gray>(${world})");
        list.add("<yellow>${death_cause}");
        list.add("<gray><lang:'text.graves.items_xp':'<white>${item_count}':'<white>${xp}'>");
        list.add("<blue><lang:'text.graves.protected_time':'<white>${protection_time}'>");
        list.add("<red><lang:'text.graves.break_time':'<white>${break_time}'>");
        return list;
    }

    private static List<String> getDefaultGui() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("${position} <gray>(${world})");
        list.add("<yellow>${death_cause}");
        list.add("<gray><lang:'text.graves.items_xp':'<white>${item_count}':'<white>${xp}'>");
        list.add("<blue><lang:'text.graves.not_protected'>");
        list.add("<red><lang:'text.graves.break_time':'<white>${break_time}'>");
        return list;
    }

    private static List<String> getDefaultProtectedSign() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("<white>${player}");
        list.add("<gray><lang:'text.graves.items_xp':'<white>${item_count}':'<white>${xp}'>");
        list.add("<blue><lang:'text.graves.protected_time':''>");
        list.add("<white>${protection_time}");
        return list;
    }

    private static List<String> getDefaultSign() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("<white>${player}");
        list.add("<gray><lang:'text.graves.items_xp':'<white>${item_count}':'<white>${xp}'>");
        list.add("<red><lang:'text.graves.break_time':''>");
        list.add("<white>${break_time}");
        return list;
    }

    public ConfigData clone() {
        try {
            return (ConfigData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

