/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.config.data.old;

import eu.pb4.graves.config.data.ConfigData;
import eu.pb4.graves.config.data.VersionedConfigData;
import eu.pb4.graves.grave.GravesLookType;
import eu.pb4.graves.grave.GravesXPCalculation;
import java.util.ArrayList;
import java.util.List;

public class ConfigDataV1
extends VersionedConfigData {
    public String graveType;
    public String lockedTexture;
    public String unlockedTexture;
    public boolean isProtected;
    public boolean shouldProtectionExpire;
    public int protectionTime;
    public boolean shouldBreak;
    public int breakAfter;
    public boolean storeExperience;
    public String xpStorageType;
    public double xpPercentTypeValue;
    public boolean createGravesFromPvP;
    public boolean createGravesInClaims;
    public boolean dropItemsAfterExpiring;
    public boolean hologram;
    public List<String> hologramProtectedText;
    public List<String> hologramText;
    public String guiTitle;
    public List<String> guiProtectedText;
    public List<String> guiText;
    public boolean displayNoLongerProtectedMessage;
    public String noLongerProtectedMessage;
    public boolean displayGraveExpiredMessage;
    public String graveExpiredMessage;
    public boolean displayGraveBrokenMessage;
    public String graveBrokenMessage;
    public boolean displayCreatedGraveMessage;
    public String createdGraveMessage;
    public boolean displayCreationFailedGraveMessage;
    public String creationFailedGraveMessage;
    public boolean displayCreationFailedPvPGraveMessage;
    public String creationFailedPvPGraveMessage;
    public boolean displayCreationFailedClaimGraveMessage;
    public String creationFailedClaimMessage;
    public String neverExpires;
    public String yearsText;
    public String daysText;
    public String hoursText;
    public String minutesText;
    public String secondsText;
    public String graveTitle;

    public ConfigDataV1() {
        this.graveType = GravesLookType.PLAYER_HEAD.name;
        this.lockedTexture = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjdjYWI1NmM4MmNiODFiZGI5OTc5YTQ2NGJjOWQzYmEzZTY3MjJiYTEyMmNmNmM1Mjg3MzAxMGEyYjU5YWVmZSJ9fX0=";
        this.unlockedTexture = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjdjYWI1NmM4MmNiODFiZGI5OTc5YTQ2NGJjOWQzYmEzZTY3MjJiYTEyMmNmNmM1Mjg3MzAxMGEyYjU5YWVmZSJ9fX0=";
        this.isProtected = true;
        this.shouldProtectionExpire = true;
        this.protectionTime = 300;
        this.shouldBreak = true;
        this.breakAfter = 900;
        this.storeExperience = true;
        this.xpStorageType = GravesXPCalculation.VANILLA.name;
        this.xpPercentTypeValue = 100.0;
        this.createGravesFromPvP = true;
        this.createGravesInClaims = true;
        this.dropItemsAfterExpiring = true;
        this.hologram = true;
        this.hologramProtectedText = ConfigDataV1.getDefaultProtectedHologram();
        this.hologramText = ConfigDataV1.getDefaultHologram();
        this.guiTitle = "<lang:'text.graves.gui_title':'${player}'>";
        this.guiProtectedText = ConfigDataV1.getDefaultProtectedGui();
        this.guiText = ConfigDataV1.getDefaultGui();
        this.displayNoLongerProtectedMessage = true;
        this.noLongerProtectedMessage = "<red><lang:'text.graves.no_longer_protected':'<gold>${position}':'<white>${world}':'<yellow>${item_count}'>";
        this.displayGraveExpiredMessage = true;
        this.graveExpiredMessage = "<red><lang:'text.graves.expired':'<gold>${position}':'<white>${world}':'<yellow>${item_count}'>";
        this.displayGraveBrokenMessage = true;
        this.graveBrokenMessage = "<gray><lang:'text.graves.somebody_broke':'<white>${position}':'<white>${world}':'<white>${item_count}'>";
        this.displayCreatedGraveMessage = true;
        this.createdGraveMessage = "<white><lang:'text.graves.created_at':'<yellow>${position}':'<gray>${world}'>";
        this.displayCreationFailedGraveMessage = true;
        this.creationFailedGraveMessage = "<red><lang:'text.graves.creation_failed':'<gold>${position}':'<yellow>${world}'>";
        this.displayCreationFailedPvPGraveMessage = true;
        this.creationFailedPvPGraveMessage = "<red><lang:'text.graves.creation_failed_pvp':'<gold>${position}':'<yellow>${world}'>";
        this.displayCreationFailedClaimGraveMessage = true;
        this.creationFailedClaimMessage = "<red><lang:'text.graves.creation_failed_claim':'<gold>${position}':'<yellow>${world}'>";
        this.neverExpires = "Never";
        this.yearsText = "y";
        this.daysText = "d";
        this.hoursText = "h";
        this.minutesText = "m";
        this.secondsText = "s";
        this.graveTitle = "<lang:'text.graves.players_grave':'${player}'>";
    }

    private static List<String> getDefaultProtectedHologram() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("<gold><lang:'text.graves.grave_of':'<white>${player}'>");
        list.add("<yellow>${death_cause}");
        list.add("");
        list.add("<gray><lang:'text.graves.items_xp':'<white>${item_count}':'<white>${xp}'>");
        list.add("<blue><lang:'text.graves.protected_time':'<white>${protection_time}'>");
        list.add("<red><lang:'text.graves.break_time':'<white>${break_time}'>");
        return list;
    }

    private static List<String> getDefaultHologram() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("<gold><lang:'text.graves.grave_of':'<white>${player}'>");
        list.add("<yellow>${death_cause}");
        list.add("");
        list.add("<gray><lang:'text.graves.items_xp':'<white>${item_count}':'<white>${xp}'>");
        list.add("<blue><lang:'text.graves.not_protected'>");
        list.add("<red><lang:'text.graves.break_time':'<white>${break_time}'>");
        return list;
    }

    private static List<String> getDefaultProtectedGui() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("${position} <gray>(${world})");
        list.add("<yellow>${death_cause}");
        list.add("<gray><lang:'text.graves.items_xp':'<white>${item_count}':'<white>${xp}'>");
        list.add("<blue><lang:'text.graves.protected_time':'<white>${protection_time}'>");
        list.add("<red><lang:'text.graves.break_time':'<white>${break_time}'>");
        return list;
    }

    private static List<String> getDefaultGui() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("${position} <gray>(${world})");
        list.add("<yellow>${death_cause}");
        list.add("<gray><lang:'text.graves.items_xp':'<white>${item_count}':'<white>${xp}'>");
        list.add("<blue><lang:'text.graves.not_protected'>");
        list.add("<red><lang:'text.graves.break_time':'<white>${break_time}'>");
        return list;
    }

    public ConfigData update() {
        ConfigData config = new ConfigData();
        config.graveStyle = this.graveType;
        config.presetHeadUnlockedTexture = this.unlockedTexture;
        config.presetHeadLockedTexture = this.lockedTexture;
        config.isProtected = this.isProtected;
        config.protectionTime = this.shouldProtectionExpire ? this.protectionTime : -1;
        config.breakingTime = this.shouldBreak ? this.breakAfter : -1;
        config.xpStorageType = this.storeExperience ? this.xpStorageType : GravesXPCalculation.DROP.name;
        config.xpPercentTypeValue = this.xpPercentTypeValue;
        config.createFromPvP = this.createGravesFromPvP;
        config.createInClaims = this.createGravesInClaims;
        config.dropItemsAfterExpiring = this.dropItemsAfterExpiring;
        config.hologram = this.hologram;
        config.hologramProtectedText = this.hologramProtectedText;
        config.hologramText = this.hologramText;
        config.guiTitle = this.guiTitle;
        config.guiProtectedText = this.guiProtectedText;
        config.guiText = this.guiText;
        config.messageProtectionEnded = this.displayNoLongerProtectedMessage ? this.noLongerProtectedMessage : "";
        config.messageCreationFailed = this.displayCreationFailedGraveMessage ? this.creationFailedGraveMessage : "";
        config.messageGraveCreated = this.displayCreatedGraveMessage ? this.createdGraveMessage : "";
        config.messageGraveExpired = this.displayGraveExpiredMessage ? this.graveExpiredMessage : "";
        config.messageGraveBroken = this.displayGraveBrokenMessage ? this.graveBrokenMessage : "";
        config.messageCreationFailed = this.displayCreationFailedGraveMessage ? this.creationFailedGraveMessage : "";
        config.messageCreationFailedPvP = this.displayCreationFailedPvPGraveMessage ? this.creationFailedPvPGraveMessage : "";
        config.messageCreationFailedClaim = this.displayCreationFailedClaimGraveMessage ? this.creationFailedClaimMessage : "";
        config.yearsText = this.yearsText;
        config.daysText = this.daysText;
        config.hoursText = this.hoursText;
        config.minutesText = this.minutesText;
        config.secondsText = this.secondsText;
        config.graveTitle = this.graveTitle;
        return config;
    }
}

