/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.grave;

import com.mojang.authlib.GameProfile;
import eu.pb4.graves.config.Config;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.grave.GraveBlock;
import eu.pb4.graves.grave.GraveInfo;
import eu.pb4.graves.grave.GraveManager;
import eu.pb4.graves.grave.GravesLookType;
import eu.pb4.graves.other.ImplementedInventory;
import eu.pb4.holograms.api.elements.HologramElement;
import eu.pb4.holograms.api.elements.SpacingHologramElement;
import eu.pb4.holograms.api.holograms.WorldHologram;
import eu.pb4.placeholders.PlaceholderAPI;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1278;
import net.minecraft.class_1303;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class GraveBlockEntity
extends class_2586
implements ImplementedInventory,
class_1278 {
    public static class_2591<GraveBlockEntity> BLOCK_ENTITY_TYPE;
    public WorldHologram hologram = null;
    public class_2371<class_1799> stacks = class_2371.method_10213((int)0, (Object)class_1799.field_8037);
    public GraveInfo info = new GraveInfo();
    public class_2680 replacedBlockState = class_2246.field_10124.method_9564();

    public GraveBlockEntity(class_2338 pos, class_2680 state) {
        super(BLOCK_ENTITY_TYPE, pos, state);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.stacks;
    }

    public void setGrave(GameProfile profile, Collection<class_1799> itemStacks, int experience, class_2561 deathCause, class_2680 blockState, Collection<UUID> allowedUUIDs) {
        if (this.field_11863 == null || !(this.field_11863 instanceof class_3218)) {
            return;
        }
        GraveManager.INSTANCE.remove(this.info);
        this.stacks = class_2371.method_10213((int)(itemStacks.size() + 5), (Object)class_1799.field_8037);
        for (class_1799 stack : itemStacks) {
            this.addStack(stack);
        }
        this.replacedBlockState = blockState;
        this.info = new GraveInfo(profile, this.field_11867, Objects.requireNonNull(this.method_10997()).method_27983().method_29177(), System.currentTimeMillis() / 1000L, experience, itemStacks.size(), deathCause, allowedUUIDs);
        GraveManager.INSTANCE.add(this.info);
        this.method_5431();
        this.updateState();
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_2499 nbtList = new class_2499();
        for (class_1799 itemStack : this.stacks) {
            if (itemStack.method_7960()) continue;
            class_2487 nbtCompound = new class_2487();
            itemStack.method_7953(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        if (!nbtList.isEmpty()) {
            nbt.method_10566("Items", (class_2520)nbtList);
        }
        nbt.method_10566("GraveInfo", (class_2520)this.info.writeNbt(new class_2487()));
        nbt.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)this.replacedBlockState));
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        try {
            this.info.readNbt(nbt.method_10562("GraveInfo"));
            class_2499 nbtList = nbt.method_10554("Items", 10);
            this.stacks = class_2371.method_10213((int)(nbtList.size() + 5), (Object)class_1799.field_8037);
            for (class_2520 compound : nbtList) {
                this.addStack(class_1799.method_7915((class_2487)((class_2487)compound)));
            }
            this.updateItemCount();
            this.replacedBlockState = class_2512.method_10681((class_2487)((class_2487)Objects.requireNonNull(nbt.method_10580("BlockState"))));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onBroken() {
        if (this.hologram != null) {
            this.hologram.hide();
        }
        this.hologram = null;
        Config config = ConfigManager.getConfig();
        class_2561 text = null;
        boolean shouldBreak = this.info.shouldBreak();
        if (!shouldBreak) {
            if (config.graveBrokenMessage != null) {
                text = config.graveBrokenMessage;
            }
        } else if (config.graveExpiredMessage != null) {
            text = config.graveExpiredMessage;
        }
        if (text != null) {
            assert (this.field_11863 != null);
            class_3222 player = Objects.requireNonNull(this.field_11863.method_8503()).method_3760().method_14602(this.info.gameProfile.getId());
            if (player != null) {
                player.method_14254(PlaceholderAPI.parsePredefinedText((class_2561)text, (Pattern)PlaceholderAPI.PREDEFINED_PLACEHOLDER_PATTERN, this.info.getPlaceholders(this.field_11863.method_8503())), class_2556.field_11735, class_156.field_25140);
            }
        }
        GraveManager.INSTANCE.remove(this.info);
        if (config.configData.dropItemsAfterExpiring || !shouldBreak) {
            class_1264.method_5451((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1263)this);
            class_1303.method_31493((class_3218)((class_3218)this.field_11863), (class_243)class_243.method_24953((class_2382)this.method_11016()), (int)this.info.xp);
        }
    }

    public void updateItemCount() {
        int info;
        int x = 0;
        for (class_1799 stack : this.getItems()) {
            if (stack.method_7960()) continue;
            ++x;
        }
        this.info.itemCount = x;
        List<GraveInfo> infoList = GraveManager.INSTANCE.getByUuid(this.info.gameProfile.getId());
        if (infoList != null && (info = infoList.indexOf(this.info)) != -1) {
            infoList.get((int)info).itemCount = x;
        }
    }

    public void updateState() {
        if (this.method_5442() && !this.method_11015()) {
            assert (this.method_10997() != null);
            if (ConfigManager.getConfig().configData.breakEmptyGraves) {
                this.method_10997().method_8652(this.method_11016(), this.replacedBlockState, 3);
            } else {
                this.clearGrave();
                this.updateForPlayers();
            }
        } else {
            this.updateItemCount();
            this.updateForPlayers();
        }
    }

    protected void updateForPlayers() {
        assert (this.field_11863 != null);
        GravesLookType.Converter converter = ConfigManager.getConfig().style.converter;
        ((class_3218)this.field_11863).method_14178().field_17254.method_17210(new class_1923(this.field_11867), false).forEach(p -> converter.sendNbt((class_3222)p, this.method_11010(), this.field_11867, (Integer)this.method_11010().method_11654((class_2769)class_2741.field_12532), this.info.isProtected(), this.info));
    }

    public void method_11012() {
        if (this.hologram != null) {
            this.hologram.hide();
        }
        this.hologram = null;
        super.method_11012();
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T t) {
        int updateRate;
        GraveBlockEntity self;
        block20: {
            block19: {
                if (!(t instanceof GraveBlockEntity)) break block19;
                self = (GraveBlockEntity)t;
                if (!world.method_8608() && world.method_8510() % 5L == 0L) break block20;
            }
            return;
        }
        Config config = ConfigManager.getConfig();
        Map<String, class_2561> placeholders = self.info.getPlaceholders(self.field_11863.method_8503());
        if (config.configData.breakingTime > -1 && self.info.shouldBreak()) {
            world.method_8652(pos, self.replacedBlockState, 3);
            return;
        }
        boolean isProtected = (Boolean)state.method_11654((class_2769)GraveBlock.IS_LOCKED);
        if (isProtected && !self.info.isProtected()) {
            class_3222 player;
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)GraveBlock.IS_LOCKED, (Comparable)Boolean.valueOf(false)));
            isProtected = false;
            if (config.noLongerProtectedMessage != null && (player = Objects.requireNonNull(world.method_8503()).method_3760().method_14602(self.info.gameProfile.getId())) != null) {
                player.method_14254(PlaceholderAPI.parsePredefinedText((class_2561)config.noLongerProtectedMessage, (Pattern)PlaceholderAPI.PREDEFINED_PLACEHOLDER_PATTERN, placeholders), class_2556.field_11735, class_156.field_25140);
            }
            self.updateForPlayers();
        }
        if ((updateRate = config.style.converter.updateRate(state, pos, self.info)) > 0 && world.method_8510() % (long)updateRate == 0L) {
            self.updateForPlayers();
        }
        if (config.configData.hologram) {
            if (self.hologram == null) {
                self.hologram = new WorldHologram((class_3218)world, new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()).method_1031(0.5, config.configData.hologramOffset, 0.5));
                self.hologram.show();
            }
            ArrayList<class_2561> texts = new ArrayList<class_2561>();
            for (class_2561 text : isProtected ? config.hologramProtectedText : config.hologramText) {
                if (text != class_2585.field_24366) {
                    texts.add(PlaceholderAPI.parsePredefinedText((class_2561)text, (Pattern)PlaceholderAPI.PREDEFINED_PLACEHOLDER_PATTERN, placeholders));
                    continue;
                }
                texts.add(class_2585.field_24366);
            }
            int x = 0;
            for (class_2561 text : texts) {
                if (text == class_2585.field_24366) {
                    self.hologram.setElement(x, (HologramElement)new SpacingHologramElement(0.28));
                } else {
                    self.hologram.setText(x, text);
                }
                ++x;
            }
            int size = self.hologram.getElements().size();
            if (x < size) {
                while (x < size) {
                    self.hologram.removeElement(x);
                    ++x;
                }
            }
        } else if (self.hologram != null) {
            self.hologram.hide();
            self.hologram = null;
        }
    }

    public int[] method_5494(class_2350 side) {
        return IntArrays.EMPTY_ARRAY;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }

    public void clearGrave() {
        if (this.info.xp != 0) {
            class_1303.method_31493((class_3218)((class_3218)this.field_11863), (class_243)class_243.method_24953((class_2382)this.method_11016()), (int)this.info.xp);
            this.info.xp = 0;
        }
        if (this.info.itemCount != 0) {
            class_1264.method_5451((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1263)this);
            this.info.itemCount = 0;
        }
        GraveManager.INSTANCE.remove(this.info);
    }
}

