/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.grave;

import com.mojang.authlib.GameProfile;
import eu.pb4.graves.config.Config;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.other.GraveUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public final class GraveInfo {
    public static final GraveInfo DEFAULT = new GraveInfo();
    private static final class_2561 DEFAULT_DEATH_CAUSE = new class_2585("Unknown cause");
    private static final GameProfile DEFAULT_GAME_PROFILE = new GameProfile(UUID.fromString("9586e5ab-157a-4658-ad80-b07552a9ca63"), "Herobrine");
    protected GameProfile gameProfile;
    protected int xp;
    protected long creationTime;
    protected int itemCount;
    protected class_2561 deathCause;
    protected class_2338 position;
    protected class_2960 world;
    protected Set<UUID> allowedUUIDs;

    public GraveInfo() {
        this.gameProfile = DEFAULT_GAME_PROFILE;
        this.creationTime = Long.MAX_VALUE;
        this.xp = 0;
        this.itemCount = 0;
        this.deathCause = DEFAULT_DEATH_CAUSE;
        this.position = class_2338.field_10980;
        this.world = class_3218.field_25179.method_29177();
        this.allowedUUIDs = new HashSet<UUID>();
    }

    public GraveInfo(GameProfile profile, class_2338 position, class_2960 world, long creationTime, int xp, int itemCount, class_2561 deathCause, Collection<UUID> allowedUUIDs) {
        this.gameProfile = profile;
        this.creationTime = creationTime;
        this.xp = xp;
        this.itemCount = itemCount;
        this.deathCause = deathCause;
        this.position = position;
        this.world = world;
        this.allowedUUIDs = new HashSet<UUID>(allowedUUIDs);
    }

    public class_2487 writeNbt(class_2487 nbt) {
        if (this.gameProfile != null) {
            nbt.method_10566("GameProfile", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)this.gameProfile));
        }
        nbt.method_10569("XP", this.xp);
        nbt.method_10544("CreationTime", this.creationTime);
        nbt.method_10569("ItemCount", this.itemCount);
        nbt.method_10582("DeathCause", class_2561.class_2562.method_10867((class_2561)this.deathCause));
        nbt.method_10539("Position", new int[]{this.position.method_10263(), this.position.method_10264(), this.position.method_10260()});
        nbt.method_10582("World", this.world.toString());
        class_2499 list = new class_2499();
        for (UUID uuid : this.allowedUUIDs) {
            list.add((Object)class_2512.method_25929((UUID)uuid));
        }
        nbt.method_10566("AllowedUUIDs", (class_2520)list);
        return nbt;
    }

    public void readNbt(class_2487 nbt) {
        try {
            this.gameProfile = class_2512.method_10683((class_2487)nbt.method_10562("GameProfile"));
            this.xp = nbt.method_10550("XP");
            this.creationTime = nbt.method_10537("CreationTime");
            this.itemCount = nbt.method_10550("ItemCount");
            this.deathCause = class_2561.class_2562.method_10873((String)nbt.method_10558("DeathCause"));
            int[] pos = nbt.method_10561("Position");
            this.position = new class_2338(pos[0], pos[1], pos[2]);
            this.world = class_2960.method_12829((String)nbt.method_10558("World"));
            this.allowedUUIDs.clear();
            for (class_2520 nbtUUID : nbt.method_10554("AllowedUUIDs", 11)) {
                this.allowedUUIDs.add(class_2512.method_25930((class_2520)nbtUUID));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, class_2561> getPlaceholders(MinecraftServer server) {
        Config config = ConfigManager.getConfig();
        long currentTime = System.currentTimeMillis() / 1000L;
        long protectionTime = config.configData.protectionTime > -1 ? (long)config.configData.protectionTime - currentTime + this.creationTime : Long.MAX_VALUE;
        long breakTime = config.configData.breakingTime > -1 ? (long)config.configData.breakingTime - currentTime + this.creationTime : Long.MAX_VALUE;
        HashMap<String, class_2561> values = new HashMap<String, class_2561>();
        values.put("player", (class_2561)new class_2585(this.gameProfile != null ? this.gameProfile.getName() : "<No player!>"));
        values.put("protection_time", (class_2561)new class_2585(config.configData.protectionTime > -1 ? config.getFormattedTime(protectionTime) : config.configData.infinityText));
        values.put("break_time", (class_2561)new class_2585(config.configData.breakingTime > -1 ? config.getFormattedTime(breakTime) : config.configData.infinityText));
        values.put("xp", (class_2561)new class_2585("" + this.xp));
        values.put("item_count", (class_2561)new class_2585("" + this.itemCount));
        values.put("position", (class_2561)new class_2585(this.position.method_23854()));
        values.put("world", GraveUtils.toWorldName(this.world));
        values.put("death_cause", this.deathCause);
        return values;
    }

    public boolean shouldBreak() {
        Config config = ConfigManager.getConfig();
        if (config.configData.breakingTime > -1) {
            long currentTime = System.currentTimeMillis() / 1000L;
            long breakTime = (long)config.configData.breakingTime - currentTime + this.creationTime;
            return breakTime <= 0L;
        }
        return false;
    }

    public boolean isProtected() {
        Config config = ConfigManager.getConfig();
        if (config.configData.protectionTime > -1 && config.configData.isProtected) {
            long currentTime = System.currentTimeMillis() / 1000L;
            long protectionTime = (long)config.configData.protectionTime - currentTime + this.creationTime;
            return protectionTime > 0L;
        }
        return config.configData.isProtected;
    }

    public boolean canTakeFrom(class_1657 entity) {
        return !this.isProtected() || this.gameProfile.getId().equals(entity.method_5667()) || this.allowedUUIDs.contains(entity.method_5667()) || Permissions.check((class_1297)entity, (String)"graves.can_open_others", (int)3);
    }

    public GameProfile getProfile() {
        return this.gameProfile;
    }

    public int getXp() {
        return this.xp;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public class_2561 getDeathCause() {
        return this.deathCause;
    }

    public class_2338 getPosition() {
        return this.position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraveInfo graveInfo = (GraveInfo)o;
        return Objects.equals(this.position, graveInfo.position);
    }

    public int hashCode() {
        return this.position.hashCode();
    }

    public class_2960 getWorld() {
        return this.world;
    }
}

