/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.grave;

import eu.pb4.graves.grave.GraveInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class GraveManager
extends class_18 {
    public static GraveManager INSTANCE;
    private HashMap<UUID, List<GraveInfo>> byUuid = new HashMap();
    private HashMap<class_2338, GraveInfo> byPos = new HashMap();
    private HashSet<GraveInfo> graves = new HashSet();
    private long ticker;

    public void add(GraveInfo info) {
        this.byUuid.computeIfAbsent(info.gameProfile.getId(), v -> new ArrayList()).add(0, info);
        this.byPos.put(info.position, info);
        this.graves.add(info);
        this.method_80();
    }

    public void remove(GraveInfo info) {
        if (this.graves.remove(info)) {
            List<GraveInfo> graveInfoList = this.byUuid.get(info.gameProfile.getId());
            this.byPos.remove(info.position);
            if (graveInfoList != null) {
                graveInfoList.remove(info);
                if (graveInfoList.isEmpty()) {
                    this.byUuid.remove(info.gameProfile.getId());
                }
            }
            this.method_80();
        }
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (GraveInfo grave : new ArrayList<GraveInfo>(this.graves)) {
            if (grave.shouldBreak()) continue;
            list.add((Object)grave.writeNbt(new class_2487()));
        }
        nbt.method_10566("Graves", (class_2520)list);
        nbt.method_10569("Version", 1);
        return nbt;
    }

    public static class_18 fromNbt(class_2487 nbt) {
        GraveManager manager = new GraveManager();
        class_2499 graves = nbt.method_10554("Graves", 10);
        for (class_2520 graveNbt : graves) {
            GraveInfo graveInfo = new GraveInfo();
            graveInfo.readNbt((class_2487)graveNbt);
            if (graveInfo.shouldBreak()) continue;
            manager.add(graveInfo);
        }
        return manager;
    }

    public List<GraveInfo> getByUuid(UUID uuid) {
        List<GraveInfo> graveInfoList = this.byUuid.get(uuid);
        if (graveInfoList != null) {
            graveInfoList.removeIf(g -> g.shouldBreak());
            return graveInfoList;
        }
        return Collections.emptyList();
    }

    public GraveInfo getByPos(class_2338 pos) {
        return this.byPos.get(pos);
    }

    public Collection<GraveInfo> getAll() {
        return this.graves;
    }

    public void tick() {
        ++this.ticker;
    }
}

