/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.grave;

import com.mojang.authlib.GameProfile;
import eu.pb4.graves.config.Config;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.grave.GraveInfo;
import eu.pb4.placeholders.PlaceholderAPI;
import eu.pb4.polymer.mixin.block.BlockEntityUpdateS2CPacketAccessor;
import fr.catcore.server.translations.api.LocalizationTarget;
import fr.catcore.server.translations.api.text.LocalizableText;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.class_156;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2435;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3708;
import net.minecraft.class_3737;

public final class GravesLookType {
    private static final List<GravesLookType> VALUES = new ArrayList<GravesLookType>();
    public static final GravesLookType CHEST = new GravesLookType("chest", GravesLookType.getChestLike(class_2246.field_10034.method_9564(), class_2246.field_10380.method_9564()));
    public static final GravesLookType BARREL = new GravesLookType("barrel", GravesLookType.getChestLike((class_2680)class_2246.field_16328.method_9564().method_11657((class_2769)class_3708.field_18006, (Comparable)Boolean.valueOf(true)), class_2246.field_16328.method_9564()));
    public static final GravesLookType PLAYER_HEAD = new GravesLookType("player_head", new Converter(){

        @Override
        public class_2248 getBlock(boolean isLocked) {
            return class_2246.field_10432;
        }

        @Override
        public class_2680 getBlockState(int direction, boolean isLocked, boolean waterlogged) {
            return (class_2680)this.getBlock(isLocked).method_9564().method_11657((class_2769)class_2435.field_11505, (Comparable)Integer.valueOf(direction));
        }

        @Override
        public void sendNbt(class_3222 player, class_2680 state, class_2338 pos, int direction, boolean isLocked, GraveInfo graveInfo) {
            if (graveInfo.gameProfile != null) {
                class_2487 nbt = new class_2487();
                class_2487 nbtCompound = new class_2487();
                class_2512.method_10684((class_2487)nbtCompound, (GameProfile)graveInfo.gameProfile);
                nbt.method_10566("SkullOwner", (class_2520)nbtCompound);
                GravesLookType.sendHeadToPlayer(player, pos, nbt);
            }
        }
    });
    public static final GravesLookType PRESET_HEAD = new GravesLookType("preset_head", new Converter(){

        @Override
        public class_2248 getBlock(boolean isLocked) {
            return class_2246.field_10432;
        }

        @Override
        public class_2680 getBlockState(int direction, boolean isLocked, boolean waterlogged) {
            return (class_2680)this.getBlock(isLocked).method_9564().method_11657((class_2769)class_2435.field_11505, (Comparable)Integer.valueOf(direction));
        }

        @Override
        public void sendNbt(class_3222 player, class_2680 state, class_2338 pos, int direction, boolean isLocked, GraveInfo graveInfo) {
            class_2487 nbt = new class_2487();
            class_2487 skullOwner = new class_2487();
            class_2487 properties = new class_2487();
            class_2487 valueData = new class_2487();
            class_2499 textures = new class_2499();
            valueData.method_10582("Value", isLocked ? ConfigManager.getConfig().configData.presetHeadLockedTexture : ConfigManager.getConfig().configData.presetHeadUnlockedTexture);
            textures.add((Object)valueData);
            properties.method_10566("textures", (class_2520)textures);
            skullOwner.method_10566("Id", (class_2520)class_2512.method_25929((UUID)class_156.field_25140));
            skullOwner.method_10566("Properties", (class_2520)properties);
            nbt.method_10566("SkullOwner", (class_2520)skullOwner);
            GravesLookType.sendHeadToPlayer(player, pos, nbt);
        }
    });
    public static final GravesLookType CUSTOM = new GravesLookType("custom", new Converter(){

        @Override
        public class_2248 getBlock(boolean isLocked) {
            Config config = ConfigManager.getConfig();
            return config.customBlockStateStylesUnlocked[0].state().method_26204();
        }

        @Override
        public class_2680 getBlockState(int direction, boolean isLocked, boolean waterlogged) {
            Config config = ConfigManager.getConfig();
            Config.BlockStyleEntry[] list = isLocked ? config.customBlockStateStylesLocked : config.customBlockStateStylesUnlocked;
            class_2680 state = list[direction % list.length].state();
            return state.method_26204() instanceof class_3737 ? (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(waterlogged)) : state;
        }

        @Override
        public void sendNbt(class_3222 player, class_2680 state, class_2338 pos, int direction, boolean isLocked, GraveInfo graveInfo) {
            Config config = ConfigManager.getConfig();
            Config.BlockStyleEntry[] list = isLocked ? config.customBlockStateStylesLocked : config.customBlockStateStylesUnlocked;
            Config.BlockStyleEntry entry = list[direction % list.length];
            if (entry.blockEntityType() != null && entry.blockEntityNbt() != null) {
                class_2487 compound = entry.blockEntityNbt().method_10553();
                class_2561[] texts = isLocked ? config.signProtectedText : config.signText;
                Map<String, class_2561> placeholders = graveInfo.getPlaceholders(player.method_5682());
                int size = Math.min(4, texts.length);
                LocalizationTarget target = (LocalizationTarget)player;
                for (int i = 0; i < size; ++i) {
                    compound.method_10582("Text" + (i + 1), class_2561.class_2562.method_10867((class_2561)LocalizableText.asLocalizedFor((class_2561)PlaceholderAPI.parsePredefinedText((class_2561)texts[i], (Pattern)PlaceholderAPI.PREDEFINED_PLACEHOLDER_PATTERN, placeholders), (LocalizationTarget)target)));
                }
                compound.method_10569("x", pos.method_10263());
                compound.method_10569("y", pos.method_10264());
                compound.method_10569("z", pos.method_10260());
                player.field_13987.method_14364((class_2596)BlockEntityUpdateS2CPacketAccessor.createBlockEntityUpdateS2CPacket((class_2338)pos, entry.blockEntityType(), (class_2487)compound));
            }
        }

        @Override
        public int updateRate(class_2680 state, class_2338 pos, GraveInfo graveInfo) {
            return ConfigManager.getConfig().configData.customStyleUpdateRate;
        }
    });
    public final String name;
    public final Converter converter;

    private GravesLookType(String name, Converter converter) {
        this.name = name;
        this.converter = converter;
        VALUES.add(this);
    }

    public static GravesLookType create(class_2960 identifier, Converter converter) {
        return new GravesLookType(identifier.toString(), converter);
    }

    public static GravesLookType byName(String name) {
        for (GravesLookType type : VALUES) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        return PRESET_HEAD;
    }

    private static Converter getChestLike(final class_2680 unlocked, final class_2680 locked) {
        return new Converter(){

            @Override
            public class_2248 getBlock(boolean isLocked) {
                return isLocked ? locked.method_26204() : unlocked.method_26204();
            }

            @Override
            public class_2680 getBlockState(int rotation, boolean isLocked, boolean waterlogged) {
                boolean chest = this.getBlock(isLocked) instanceof class_2281;
                class_2350 direction = chest ? class_2350.method_10139((int)(rotation / 4)).method_10153() : class_2350.method_10143((int)(rotation / 6));
                class_2680 state = (class_2680)(isLocked ? locked : unlocked).method_11657((class_2769)(chest ? class_2281.field_10768 : class_2741.field_12525), (Comparable)direction);
                return state.method_26204() instanceof class_3737 ? (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(waterlogged)) : state;
            }

            @Override
            public void sendNbt(class_3222 player, class_2680 state, class_2338 pos, int direction, boolean isLocked, GraveInfo graveInfo) {
            }
        };
    }

    public static void sendHeadToPlayer(class_3222 player, class_2338 pos, class_2487 compound) {
        if (compound != null) {
            compound.method_10582("id", "minecraft:skull");
            compound.method_10569("x", pos.method_10263());
            compound.method_10569("y", pos.method_10264());
            compound.method_10569("z", pos.method_10260());
            player.field_13987.method_14364((class_2596)BlockEntityUpdateS2CPacketAccessor.createBlockEntityUpdateS2CPacket((class_2338)pos, (class_2591)class_2591.field_11913, (class_2487)compound));
        }
    }

    public static interface Converter {
        public class_2248 getBlock(boolean var1);

        public class_2680 getBlockState(int var1, boolean var2, boolean var3);

        public void sendNbt(class_3222 var1, class_2680 var2, class_2338 var3, int var4, boolean var5, GraveInfo var6);

        default public int updateRate(class_2680 state, class_2338 pos, GraveInfo graveInfo) {
            return -1;
        }
    }
}

